/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.RequestNotifier;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class HttpDestination
implements Destination,
Closeable,
Dumpable {
    protected static final Logger LOG = Log.getLogger(HttpDestination.class);
    private final HttpClient client;
    private final Origin origin;
    private final Queue<HttpExchange> exchanges;
    private final RequestNotifier requestNotifier;
    private final ResponseNotifier responseNotifier;
    private final ProxyConfiguration.Proxy proxy;
    private final ClientConnectionFactory connectionFactory;
    private final HttpField hostField;

    public HttpDestination(HttpClient client, Origin origin) {
        this.client = client;
        this.origin = origin;
        this.exchanges = new BlockingArrayQueue(client.getMaxRequestsQueuedPerDestination());
        this.requestNotifier = new RequestNotifier(client);
        this.responseNotifier = new ResponseNotifier(client);
        ProxyConfiguration proxyConfig = client.getProxyConfiguration();
        this.proxy = proxyConfig.match(origin);
        HttpClientTransport connectionFactory = client.getTransport();
        if (this.proxy != null) {
            connectionFactory = this.proxy.newClientConnectionFactory(connectionFactory);
        } else if (HttpScheme.HTTPS.is(this.getScheme())) {
            connectionFactory = this.newSslClientConnectionFactory(connectionFactory);
        }
        this.connectionFactory = connectionFactory;
        String host = this.getHost();
        if (!client.isDefaultPort(this.getScheme(), this.getPort())) {
            host = host + ":" + this.getPort();
        }
        this.hostField = new HttpField(HttpHeader.HOST, host);
    }

    protected ClientConnectionFactory newSslClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return new SslClientConnectionFactory(this.client.getSslContextFactory(), this.client.getByteBufferPool(), this.client.getExecutor(), connectionFactory);
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Queue<HttpExchange> getHttpExchanges() {
        return this.exchanges;
    }

    public RequestNotifier getRequestNotifier() {
        return this.requestNotifier;
    }

    public ResponseNotifier getResponseNotifier() {
        return this.responseNotifier;
    }

    public ProxyConfiguration.Proxy getProxy() {
        return this.proxy;
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public String getScheme() {
        return this.origin.getScheme();
    }

    @Override
    public String getHost() {
        return this.origin.getAddress().getHost();
    }

    @Override
    public int getPort() {
        return this.origin.getAddress().getPort();
    }

    public Origin.Address getConnectAddress() {
        return this.proxy == null ? this.origin.getAddress() : this.proxy.getAddress();
    }

    public HttpField getHostField() {
        return this.hostField;
    }

    protected void send(HttpRequest request, List<Response.ResponseListener> listeners) {
        if (!this.getScheme().equals(request.getScheme())) {
            throw new IllegalArgumentException("Invalid request scheme " + request.getScheme() + " for destination " + this);
        }
        if (!this.getHost().equals(request.getHost())) {
            throw new IllegalArgumentException("Invalid request host " + request.getHost() + " for destination " + this);
        }
        int port = request.getPort();
        if (port >= 0 && this.getPort() != port) {
            throw new IllegalArgumentException("Invalid request port " + port + " for destination " + this);
        }
        HttpExchange exchange = new HttpExchange(this, request, listeners);
        if (this.client.isRunning()) {
            if (this.exchanges.offer(exchange)) {
                if (!this.client.isRunning() && this.exchanges.remove(exchange)) {
                    request.abort(new RejectedExecutionException((Object)((Object)this.client) + " is stopping"));
                } else {
                    LOG.debug("Queued {}", new Object[]{request});
                    this.requestNotifier.notifyQueued(request);
                    this.send();
                }
            } else {
                LOG.debug("Max queue size {} exceeded by {}", new Object[]{this.client.getMaxRequestsQueuedPerDestination(), request});
                request.abort(new RejectedExecutionException("Max requests per destination " + this.client.getMaxRequestsQueuedPerDestination() + " exceeded for " + this));
            }
        } else {
            request.abort(new RejectedExecutionException((Object)((Object)this.client) + " is stopped"));
        }
    }

    protected abstract void send();

    @Override
    public void newConnection(Promise<Connection> promise) {
        this.createConnection(promise);
    }

    protected void createConnection(Promise<Connection> promise) {
        this.client.newConnection(this, promise);
    }

    public boolean remove(HttpExchange exchange) {
        return this.exchanges.remove(exchange);
    }

    @Override
    public void close() {
        this.abort(new AsynchronousCloseException());
        LOG.debug("Closed {}", new Object[]{this});
    }

    public void close(Connection connection) {
    }

    public void abort(Throwable cause) {
        HttpExchange exchange;
        while ((exchange = this.exchanges.peek()) != null) {
            exchange.getRequest().abort(cause);
        }
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject((Appendable)out, (Object)(this + " - requests queued: " + this.exchanges.size()));
    }

    public String asString() {
        return this.origin.asString();
    }

    public String toString() {
        return String.format("%s(%s)%s", HttpDestination.class.getSimpleName(), this.asString(), this.proxy == null ? "" : " via " + this.proxy);
    }
}

