/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public abstract class PoolingHttpDestination<C extends Connection>
extends HttpDestination
implements Promise<Connection> {
    private final ConnectionPool connectionPool;

    public PoolingHttpDestination(HttpClient client, Origin origin) {
        super(client, origin);
        this.connectionPool = this.newConnectionPool(client);
    }

    protected ConnectionPool newConnectionPool(HttpClient client) {
        return new ConnectionPool(this, client.getMaxConnectionsPerDestination(), this);
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public void succeeded(Connection connection) {
        this.process(connection, true);
    }

    public void failed(final Throwable x) {
        this.getHttpClient().getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                PoolingHttpDestination.this.abort(x);
            }
        });
    }

    @Override
    protected void send() {
        C connection = this.acquire();
        if (connection != null) {
            this.process(connection, false);
        }
    }

    public C acquire() {
        return (C)this.connectionPool.acquire();
    }

    public void process(C connection, boolean dispatch) {
        HttpClient client = this.getHttpClient();
        HttpExchange exchange = this.getHttpExchanges().poll();
        LOG.debug("Processing exchange {} on connection {}", new Object[]{exchange, connection});
        if (exchange == null) {
            if (!this.connectionPool.release((Connection)connection)) {
                connection.close();
            }
            if (!client.isRunning()) {
                LOG.debug("{} is stopping", new Object[]{client});
                connection.close();
            }
        } else {
            Request request = exchange.getRequest();
            Throwable cause = request.getAbortCause();
            if (cause != null) {
                LOG.debug("Aborted before processing {}: {}", new Object[]{exchange, cause});
                exchange.abort(cause);
            } else if (dispatch) {
                client.getExecutor().execute(new Runnable((Connection)connection, exchange){
                    final /* synthetic */ Connection val$connection;
                    final /* synthetic */ HttpExchange val$exchange;
                    {
                        this.val$connection = connection;
                        this.val$exchange = httpExchange;
                    }

                    @Override
                    public void run() {
                        PoolingHttpDestination.this.send(this.val$connection, this.val$exchange);
                    }
                });
            } else {
                this.send(connection, exchange);
            }
        }
    }

    protected abstract void send(C var1, HttpExchange var2);

    public void release(C connection) {
        LOG.debug("{} released", new Object[]{connection});
        HttpClient client = this.getHttpClient();
        if (client.isRunning()) {
            if (this.connectionPool.isActive((Connection)connection)) {
                this.process(connection, false);
            } else {
                LOG.debug("{} explicit", new Object[]{connection});
            }
        } else {
            LOG.debug("{} is stopped", new Object[]{client});
            this.close((Connection)connection);
            connection.close();
        }
    }

    @Override
    public void close(Connection oldConnection) {
        C newConnection;
        super.close(oldConnection);
        this.connectionPool.remove(oldConnection);
        if (!this.getHttpExchanges().isEmpty() && (newConnection = this.acquire()) != null) {
            this.process(newConnection, false);
        }
    }

    @Override
    public void close() {
        super.close();
        this.connectionPool.close();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Arrays.asList(this.connectionPool)});
    }
}

