/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class HttpReceiver {
    protected static final Logger LOG = Log.getLogger(HttpReceiver.class);
    private final AtomicReference<ResponseState> responseState = new AtomicReference<ResponseState>(ResponseState.IDLE);
    private final HttpChannel channel;
    private volatile ContentDecoder decoder;

    protected HttpReceiver(HttpChannel channel) {
        this.channel = channel;
    }

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    protected HttpDestination getHttpDestination() {
        return this.channel.getHttpDestination();
    }

    protected boolean responseBegin(HttpExchange exchange) {
        if (!this.updateResponseState(ResponseState.IDLE, ResponseState.BEGIN)) {
            return false;
        }
        HttpConversation conversation = exchange.getConversation();
        HttpResponse response = exchange.getResponse();
        HttpDestination destination = this.getHttpDestination();
        HttpClient client = destination.getHttpClient();
        ProtocolHandler protocolHandler = client.findProtocolHandler(exchange.getRequest(), response);
        Response.Listener handlerListener = null;
        if (protocolHandler != null) {
            handlerListener = protocolHandler.getResponseListener();
            LOG.debug("Found protocol handler {}", new Object[]{protocolHandler});
        }
        exchange.getConversation().updateResponseListeners(handlerListener);
        LOG.debug("Response begin {}", new Object[]{response});
        ResponseNotifier notifier = destination.getResponseNotifier();
        notifier.notifyBegin(conversation.getResponseListeners(), (Response)response);
        return true;
    }

    protected boolean responseHeader(HttpExchange exchange, HttpField field) {
        block6: while (true) {
            ResponseState current = this.responseState.get();
            switch (current) {
                case BEGIN: 
                case HEADER: {
                    if (!this.updateResponseState(current, ResponseState.HEADER)) continue block6;
                    break block6;
                }
                default: {
                    return false;
                }
            }
            break;
        }
        HttpResponse response = exchange.getResponse();
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        boolean process = notifier.notifyHeader(exchange.getConversation().getResponseListeners(), (Response)response, field);
        if (process) {
            response.getHeaders().add(field);
            HttpHeader fieldHeader = field.getHeader();
            if (fieldHeader != null) {
                switch (fieldHeader) {
                    case SET_COOKIE: 
                    case SET_COOKIE2: {
                        this.storeCookie(exchange.getRequest().getURI(), field);
                        break;
                    }
                }
            }
        }
        return true;
    }

    protected void storeCookie(URI uri, HttpField field) {
        try {
            String value = field.getValue();
            if (value != null) {
                HashMap<String, List<String>> header = new HashMap<String, List<String>>(1);
                header.put(field.getHeader().asString(), Collections.singletonList(value));
                this.getHttpDestination().getHttpClient().getCookieManager().put(uri, header);
            }
        }
        catch (IOException x) {
            LOG.debug((Throwable)x);
        }
    }

    protected boolean responseHeaders(HttpExchange exchange) {
        block3: while (true) {
            ResponseState current = this.responseState.get();
            switch (current) {
                case BEGIN: 
                case HEADER: {
                    if (!this.updateResponseState(current, ResponseState.HEADERS)) continue block3;
                    break block3;
                }
                default: {
                    return false;
                }
            }
            break;
        }
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response headers {}{}{}", new Object[]{response, System.lineSeparator(), response.getHeaders().toString().trim()});
        }
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        notifier.notifyHeaders(exchange.getConversation().getResponseListeners(), (Response)response);
        Enumeration contentEncodings = response.getHeaders().getValues(HttpHeader.CONTENT_ENCODING.asString(), ",");
        if (contentEncodings != null) {
            block4: for (ContentDecoder.Factory factory : this.getHttpDestination().getHttpClient().getContentDecoderFactories()) {
                while (contentEncodings.hasMoreElements()) {
                    if (!factory.getEncoding().equalsIgnoreCase((String)contentEncodings.nextElement())) continue;
                    this.decoder = factory.newContentDecoder();
                    continue block4;
                }
            }
        }
        return true;
    }

    protected boolean responseContent(HttpExchange exchange, ByteBuffer buffer, Callback callback) {
        ContentDecoder decoder;
        block3: while (true) {
            ResponseState current = this.responseState.get();
            switch (current) {
                case HEADERS: 
                case CONTENT: {
                    if (!this.updateResponseState(current, ResponseState.CONTENT)) continue block3;
                    break block3;
                }
                default: {
                    return false;
                }
            }
            break;
        }
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response content {}{}{}", new Object[]{response, System.lineSeparator(), BufferUtil.toDetailString((ByteBuffer)buffer)});
        }
        if ((decoder = this.decoder) != null) {
            buffer = decoder.decode(buffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response content decoded ({}) {}{}{}", new Object[]{decoder, response, System.lineSeparator(), BufferUtil.toDetailString((ByteBuffer)buffer)});
            }
        }
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        notifier.notifyContent(exchange.getConversation().getResponseListeners(), (Response)response, buffer, callback);
        return true;
    }

    protected boolean responseSuccess(HttpExchange exchange) {
        boolean completed = exchange.responseComplete();
        if (!completed) {
            return false;
        }
        this.reset();
        Result result = exchange.terminateResponse(null);
        HttpResponse response = exchange.getResponse();
        LOG.debug("Response success {}", new Object[]{response});
        List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        notifier.notifySuccess(listeners, (Response)response);
        if (result != null) {
            boolean ordered = this.getHttpDestination().getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(result);
            }
            LOG.debug("Request/Response succeeded {}", new Object[]{response});
            notifier.notifyComplete(listeners, result);
            if (ordered) {
                this.channel.exchangeTerminated(result);
            }
        }
        return true;
    }

    protected boolean responseFailure(Throwable failure) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        boolean completed = exchange.responseComplete();
        if (!completed) {
            return false;
        }
        this.dispose();
        Result result = exchange.terminateResponse(failure);
        HttpResponse response = exchange.getResponse();
        LOG.debug("Response failure {} {}", new Object[]{response, failure});
        List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        notifier.notifyFailure(listeners, (Response)response, failure);
        if (result != null) {
            boolean ordered = this.getHttpDestination().getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(result);
            }
            LOG.debug("Request/Response failed {}", new Object[]{response});
            notifier.notifyComplete(listeners, result);
            if (ordered) {
                this.channel.exchangeTerminated(result);
            }
        }
        return true;
    }

    protected void reset() {
        this.decoder = null;
        this.responseState.set(ResponseState.IDLE);
    }

    protected void dispose() {
        this.decoder = null;
        this.responseState.set(ResponseState.FAILURE);
    }

    public boolean abort(Throwable cause) {
        return this.responseFailure(cause);
    }

    private boolean updateResponseState(ResponseState from, ResponseState to) {
        boolean updated = this.responseState.compareAndSet(from, to);
        if (!updated) {
            LOG.debug("State update failed: {} -> {}: {}", new Object[]{from, to, this.responseState.get()});
        }
        return updated;
    }

    private static enum ResponseState {
        IDLE,
        BEGIN,
        HEADER,
        HEADERS,
        CONTENT,
        FAILURE;

    }
}

