/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.RequestNotifier;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public abstract class HttpDestination
extends ContainerLifeCycle
implements Destination,
Closeable,
Dumpable {
    protected static final Logger LOG = Log.getLogger(HttpDestination.class);
    private final HttpClient client;
    private final Origin origin;
    private final Queue<HttpExchange> exchanges;
    private final RequestNotifier requestNotifier;
    private final ResponseNotifier responseNotifier;
    private final ProxyConfiguration.Proxy proxy;
    private final ClientConnectionFactory connectionFactory;
    private final HttpField hostField;

    public HttpDestination(HttpClient client, Origin origin) {
        this.client = client;
        this.origin = origin;
        this.exchanges = this.newExchangeQueue(client);
        this.requestNotifier = new RequestNotifier(client);
        this.responseNotifier = new ResponseNotifier();
        ProxyConfiguration proxyConfig = client.getProxyConfiguration();
        this.proxy = proxyConfig.match(origin);
        HttpClientTransport connectionFactory = client.getTransport();
        if (this.proxy != null) {
            connectionFactory = this.proxy.newClientConnectionFactory(connectionFactory);
        } else if (HttpScheme.HTTPS.is(this.getScheme())) {
            connectionFactory = this.newSslClientConnectionFactory(connectionFactory);
        }
        this.connectionFactory = connectionFactory;
        String host = this.getHost();
        if (!client.isDefaultPort(this.getScheme(), this.getPort())) {
            host = host + ":" + this.getPort();
        }
        this.hostField = new HttpField(HttpHeader.HOST, host);
    }

    protected Queue<HttpExchange> newExchangeQueue(HttpClient client) {
        return new BlockingArrayQueue(client.getMaxRequestsQueuedPerDestination());
    }

    protected ClientConnectionFactory newSslClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return new SslClientConnectionFactory(this.client.getSslContextFactory(), this.client.getByteBufferPool(), this.client.getExecutor(), connectionFactory);
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Queue<HttpExchange> getHttpExchanges() {
        return this.exchanges;
    }

    public RequestNotifier getRequestNotifier() {
        return this.requestNotifier;
    }

    public ResponseNotifier getResponseNotifier() {
        return this.responseNotifier;
    }

    public ProxyConfiguration.Proxy getProxy() {
        return this.proxy;
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    @ManagedAttribute(value="The destination scheme", readonly=true)
    public String getScheme() {
        return this.origin.getScheme();
    }

    @Override
    @ManagedAttribute(value="The destination host", readonly=true)
    public String getHost() {
        return this.origin.getAddress().getHost();
    }

    @Override
    @ManagedAttribute(value="The destination port", readonly=true)
    public int getPort() {
        return this.origin.getAddress().getPort();
    }

    @ManagedAttribute(value="The number of queued requests", readonly=true)
    public int getQueuedRequestCount() {
        return this.exchanges.size();
    }

    public Origin.Address getConnectAddress() {
        return this.proxy == null ? this.origin.getAddress() : this.proxy.getAddress();
    }

    public HttpField getHostField() {
        return this.hostField;
    }

    protected void send(HttpRequest request, List<Response.ResponseListener> listeners) {
        if (!this.getScheme().equalsIgnoreCase(request.getScheme())) {
            throw new IllegalArgumentException("Invalid request scheme " + request.getScheme() + " for destination " + this);
        }
        if (!this.getHost().equalsIgnoreCase(request.getHost())) {
            throw new IllegalArgumentException("Invalid request host " + request.getHost() + " for destination " + this);
        }
        int port = request.getPort();
        if (port >= 0 && this.getPort() != port) {
            throw new IllegalArgumentException("Invalid request port " + port + " for destination " + this);
        }
        HttpExchange exchange = new HttpExchange(this, request, listeners);
        if (this.client.isRunning()) {
            if (this.enqueue(this.exchanges, exchange)) {
                if (!this.client.isRunning() && this.exchanges.remove(exchange)) {
                    request.abort(new RejectedExecutionException((Object)((Object)this.client) + " is stopping"));
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Queued {} for {}", new Object[]{request, this});
                    }
                    this.requestNotifier.notifyQueued(request);
                    this.send();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Max queue size {} exceeded by {} for {}", new Object[]{this.client.getMaxRequestsQueuedPerDestination(), request, this});
                }
                request.abort(new RejectedExecutionException("Max requests per destination " + this.client.getMaxRequestsQueuedPerDestination() + " exceeded for " + this));
            }
        } else {
            request.abort(new RejectedExecutionException((Object)((Object)this.client) + " is stopped"));
        }
    }

    protected boolean enqueue(Queue<HttpExchange> queue, HttpExchange exchange) {
        return queue.offer(exchange);
    }

    public abstract void send();

    @Override
    public void newConnection(Promise<Connection> promise) {
        this.createConnection(promise);
    }

    protected void createConnection(Promise<Connection> promise) {
        this.client.newConnection(this, promise);
    }

    public boolean remove(HttpExchange exchange) {
        return this.exchanges.remove(exchange);
    }

    @Override
    public void close() {
        this.abort(new AsynchronousCloseException());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closed {}", new Object[]{this});
        }
    }

    public void release(Connection connection) {
    }

    public void close(Connection connection) {
    }

    public void abort(Throwable cause) {
        for (HttpExchange exchange : new ArrayList<HttpExchange>(this.exchanges)) {
            exchange.getRequest().abort(cause);
        }
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject((Appendable)out, (Object)this.toString());
    }

    public String asString() {
        return this.origin.asString();
    }

    public String toString() {
        return String.format("%s[%s]@%x%s,queue=%d", HttpDestination.class.getSimpleName(), this.asString(), this.hashCode(), this.proxy == null ? "" : "(via " + this.proxy + ")", this.exchanges.size());
    }
}

