/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.providers;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.providers.ScanningAppProvider;
import org.eclipse.jetty.ee.Deployable;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Environment;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Provider for start-up deployment of webapps based on presence in directory")
public class ContextProvider
extends ScanningAppProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ContextProvider.class);
    private final Map<String, String> _properties = new HashMap<String, String>();

    public ContextProvider() {
        this.setFilenameFilter(new Filter());
        this.setScanInterval(0);
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }

    @ManagedAttribute(value="extract war files")
    public boolean isExtractWars() {
        return Boolean.parseBoolean(this._properties.get("jetty.deploy.extractWars"));
    }

    public void setExtractWars(boolean extractWars) {
        this._properties.put("jetty.deploy.extractWars", Boolean.toString(extractWars));
    }

    @ManagedAttribute(value="parent classloader has priority")
    public boolean isParentLoaderPriority() {
        return Boolean.parseBoolean(this._properties.get("jetty.deploy.parentLoaderPriority"));
    }

    public void setParentLoaderPriority(boolean parentLoaderPriority) {
        this._properties.put("jetty.deploy.parentLoaderPriority", Boolean.toString(parentLoaderPriority));
    }

    @ManagedAttribute(value="default descriptor for webapps")
    public String getDefaultsDescriptor() {
        return this._properties.get("jetty.deploy.defaultsDescriptor");
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._properties.put("jetty.deploy.defaultsDescriptor", defaultsDescriptor);
    }

    public void setConfigurationClasses(String configurations) {
        this.setConfigurationClasses(StringUtil.isBlank((String)configurations) ? null : configurations.split(","));
    }

    public void setConfigurationClasses(String[] configurations) {
        this._properties.put("jetty.deploy.configurationClasses", configurations == null ? null : String.join((CharSequence)",", configurations));
    }

    @ManagedAttribute(value="configuration classes for webapps to be processed through")
    public String[] getConfigurationClasses() {
        String cc = this._properties.get("jetty.deploy.configurationClasses");
        return cc == null ? new String[]{} : cc.split(",");
    }

    public void setTempDir(String directory) {
        this._properties.put("jetty.deploy.tempDir", directory);
    }

    public void setTempDir(File directory) {
        this._properties.put("jetty.deploy.tempDir", directory.getAbsolutePath());
    }

    @ManagedAttribute(value="temp directory for use, null if no user set temp directory")
    public File getTempDir() {
        String tmpDir = this._properties.get("jetty.deploy.tempDir");
        return tmpDir == null ? null : new File(tmpDir);
    }

    protected ContextHandler initializeContextHandler(Object context, Path path, Map<String, String> properties) {
        ContextHandler contextHandler;
        if (LOG.isDebugEnabled()) {
            LOG.debug("initializeContextHandler {}", context);
        }
        if (context instanceof ContextHandler) {
            ContextHandler handler = (ContextHandler)context;
            contextHandler = handler;
        } else if (Supplier.class.isAssignableFrom(context.getClass())) {
            Supplier supplier = (Supplier)context;
            contextHandler = (ContextHandler)supplier.get();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not a context {}", context);
            }
            return null;
        }
        assert (contextHandler != null);
        this.initializeContextPath(contextHandler, path);
        if (Files.isDirectory(path, new LinkOption[0])) {
            contextHandler.setBaseResource(ResourceFactory.of((Container)this).newResource(path));
        }
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("jetty.deploy.attribute.")) continue;
            contextHandler.setAttribute(key.substring("jetty.deploy.attribute.".length()), (Object)value);
        }
        String contextPath = properties.get("jetty.deploy.contextPath");
        if (StringUtil.isNotBlank((String)contextPath)) {
            contextHandler.setContextPath(contextPath);
        }
        if (context instanceof Deployable) {
            Deployable deployable = (Deployable)context;
            deployable.initializeDefaults(properties);
        }
        return contextHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContextHandler createContextHandler(App app) throws Exception {
        Environment environment = Environment.get((String)app.getEnvironmentName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("createContextHandler {} in {}", (Object)app, (Object)environment);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(environment.getClassLoader());
            final Path path = app.getPath().toRealPath(new LinkOption[0]).toAbsolutePath().toFile().getCanonicalFile().toPath();
            if (!Files.exists(path, new LinkOption[0])) {
                throw new IllegalStateException("App resource does not exist " + path);
            }
            final HashMap<String, String> properties = new HashMap<String, String>();
            properties.putAll(this.getProperties());
            properties.putAll(app.getProperties());
            if (FileID.isXml((Path)path)) {
                Supplier supplier;
                Object nestedContext;
                ClassLoader coreContextClassLoader;
                XmlConfiguration xmlc = new XmlConfiguration(ResourceFactory.of((Container)this).newResource(path), null, properties){

                    public void initializeDefaults(Object context) {
                        super.initializeDefaults(context);
                        ContextProvider.this.initializeContextHandler(context, path, properties);
                    }
                };
                xmlc.getIdMap().put("Environment", environment);
                xmlc.setJettyStandardIdsAndProperties((Object)this.getDeploymentManager().getServer(), path);
                ClassLoader classLoader = coreContextClassLoader = Environment.CORE.equals(environment) ? this.findCoreContextClassLoader(path) : null;
                if (coreContextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(coreContextClassLoader);
                }
                Object context = xmlc.configure();
                ContextHandler contextHandler = null;
                if (context instanceof ContextHandler) {
                    ContextHandler c;
                    contextHandler = c = (ContextHandler)context;
                } else if (context instanceof Supplier && (nestedContext = (supplier = (Supplier)context).get()) instanceof ContextHandler) {
                    ContextHandler c;
                    contextHandler = c = (ContextHandler)nestedContext;
                }
                if (contextHandler == null) {
                    throw new IllegalStateException("Unknown context type of " + context);
                }
                if (coreContextClassLoader != null) {
                    contextHandler.setClassLoader(coreContextClassLoader);
                }
                ContextHandler contextHandler2 = contextHandler;
                return contextHandler2;
            }
            if (!Files.isDirectory(path, new LinkOption[0]) && !FileID.isWebArchive((Path)path)) {
                throw new IllegalStateException("unable to create ContextHandler for " + app);
            }
            String contextHandlerClassName = (String)environment.getAttribute("contextHandlerClass");
            if (StringUtil.isBlank((String)contextHandlerClassName)) {
                throw new IllegalStateException("No ContextHandler classname for " + app);
            }
            Class contextHandlerClass = Loader.loadClass((String)contextHandlerClassName);
            if (contextHandlerClass == null) {
                throw new IllegalStateException("Unknown ContextHandler class " + contextHandlerClassName + " for " + app);
            }
            Object context = contextHandlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            properties.put("jetty.deploy.war", path.toString());
            ContextHandler contextHandler = this.initializeContextHandler(context, path, properties);
            return contextHandler;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    protected ClassLoader findCoreContextClassLoader(Path path) throws IOException {
        Path classesDir;
        Path libDir;
        Path webapps = path.getParent();
        String basename = FileID.getBasename((Path)path);
        ArrayList<URL> urls = new ArrayList<URL>();
        Path contextJar = webapps.resolve(basename + ".jar");
        if (!Files.exists(contextJar, new LinkOption[0])) {
            contextJar = webapps.resolve(basename + ".JAR");
        }
        if (Files.exists(contextJar, new LinkOption[0])) {
            urls.add(contextJar.toUri().toURL());
        }
        if (Files.exists(libDir = webapps.resolve(basename + ".d" + path.getFileSystem().getSeparator() + "lib"), new LinkOption[0]) && Files.isDirectory(libDir, new LinkOption[0])) {
            try (Stream<Path> paths = Files.list(libDir);){
                paths.filter(FileID::isJavaArchive).map(Path::toUri).forEach(uri -> {
                    try {
                        urls.add(uri.toURL());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        if (Files.exists(classesDir = webapps.resolve(basename + ".d" + path.getFileSystem().getSeparator() + "classes"), new LinkOption[0]) && Files.isDirectory(libDir, new LinkOption[0])) {
            urls.add(classesDir.toUri().toURL());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Core classloader for {}", urls);
        }
        if (urls.isEmpty()) {
            return null;
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Environment.CORE.getClassLoader());
    }

    protected void initializeContextPath(ContextHandler context, Path path) {
        String basename = FileID.getBasename((Path)path);
        Object contextPath = basename;
        if (((String)contextPath).equalsIgnoreCase("root")) {
            contextPath = "/";
        } else if (StringUtil.startsWithIgnoreCase((String)contextPath, (String)"root-")) {
            int dash = ((String)contextPath).indexOf(45);
            String virtual = ((String)contextPath).substring(dash + 1);
            context.setVirtualHosts(Arrays.asList(virtual.split(",")));
            contextPath = "/";
        }
        if (((String)contextPath).charAt(0) != '/') {
            contextPath = "/" + (String)contextPath;
        }
        context.setDisplayName(basename);
        context.setContextPath((String)contextPath);
    }

    protected boolean isDeployable(Path path) {
        String basename = FileID.getBasename((Path)path);
        if (Files.isDirectory(path, new LinkOption[0])) {
            return !Files.exists(path.getParent().resolve(basename + ".xml"), new LinkOption[0]) && !Files.exists(path.getParent().resolve(basename + ".XML"), new LinkOption[0]) && !Files.exists(path.getParent().resolve(basename + ".war"), new LinkOption[0]) && !Files.exists(path.getParent().resolve(basename + ".WAR"), new LinkOption[0]);
        }
        if (FileID.isWebArchive((Path)path)) {
            return !Files.exists(path.getParent().resolve(basename + ".xml"), new LinkOption[0]) && !Files.exists(path.getParent().resolve(basename + ".XML"), new LinkOption[0]);
        }
        return FileID.isXml((Path)path);
    }

    @Override
    protected void pathChanged(Path path) throws Exception {
        if (Files.exists(path, new LinkOption[0]) && this.isDeployable(path)) {
            super.pathChanged(path);
        }
    }

    @Override
    protected void pathAdded(Path path) throws Exception {
        if (Files.exists(path, new LinkOption[0]) && this.isDeployable(path)) {
            super.pathAdded(path);
        }
    }

    @Override
    protected void pathRemoved(Path path) throws Exception {
        if (this.isDeployable(path)) {
            super.pathRemoved(path);
        }
    }

    public class Filter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            if (dir == null || !dir.canRead()) {
                return false;
            }
            if (FileID.isXml((String)name) || FileID.isWebArchive((String)name)) {
                return true;
            }
            Path path = dir.toPath().resolve(name);
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return false;
            }
            if (ContextProvider.this.getMonitoredResources().stream().map(Resource::getPath).anyMatch(path::equals)) {
                return false;
            }
            if (name.startsWith(".")) {
                return false;
            }
            String lowerName = name.toLowerCase(Locale.ENGLISH);
            if (lowerName.endsWith(".d")) {
                return false;
            }
            if ("cvs".equals(lowerName) || "cvsroot".equals(lowerName)) {
                return false;
            }
            return !Files.exists(dir.toPath().resolve(name + ".war"), new LinkOption[0]) && !Files.exists(dir.toPath().resolve(name + ".WAR"), new LinkOption[0]) && !Files.exists(dir.toPath().resolve(name + ".xml"), new LinkOption[0]) && !Files.exists(dir.toPath().resolve(name + ".XML"), new LinkOption[0]);
        }
    }
}

