/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.providers;

import java.io.FilenameFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Environment;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Abstract Provider for loading webapps")
public abstract class ScanningAppProvider
extends ContainerLifeCycle
implements AppProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ScanningAppProvider.class);
    private final Map<Path, App> _appMap = new HashMap<Path, App>();
    private DeploymentManager _deploymentManager;
    private FilenameFilter _filenameFilter;
    private final List<Resource> _monitored = new CopyOnWriteArrayList<Resource>();
    private int _scanInterval = 10;
    private Scanner _scanner;
    private boolean _useRealPaths;
    private String _environmentName;
    private final Scanner.DiscreteListener _scannerListener = new Scanner.DiscreteListener(){

        public void pathAdded(Path path) throws Exception {
            ScanningAppProvider.this.pathAdded(path);
        }

        public void pathChanged(Path path) throws Exception {
            ScanningAppProvider.this.pathChanged(path);
        }

        public void pathRemoved(Path path) throws Exception {
            ScanningAppProvider.this.pathChanged(path);
        }
    };

    protected ScanningAppProvider() {
        this(null);
    }

    protected ScanningAppProvider(FilenameFilter filter) {
        this._filenameFilter = filter;
        this.addBean(this._appMap);
    }

    @Override
    public String getEnvironmentName() {
        return this._environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this._environmentName = environmentName;
    }

    public boolean isUseRealPaths() {
        return this._useRealPaths;
    }

    public void setUseRealPaths(boolean useRealPaths) {
        this._useRealPaths = useRealPaths;
    }

    protected void setFilenameFilter(FilenameFilter filter) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._filenameFilter = filter;
    }

    protected Map<Path, App> getDeployedApps() {
        return this._appMap;
    }

    protected App createApp(Path path) {
        String environmentName;
        App app = new App(this._deploymentManager, this, path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} creating {}", (Object)this, (Object)app);
        }
        if (StringUtil.isBlank((String)(environmentName = app.getEnvironmentName()))) {
            String basename = FileID.getBasename((Path)path);
            boolean isWebapp = FileID.isWebArchive((Path)path) || Files.isDirectory(path, new LinkOption[0]) && Files.exists(path.resolve("WEB-INF"), new LinkOption[0]) || FileID.isXml((Path)path) && (Files.exists(path.getParent().resolve(basename + ".war"), new LinkOption[0]) || Files.exists(path.getParent().resolve(basename + ".WAR"), new LinkOption[0]) || Files.exists(path.getParent().resolve(basename + "/WEB-INF"), new LinkOption[0]));
            boolean coreProvider = this._deploymentManager.getAppProviders().stream().map(AppProvider::getEnvironmentName).anyMatch(Environment.CORE.getName()::equals);
            if (isWebapp || Files.isDirectory(path, new LinkOption[0]) && this._deploymentManager.getDefaultEnvironmentName() != null) {
                environmentName = this._deploymentManager.getDefaultEnvironmentName();
            } else if (coreProvider) {
                environmentName = Environment.CORE.getName();
            }
            if (StringUtil.isNotBlank((String)environmentName)) {
                app.getProperties().put("environment", environmentName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} default environment for {}", (Object)this, (Object)app);
                }
            }
        }
        if (StringUtil.isNotBlank((String)environmentName)) {
            if (Objects.equals(environmentName, this.getEnvironmentName())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} created {}", (Object)this, (Object)app);
                }
                return app;
            }
            if (Objects.equals(this.getEnvironmentName(), this._deploymentManager.getDefaultEnvironmentName())) {
                boolean appProvider4env = this._deploymentManager.getAppProviders().stream().map(AppProvider::getEnvironmentName).anyMatch(environmentName::equals);
                if (!appProvider4env) {
                    LOG.warn("No AppProvider with environment {} for {}", (Object)environmentName, (Object)app);
                }
                return null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} ignored {}", (Object)this, (Object)app);
        }
        return null;
    }

    protected void doStart() throws Exception {
        Environment environment2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}.doStart()", (Object)this.getClass().getSimpleName());
        }
        if (this._monitored.size() == 0) {
            throw new IllegalStateException("No configuration dir specified");
        }
        if (this._environmentName == null) {
            List<Environment> nonCore = Environment.getAll().stream().filter(environment -> !environment.equals(Environment.CORE)).toList();
            if (nonCore.size() != 1) {
                throw new IllegalStateException("No environment configured");
            }
            this._environmentName = nonCore.get(0).getName();
        }
        if ((environment2 = Environment.get((String)this._environmentName)) == null) {
            throw new IllegalStateException("Unknown environment " + this._environmentName);
        }
        LOG.info("Deployment monitor {} in {} at intervals {}s", new Object[]{this.getEnvironmentName(), this._monitored, this.getScanInterval()});
        ArrayList<Path> files = new ArrayList<Path>();
        for (Resource resource : this._monitored) {
            if (resource.exists() && Files.isReadable(resource.getPath())) {
                files.add(resource.getPath());
                continue;
            }
            LOG.warn("Does not exist: {}", (Object)resource);
        }
        this._scanner = new Scanner(null, this._useRealPaths);
        this._scanner.setScanDirs(files);
        this._scanner.setScanInterval(this._scanInterval);
        this._scanner.setFilenameFilter(this._filenameFilter);
        this._scanner.setReportDirs(true);
        this._scanner.setScanDepth(1);
        this._scanner.addListener((Scanner.Listener)this._scannerListener);
        this.addBean(this._scanner);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._scanner != null) {
            this.removeBean(this._scanner);
            this._scanner.removeListener((Scanner.Listener)this._scannerListener);
            this._scanner = null;
        }
    }

    protected boolean exists(String path) {
        return this._scanner.exists(path);
    }

    protected void pathAdded(Path path) throws Exception {
        App app = this.createApp(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("fileAdded {}: {}", (Object)path, (Object)app);
        }
        if (app != null) {
            this._appMap.put(path, app);
            this._deploymentManager.addApp(app);
        }
    }

    protected void pathChanged(Path path) throws Exception {
        App oldApp = this._appMap.remove(path);
        if (oldApp != null) {
            this._deploymentManager.removeApp(oldApp);
        }
        App app = this.createApp(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("fileChanged {}: {}", (Object)path, (Object)app);
        }
        if (app != null) {
            this._appMap.put(path, app);
            this._deploymentManager.addApp(app);
        }
    }

    protected void pathRemoved(Path path) throws Exception {
        App app = this._appMap.remove(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("fileRemoved {}: {}", (Object)path, (Object)app);
        }
        if (app != null) {
            this._deploymentManager.removeApp(app);
        }
    }

    public DeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public Resource getMonitoredDirResource() {
        if (this._monitored.size() == 0) {
            return null;
        }
        if (this._monitored.size() > 1) {
            throw new IllegalStateException();
        }
        return this._monitored.get(0);
    }

    public String getMonitoredDirName() {
        Resource resource = this.getMonitoredDirResource();
        return resource == null ? null : resource.toString();
    }

    @ManagedAttribute(value="scanning interval to detect changes which need reloaded")
    public int getScanInterval() {
        return this._scanInterval;
    }

    @Override
    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this._deploymentManager = deploymentManager;
    }

    public void setMonitoredResources(List<Resource> resources) {
        this._monitored.clear();
        if (resources == null) {
            return;
        }
        resources.stream().filter(Objects::nonNull).forEach(this._monitored::add);
    }

    public List<Resource> getMonitoredResources() {
        return Collections.unmodifiableList(this._monitored);
    }

    public void setMonitoredDirResource(Resource resource) {
        this.setMonitoredResources(Collections.singletonList(resource));
    }

    public void addScannerListener(Scanner.Listener listener) {
        this._scanner.addListener(listener);
    }

    public void setMonitoredDirName(String dir) {
        this.setMonitoredDirectories(Collections.singletonList(dir));
    }

    public void setMonitoredDirectories(Collection<String> directories) {
        try {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (String dir : directories) {
                resources.add(ResourceFactory.of((Container)this).newResource(dir));
            }
            this.setMonitoredResources(resources);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setScanInterval(int scanInterval) {
        this._scanInterval = scanInterval;
    }

    @ManagedOperation(value="Scan the monitored directories", impact="ACTION")
    public void scan() {
        LOG.info("Performing scan of monitored directories: {}", (Object)this.getMonitoredResources().stream().map(r -> r.getURI().toASCIIString()).collect(Collectors.joining(", ", "[", "]")));
        this._scanner.nudge();
    }

    public String toString() {
        return String.format("%s@%x%s", this.getClass(), this.hashCode(), this._monitored);
    }
}

