/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy;

import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import org.eclipse.jetty.deploy.Deployer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardDeployer
extends ContainerLifeCycle
implements Deployer {
    private static final Logger LOG = LoggerFactory.getLogger(StandardDeployer.class);
    private final ContextHandlerCollection _contexts;
    private final boolean _atomicRedeploy;
    private final ListenerAdaptor _listenerAdaptor;

    public StandardDeployer(@Name(value="contexts") ContextHandlerCollection contexts) {
        this(contexts, true);
    }

    public StandardDeployer(@Name(value="contexts") ContextHandlerCollection contexts, @Name(value="atomicRedeploy") boolean atomicRedeploy) {
        this._contexts = Objects.requireNonNull(contexts);
        this._atomicRedeploy = atomicRedeploy;
        this.installBean(this._contexts, false);
        this._listenerAdaptor = new ListenerAdaptor(this._contexts);
        this._contexts.addEventListener((EventListener)((Object)this._listenerAdaptor));
    }

    public ContextHandlerCollection getContexts() {
        return this._contexts;
    }

    public boolean addEventListener(EventListener listener) {
        if (super.addEventListener(listener)) {
            if (listener instanceof Deployer.Listener) {
                Deployer.Listener deployerListener = (Deployer.Listener)listener;
                this._listenerAdaptor._listeners.add(deployerListener);
            }
            return true;
        }
        return false;
    }

    public boolean removeEventListener(EventListener listener) {
        if (super.removeEventListener(listener)) {
            if (listener instanceof Deployer.Listener) {
                Deployer.Listener deployerListener = (Deployer.Listener)listener;
                this._listenerAdaptor._listeners.remove(deployerListener);
            }
            return true;
        }
        return false;
    }

    @Override
    public void deploy(ContextHandler contextHandler) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("deploy: {} {}", (Object)this, (Object)contextHandler);
        }
        Objects.requireNonNull(contextHandler);
        contextHandler.addEventListener((EventListener)((Object)this._listenerAdaptor));
        this._listenerAdaptor.notify(contextHandler, Deployer.Listener::onCreated);
        try {
            Callback.Completable blocker = new Callback.Completable();
            this._contexts.deployHandler((Handler)contextHandler, (Callback)blocker);
            blocker.get();
            if (this._contexts.isRunning()) {
                contextHandler.start();
            }
            this._contexts.manage((Object)contextHandler);
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Deploy failed {}", new Object[]{this, contextHandler, t});
            }
            ExceptionUtil.ifExceptionThrowUnchecked((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redeploy(ContextHandler oldHandler, ContextHandler newContextHandler) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("redeploy: {} {}", (Object)this, (Object)newContextHandler);
            }
            Objects.requireNonNull(newContextHandler).setServer(Objects.requireNonNull(oldHandler.getServer()));
            newContextHandler.addEventListener((EventListener)((Object)this._listenerAdaptor));
            this._listenerAdaptor.notify(newContextHandler, Deployer.Listener::onCreated);
            if (this._atomicRedeploy && this._contexts.isRunning()) {
                newContextHandler.start();
            }
            Callback.Completable blocker = new Callback.Completable();
            this._contexts.redeployHandler((Handler)oldHandler, (Handler)newContextHandler, (Callback)blocker);
            blocker.get();
            if (!this._atomicRedeploy && this._contexts.isRunning()) {
                newContextHandler.start();
            }
            this._contexts.manage((Object)newContextHandler);
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Redeploy failed {}", new Object[]{this, newContextHandler, t});
            }
            ExceptionUtil.ifExceptionThrowUnchecked((Throwable)t);
        }
        finally {
            this._listenerAdaptor.notify(oldHandler, Deployer.Listener::onRemoved);
            oldHandler.removeEventListener((EventListener)((Object)this._listenerAdaptor));
        }
    }

    @Override
    public void undeploy(ContextHandler contextHandler) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("undeploy: {} {}", (Object)this, (Object)contextHandler);
        }
        if (this._contexts.getHandlers().contains(contextHandler)) {
            try {
                contextHandler.stop();
                this._contexts.removeHandler((Handler)contextHandler);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                this._listenerAdaptor.notify(contextHandler, Deployer.Listener::onRemoved);
                contextHandler.removeEventListener((EventListener)((Object)this._listenerAdaptor));
            }
        }
    }

    public String toString() {
        return "%s@%x{contexts=%s,sbrd=%b}".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this._contexts, this._atomicRedeploy);
    }

    private static class ListenerAdaptor
    implements LifeCycle.Listener,
    Container.Listener {
        private final ContextHandlerCollection _contexts;
        private final List<Deployer.Listener> _listeners = new CopyOnWriteArrayList<Deployer.Listener>();

        private ListenerAdaptor(ContextHandlerCollection contexts) {
            this._contexts = contexts;
        }

        private void notify(ContextHandler contextHandler, BiConsumer<Deployer.Listener, ContextHandler> method) {
            for (Deployer.Listener listener : this._listeners) {
                try {
                    method.accept(listener, contextHandler);
                }
                catch (Throwable t) {
                    LOG.warn("listener failure {}", (Object)listener, (Object)t);
                }
            }
        }

        public void beanAdded(Container parent, Object child) {
            if (child instanceof ContextHandler) {
                ContextHandler contextHandler;
                this.notify(contextHandler, (contextHandler = (ContextHandler)child).isStarted() ? Deployer.Listener::onDeployed : Deployer.Listener::onDeploying);
            }
        }

        public void beanRemoved(Container parent, Object child) {
            if (child instanceof ContextHandler) {
                ContextHandler contextHandler;
                this.notify(contextHandler, (contextHandler = (ContextHandler)child).isStarted() ? Deployer.Listener::onUndeploying : Deployer.Listener::onUndeployed);
            }
        }

        public void lifeCycleFailure(LifeCycle bean, Throwable cause) {
            if (bean instanceof ContextHandler) {
                ContextHandler contextHandler = (ContextHandler)bean;
                this.notify(contextHandler, (dl, ch) -> dl.onFailure((ContextHandler)ch, cause));
            }
        }

        public void lifeCycleStarted(LifeCycle bean) {
            if (bean instanceof ContextHandler) {
                ContextHandler contextHandler = (ContextHandler)bean;
                this.notify(contextHandler, Deployer.Listener::onStarted);
                if (this._contexts.contains((Object)contextHandler)) {
                    this.notify(contextHandler, Deployer.Listener::onDeployed);
                }
            }
        }

        public void lifeCycleStarting(LifeCycle event) {
            if (event instanceof ContextHandler) {
                ContextHandler contextHandler = (ContextHandler)event;
                if (!this._contexts.contains((Object)contextHandler)) {
                    this.notify(contextHandler, Deployer.Listener::onDeploying);
                }
                this.notify(contextHandler, Deployer.Listener::onStarting);
            }
        }

        public void lifeCycleStopped(LifeCycle event) {
            if (event instanceof ContextHandler) {
                ContextHandler contextHandler = (ContextHandler)event;
                this.notify(contextHandler, Deployer.Listener::onStopped);
                if (!this._contexts.contains((Object)contextHandler)) {
                    this.notify(contextHandler, Deployer.Listener::onUndeployed);
                }
            }
        }

        public void lifeCycleStopping(LifeCycle event) {
            if (event instanceof ContextHandler) {
                ContextHandler contextHandler = (ContextHandler)event;
                if (this._contexts.contains((Object)contextHandler)) {
                    this.notify(contextHandler, Deployer.Listener::onUndeploying);
                }
                this.notify(contextHandler, Deployer.Listener::onStopping);
            }
        }
    }
}

