/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy;

import java.util.EventListener;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;

@ManagedObject(value="Deployer")
public interface Deployer {
    @ManagedOperation(value="Deploy the ContextHandler", impact="ACTION")
    public void deploy(ContextHandler var1);

    @ManagedOperation(value="Redeploy the ContextHandler", impact="ACTION")
    default public void redeploy(ContextHandler oldContextHandler, ContextHandler newContextHandler) {
        this.undeploy(oldContextHandler);
        this.deploy(newContextHandler);
    }

    @ManagedOperation(value="Undeploy the ContextHandler", impact="ACTION")
    public void undeploy(ContextHandler var1);

    public static interface Listener
    extends EventListener {
        default public void onCreated(ContextHandler contextHandler) {
        }

        default public void onDeploying(ContextHandler contextHandler) {
        }

        default public void onStarting(ContextHandler contextHandler) {
        }

        default public void onStarted(ContextHandler contextHandler) {
        }

        default public void onDeployed(ContextHandler contextHandler) {
        }

        default public void onUndeploying(ContextHandler contextHandler) {
        }

        default public void onStopping(ContextHandler contextHandler) {
        }

        default public void onStopped(ContextHandler contextHandler) {
        }

        default public void onUndeployed(ContextHandler contextHandler) {
        }

        default public void onFailure(ContextHandler contextHandler, Throwable cause) {
        }

        default public void onRemoved(ContextHandler contextHandler) {
        }
    }
}

