/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy;

import java.util.ArrayList;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebAppDeployer
extends AbstractLifeCycle {
    private HandlerCollection _contexts;
    private String _webAppDir;
    private String _defaultsDescriptor;
    private String[] _configurationClasses;
    private boolean _extract;
    private boolean _parentLoaderPriority;
    private boolean _allowDuplicates;
    private ArrayList _deployed;

    public String[] getConfigurationClasses() {
        return this._configurationClasses;
    }

    public void setConfigurationClasses(String[] configurationClasses) {
        this._configurationClasses = configurationClasses;
    }

    public HandlerCollection getContexts() {
        return this._contexts;
    }

    public void setContexts(HandlerCollection contexts) {
        this._contexts = contexts;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public boolean isExtract() {
        return this._extract;
    }

    public void setExtract(boolean extract) {
        this._extract = extract;
    }

    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public void setParentLoaderPriority(boolean parentPriorityClassLoading) {
        this._parentLoaderPriority = parentPriorityClassLoading;
    }

    public String getWebAppDir() {
        return this._webAppDir;
    }

    public void setWebAppDir(String dir) {
        this._webAppDir = dir;
    }

    public boolean getAllowDuplicates() {
        return this._allowDuplicates;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this._allowDuplicates = allowDuplicates;
    }

    public void doStart() throws Exception {
        this._deployed = new ArrayList();
        this.scan();
    }

    public void scan() throws Exception {
        if (this._contexts == null) {
            throw new IllegalArgumentException("No HandlerContainer");
        }
        Resource r = Resource.newResource((String)this._webAppDir);
        if (!r.exists()) {
            throw new IllegalArgumentException("No such webapps resource " + r);
        }
        if (!r.isDirectory()) {
            throw new IllegalArgumentException("Not directory webapps resource " + r);
        }
        String[] files = r.list();
        block2: for (int f = 0; files != null && f < files.length; ++f) {
            Resource unpacked;
            String context = files[f];
            if (context.equalsIgnoreCase("CVS/") || context.equalsIgnoreCase("CVS") || context.startsWith(".")) continue;
            Resource app = r.addPath(r.encode(context));
            if (!context.toLowerCase().endsWith(".war") && !context.toLowerCase().endsWith(".jar") ? !app.isDirectory() : (unpacked = r.addPath(context = context.substring(0, context.length() - 4))) != null && unpacked.exists() && unpacked.isDirectory()) continue;
            context = context.equalsIgnoreCase("root") || context.equalsIgnoreCase("root/") ? "/" : "/" + context;
            if (context.endsWith("/") && context.length() > 0) {
                context = context.substring(0, context.length() - 1);
            }
            if (!this._allowDuplicates) {
                Handler[] installed = this._contexts.getChildHandlersByClass(ContextHandler.class);
                for (int i = 0; i < installed.length; ++i) {
                    String path;
                    ContextHandler c = (ContextHandler)installed[i];
                    if (context.equals(c.getContextPath())) continue block2;
                    if (c instanceof WebAppContext) {
                        path = ((WebAppContext)c).getWar();
                    } else {
                        String string = path = c.getBaseResource() == null ? "" : c.getBaseResource().getFile().getAbsolutePath();
                    }
                    if (path.equals(app.getFile().getAbsolutePath())) continue block2;
                }
            }
            WebAppContext wah = null;
            if (this._contexts instanceof ContextHandlerCollection && WebAppContext.class.isAssignableFrom(((ContextHandlerCollection)this._contexts).getContextClass())) {
                try {
                    wah = (WebAppContext)((ContextHandlerCollection)this._contexts).getContextClass().newInstance();
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            } else {
                wah = new WebAppContext();
            }
            wah.setContextPath(context);
            if (this._configurationClasses != null) {
                wah.setConfigurationClasses(this._configurationClasses);
            }
            if (this._defaultsDescriptor != null) {
                wah.setDefaultsDescriptor(this._defaultsDescriptor);
            }
            wah.setExtractWAR(this._extract);
            wah.setWar(app.toString());
            wah.setParentLoaderPriority(this._parentLoaderPriority);
            this._contexts.addHandler((Handler)wah);
            this._deployed.add(wah);
            if (!this._contexts.isStarted()) continue;
            this._contexts.start();
        }
    }

    public void doStop() throws Exception {
        int i = this._deployed.size();
        while (i-- > 0) {
            ContextHandler wac = (ContextHandler)this._deployed.get(i);
            wac.stop();
        }
    }
}

