/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppLifeCycle;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.bindings.StandardDeployer;
import org.eclipse.jetty.deploy.bindings.StandardStarter;
import org.eclipse.jetty.deploy.bindings.StandardStopper;
import org.eclipse.jetty.deploy.bindings.StandardUndeployer;
import org.eclipse.jetty.deploy.graph.Edge;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.deploy.graph.Path;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentManager
extends AbstractLifeCycle {
    private final List<AppProvider> _providers = new ArrayList<AppProvider>();
    private final AppLifeCycle _lifecycle = new AppLifeCycle();
    private final List<AppEntry> _apps = new LinkedList<AppEntry>();
    private AttributesMap _contextAttributes = new AttributesMap();
    private ContextHandlerCollection _contexts;
    private boolean _useStandardBindings = true;
    private String _defaultLifeCycleGoal = "started";

    public void addApp(App app) {
        Log.info((String)("Deployable added: " + app.getOriginId()));
        AppEntry entry = new AppEntry();
        entry.app = app;
        entry.setLifeCycleNode(this._lifecycle.getNodeByName("undeployed"));
        this._apps.add(entry);
        if (this.isRunning() && this._defaultLifeCycleGoal != null) {
            this.requestAppGoal(entry, this._defaultLifeCycleGoal);
        }
    }

    public void setAppProviders(Collection<AppProvider> providers) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._providers.clear();
        for (AppProvider provider : providers) {
            this._providers.add(provider);
        }
    }

    public Collection<AppProvider> getAppProviders() {
        return Collections.unmodifiableList(this._providers);
    }

    public void addAppProvider(AppProvider provider) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._providers.add(provider);
    }

    public void setLifeCycleBindings(Collection<AppLifeCycle.Binding> bindings) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        for (AppLifeCycle.Binding b : this._lifecycle.getBindings()) {
            this._lifecycle.removeBinding(b);
        }
        for (AppLifeCycle.Binding b : bindings) {
            this._lifecycle.addBinding(b);
        }
    }

    public Collection<AppLifeCycle.Binding> getLifeCycleBindings() {
        return Collections.unmodifiableSet(this._lifecycle.getBindings());
    }

    public void addLifeCycleBinding(AppLifeCycle.Binding binding) {
        this._lifecycle.addBinding(binding);
    }

    public void insertLifeCycleNode(String existingFromNodeName, String existingToNodeName, String insertedNodeName) {
        Node fromNode = this._lifecycle.getNodeByName(existingFromNodeName);
        Node toNode = this._lifecycle.getNodeByName(existingToNodeName);
        Edge edge = new Edge(fromNode, toNode);
        this._lifecycle.insertNode(edge, insertedNodeName);
    }

    protected void doStart() throws Exception {
        if (this._useStandardBindings) {
            Log.debug((String)"DeploymentManager using standard bindings");
            this.addLifeCycleBinding(new StandardDeployer());
            this.addLifeCycleBinding(new StandardStarter());
            this.addLifeCycleBinding(new StandardStopper());
            this.addLifeCycleBinding(new StandardUndeployer());
        }
        for (AppProvider provider : this._providers) {
            this.startAppProvider(provider);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        for (AppProvider provider : this._providers) {
            try {
                provider.stop();
            }
            catch (Exception e) {
                Log.warn((String)"Unable to start AppProvider", (Throwable)e);
            }
        }
        super.doStop();
    }

    private AppEntry findAppByContextId(String contextId) {
        if (contextId == null) {
            return null;
        }
        for (AppEntry entry : this._apps) {
            if (!contextId.equals(entry.app.getContextId())) continue;
            return entry;
        }
        return null;
    }

    private AppEntry findAppByOriginId(String originId) {
        if (originId == null) {
            return null;
        }
        for (AppEntry entry : this._apps) {
            if (!originId.equals(entry.app.getOriginId())) continue;
            return entry;
        }
        return null;
    }

    public App getAppByContextId(String contextId) {
        AppEntry entry = this.findAppByContextId(contextId);
        if (entry == null) {
            return null;
        }
        return entry.app;
    }

    public App getAppByOriginId(String originId) {
        AppEntry entry = this.findAppByOriginId(originId);
        if (entry == null) {
            return null;
        }
        return entry.app;
    }

    public Collection<AppEntry> getAppEntries() {
        return this._apps;
    }

    public Collection<App> getApps() {
        ArrayList<App> ret = new ArrayList<App>();
        for (AppEntry entry : this._apps) {
            ret.add(entry.app);
        }
        return ret;
    }

    public Collection<App> getApps(Node node) {
        ArrayList<App> ret = new ArrayList<App>();
        for (AppEntry entry : this._apps) {
            if (entry.lifecyleNode != node) continue;
            ret.add(entry.app);
        }
        return ret;
    }

    public List<App> getAppsWithSameContext(App app) {
        ArrayList<App> ret = new ArrayList<App>();
        if (app == null) {
            return ret;
        }
        String contextId = app.getContextId();
        if (contextId == null) {
            return ret;
        }
        for (AppEntry entry : this._apps) {
            if (entry.app.equals(app) || !contextId.equals(entry.app.getContextId())) continue;
            ret.add(entry.app);
        }
        return ret;
    }

    public Object getContextAttribute(String name) {
        return this._contextAttributes.getAttribute(name);
    }

    public AttributesMap getContextAttributes() {
        return this._contextAttributes;
    }

    public ContextHandlerCollection getContexts() {
        return this._contexts;
    }

    public String getDefaultLifeCycleGoal() {
        return this._defaultLifeCycleGoal;
    }

    public AppLifeCycle getLifeCycle() {
        return this._lifecycle;
    }

    public Server getServer() {
        if (this._contexts == null) {
            return null;
        }
        return this._contexts.getServer();
    }

    public void removeApp(App app) {
        ListIterator<AppEntry> it = this._apps.listIterator();
        while (it.hasNext()) {
            AppEntry entry = it.next();
            if (!entry.app.equals(app)) continue;
            if (!"undeployed".equals(entry.lifecyleNode.getName())) {
                this.requestAppGoal(entry.app, "undeployed");
            }
            it.remove();
            Log.info((String)("Deployable removed: " + entry.app));
        }
    }

    public void removeAppProvider(AppProvider provider) {
        this._providers.remove(provider);
        try {
            provider.stop();
        }
        catch (Exception e) {
            Log.warn((String)"Unable to stop Provider", (Throwable)e);
        }
    }

    public void removeContextAttribute(String name) {
        this._contextAttributes.removeAttribute(name);
    }

    public void requestAppGoal(App app, String nodeName) {
        AppEntry appentry = this.findAppByContextId(app.getContextId());
        if (appentry == null && (appentry = this.findAppByOriginId(app.getOriginId())) == null) {
            throw new IllegalStateException("App not being tracked by Deployment Manager: " + app);
        }
        this.requestAppGoal(appentry, nodeName);
    }

    private void requestAppGoal(AppEntry appentry, String nodeName) {
        Node destinationNode = this._lifecycle.getNodeByName(nodeName);
        Path path = this._lifecycle.getPath(appentry.lifecyleNode, destinationNode);
        if (path.isEmpty()) {
            return;
        }
        try {
            Iterator<Node> it = path.getNodes().iterator();
            if (it.hasNext()) {
                it.next();
                while (it.hasNext()) {
                    Node node = it.next();
                    Log.debug((String)("Executing Node: " + node));
                    this._lifecycle.runBindings(node, appentry.app, this);
                    appentry.setLifeCycleNode(node);
                }
            }
        }
        catch (Throwable t) {
            Log.warn((String)("Unable to reach node goal: " + nodeName), (Throwable)t);
        }
    }

    public void requestAppGoal(String appId, String nodeName) {
        AppEntry appentry = this.findAppByContextId(appId);
        if (appentry == null && (appentry = this.findAppByOriginId(appId)) == null) {
            throw new IllegalStateException("App not being tracked by Deployment Manager: " + appId);
        }
        this.requestAppGoal(appentry, nodeName);
    }

    public void setContextAttribute(String name, Object value) {
        this._contextAttributes.setAttribute(name, value);
    }

    public void setContextAttributes(AttributesMap contextAttributes) {
        this._contextAttributes = contextAttributes;
    }

    public void setContexts(ContextHandlerCollection contexts) {
        this._contexts = contexts;
    }

    public void setDefaultLifeCycleGoal(String defaultLifeCycleState) {
        this._defaultLifeCycleGoal = defaultLifeCycleState;
    }

    private void startAppProvider(AppProvider provider) {
        try {
            provider.setDeploymentManager(this);
            provider.start();
        }
        catch (Exception e) {
            Log.warn((String)"Unable to start AppProvider", (Throwable)e);
        }
    }

    public void undeployAll() {
        Log.info((String)"Undeploy All");
        for (AppEntry appentry : this._apps) {
            this.requestAppGoal(appentry, "undeployed");
        }
    }

    public boolean isUseStandardBindings() {
        return this._useStandardBindings;
    }

    public void setUseStandardBindings(boolean useStandardBindings) {
        this._useStandardBindings = useStandardBindings;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AppEntry {
        private int version;
        private App app;
        private Node lifecyleNode;
        private Map<Node, Long> stateTimestamps = new HashMap<Node, Long>();

        public App getApp() {
            return this.app;
        }

        public Node getLifecyleNode() {
            return this.lifecyleNode;
        }

        public Map<Node, Long> getStateTimestamps() {
            return this.stateTimestamps;
        }

        public int getVersion() {
            return this.version;
        }

        void setLifeCycleNode(Node node) {
            this.lifecyleNode = node;
            this.stateTimestamps.put(node, System.currentTimeMillis());
        }
    }
}

