/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.providers;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.deploy.providers.ScanningAppProvider;
import org.eclipse.jetty.deploy.util.FileID;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;

public class ContextProvider
extends ScanningAppProvider {
    private ConfigurationManager _configurationManager;

    public ContextProvider() {
        super(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (!dir.exists()) {
                    return false;
                }
                String lowername = name.toLowerCase();
                if (lowername.startsWith(".")) {
                    return false;
                }
                return lowername.endsWith(".xml") && !new File(dir, name).isDirectory();
            }
        });
    }

    public ConfigurationManager getConfigurationManager() {
        return this._configurationManager;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this._configurationManager = configurationManager;
    }

    public ContextHandler createContextHandler(App app) throws Exception {
        Resource resource = Resource.newResource((String)app.getOriginId());
        File file = resource.getFile();
        if (resource.exists() && FileID.isXmlFile(file)) {
            XmlConfiguration xmlc = new XmlConfiguration(resource.getURL());
            xmlc.getIdMap().put("Server", this.getDeploymentManager().getServer());
            if (this.getConfigurationManager() != null) {
                xmlc.getProperties().putAll(this.getConfigurationManager().getProperties());
            }
            return (ContextHandler)xmlc.configure();
        }
        throw new IllegalStateException("App resouce does not exist " + resource);
    }
}

