/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.bindings;

import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppLifeCycle;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class GlobalWebappConfigBinding
implements AppLifeCycle.Binding {
    private String _jettyXml;

    public String getJettyXml() {
        return this._jettyXml;
    }

    public void setJettyXml(String jettyXml) {
        this._jettyXml = jettyXml;
    }

    @Override
    public String[] getBindingTargets() {
        return new String[]{"deploying"};
    }

    @Override
    public void processBinding(Node node, App app) throws Exception {
        ContextHandler handler = app.getContextHandler();
        if (handler == null) {
            throw new NullPointerException("No Handler created for App: " + app);
        }
        if (handler instanceof WebAppContext) {
            Resource globalContextSettings;
            WebAppContext context = (WebAppContext)handler;
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Binding: Configuring webapp context with global settings from: " + this._jettyXml));
            }
            if (this._jettyXml == null) {
                Log.warn((String)"Binding: global context binding is enabled but no jetty-web.xml file has been registered");
            }
            if ((globalContextSettings = Resource.newResource((String)this._jettyXml)).exists()) {
                XmlConfiguration jettyXmlConfig = new XmlConfiguration(globalContextSettings.getInputStream());
                jettyXmlConfig.configure((Object)context);
            } else {
                Log.info((String)("Binding: Unable to locate global webapp context settings: " + this._jettyXml));
            }
        }
    }
}

