/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.providers;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.deploy.providers.ScanningAppProvider;
import org.eclipse.jetty.deploy.util.FileID;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

@ManagedObject(value="Provider for start-up deployement of webapps based on presence in directory")
public class WebAppProvider
extends ScanningAppProvider {
    private boolean _extractWars = false;
    private boolean _parentLoaderPriority = false;
    private ConfigurationManager _configurationManager;
    private String _defaultsDescriptor;
    private File _tempDirectory;
    private String[] _configurationClasses;

    public WebAppProvider() {
        this.setFilenameFilter(new Filter());
        this.setScanInterval(0);
    }

    @ManagedAttribute(value="extract war files")
    public boolean isExtractWars() {
        return this._extractWars;
    }

    public void setExtractWars(boolean extractWars) {
        this._extractWars = extractWars;
    }

    @ManagedAttribute(value="parent classloader has priority")
    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public void setParentLoaderPriority(boolean parentLoaderPriority) {
        this._parentLoaderPriority = parentLoaderPriority;
    }

    @ManagedAttribute(value="default descriptor for webapps")
    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public ConfigurationManager getConfigurationManager() {
        return this._configurationManager;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this._configurationManager = configurationManager;
    }

    public void setConfigurationClasses(String[] configurations) {
        this._configurationClasses = configurations == null ? null : (String[])configurations.clone();
    }

    @ManagedAttribute(value="configuration classes for webapps to be processed through")
    public String[] getConfigurationClasses() {
        return this._configurationClasses;
    }

    public void setTempDir(File directory) {
        this._tempDirectory = directory;
    }

    @ManagedAttribute(value="temp directory for use, null if no user set temp directory")
    public File getTempDir() {
        return this._tempDirectory;
    }

    @Override
    public ContextHandler createContextHandler(App app) throws Exception {
        Resource resource = Resource.newResource((String)app.getOriginId());
        File file = resource.getFile();
        if (!resource.exists()) {
            throw new IllegalStateException("App resouce does not exist " + resource);
        }
        String context = file.getName();
        if (resource.exists() && FileID.isXmlFile(file)) {
            XmlConfiguration xmlc = new XmlConfiguration(resource.getURL());
            xmlc.getIdMap().put("Server", this.getDeploymentManager().getServer());
            if (this.getConfigurationManager() != null) {
                xmlc.getProperties().putAll(this.getConfigurationManager().getProperties());
            }
            return (ContextHandler)xmlc.configure();
        }
        if (!file.isDirectory()) {
            if (FileID.isWebArchiveFile(file)) {
                context = context.substring(0, context.length() - 4);
            } else {
                throw new IllegalStateException("unable to create ContextHandler for " + app);
            }
        }
        if (context.endsWith("/") && context.length() > 0) {
            context = context.substring(0, context.length() - 1);
        }
        WebAppContext wah = new WebAppContext();
        wah.setDisplayName(context);
        if (context.equalsIgnoreCase("root")) {
            context = "/";
        } else if (context.toLowerCase().startsWith("root-")) {
            int dash = context.toLowerCase().indexOf(45);
            String virtual = context.substring(dash + 1);
            wah.setVirtualHosts(new String[]{virtual});
            context = "/";
        }
        if (context.charAt(0) != '/') {
            context = "/" + context;
        }
        wah.setContextPath(context);
        wah.setWar(file.getAbsolutePath());
        if (this._defaultsDescriptor != null) {
            wah.setDefaultsDescriptor(this._defaultsDescriptor);
        }
        wah.setExtractWAR(this._extractWars);
        wah.setParentLoaderPriority(this._parentLoaderPriority);
        if (this._configurationClasses != null) {
            wah.setConfigurationClasses(this._configurationClasses);
        }
        if (this._tempDirectory != null) {
            wah.setAttribute("org.eclipse.jetty.webapp.basetempdir", (Object)this._tempDirectory);
        }
        return wah;
    }

    public class Filter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            if (!dir.exists()) {
                return false;
            }
            String lowername = name.toLowerCase();
            File file = new File(dir, name);
            if (lowername.startsWith(".")) {
                return false;
            }
            if (file.isDirectory()) {
                if (lowername.endsWith(".d")) {
                    return false;
                }
                if (WebAppProvider.this.exists(name + ".war") || WebAppProvider.this.exists(name + ".WAR")) {
                    return false;
                }
                if (WebAppProvider.this.exists(name + ".xml") || WebAppProvider.this.exists(name + ".XML")) {
                    return false;
                }
                return !"cvs".equals(lowername) && !"cvsroot".equals(lowername);
            }
            if (lowername.endsWith(".war")) {
                String base = name.substring(0, name.length() - 4);
                return !WebAppProvider.this.exists(base + ".xml") && !WebAppProvider.this.exists(base + ".XML");
            }
            return lowername.endsWith(".xml");
        }
    }
}

