/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.hazelcast.session;

import com.hazelcast.core.IMap;
import com.hazelcast.query.EntryObject;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.PredicateBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.session.AbstractSessionDataStore;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.UnreadableSessionDataException;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public class HazelcastSessionDataStore
extends AbstractSessionDataStore
implements SessionDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastSessionDataStore.class);
    private IMap<String, SessionData> sessionDataMap;
    private boolean _scavengeZombies;

    public void setScavengeZombieSessions(boolean scavengeZombies) {
        this._scavengeZombies = scavengeZombies;
    }

    public boolean isScavengeZombies() {
        return this._scavengeZombies;
    }

    public SessionData doLoad(String id) throws Exception {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading session {} from hazelcast", (Object)id);
            }
            SessionData sd = (SessionData)this.sessionDataMap.get((Object)this.getCacheKey(id));
            return sd;
        }
        catch (Exception e) {
            throw new UnreadableSessionDataException(id, this._context, (Throwable)e);
        }
    }

    public boolean delete(String id) throws Exception {
        if (this.sessionDataMap == null) {
            return false;
        }
        this.sessionDataMap.delete((Object)this.getCacheKey(id));
        return true;
    }

    public IMap<String, SessionData> getSessionDataMap() {
        return this.sessionDataMap;
    }

    public void setSessionDataMap(IMap<String, SessionData> sessionDataMap) {
        this.sessionDataMap = sessionDataMap;
    }

    public void initialize(SessionContext context) throws Exception {
        super.initialize(context);
        if (this.isScavengeZombies()) {
            this.sessionDataMap.addIndex("expiry", true);
        }
    }

    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        this.sessionDataMap.set((Object)this.getCacheKey(id), (Object)data);
    }

    public boolean isPassivating() {
        return true;
    }

    public Set<String> doGetExpired(Set<String> candidates) {
        long now = System.currentTimeMillis();
        Set<String> expiredSessionIds = candidates.stream().filter(candidate -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking expiry for candidate {}", candidate);
            }
            try {
                SessionData sd = this.load((String)candidate);
                if (sd == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Session {} does not exist in Hazelcast", candidate);
                    }
                    return true;
                }
                if (this._context.getWorkerName().equals(sd.getLastNode())) {
                    if (sd.getExpiry() > 0L && sd.getExpiry() <= now) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Session {} managed by {} is expired", candidate, (Object)this._context.getWorkerName());
                        }
                        return true;
                    }
                } else if (this._lastExpiryCheckTime <= 0L ? sd.getExpiry() > 0L && sd.getExpiry() < now - 1000L * (long)(3 * this._gracePeriodSec) : sd.getExpiry() > 0L && sd.getExpiry() < now - 1000L * (long)this._gracePeriodSec) {
                    return true;
                }
            }
            catch (Exception e) {
                LOG.warn("Error checking if candidate {} is expired so expire it", candidate, (Object)e);
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        if (this.isScavengeZombies()) {
            AtomicReference reference = new AtomicReference();
            AtomicReference exception = new AtomicReference();
            this._context.run(() -> {
                try {
                    HashSet<String> ids = new HashSet<String>();
                    EntryObject eo = new PredicateBuilder().getEntryObject();
                    PredicateBuilder predicate = eo.get("expiry").greaterThan((Comparable)Integer.valueOf(0)).and((Predicate)eo.get("expiry").lessEqual((Comparable)Long.valueOf(now)));
                    Collection results = this.sessionDataMap.values((Predicate)predicate);
                    if (results != null) {
                        for (SessionData sd : results) {
                            ids.add(sd.getId());
                        }
                    }
                    reference.set(ids);
                }
                catch (Exception e) {
                    exception.set(e);
                }
            });
            if (exception.get() != null) {
                LOG.warn("Error querying for expired sessions {}", (Throwable)exception.get());
                return expiredSessionIds;
            }
            if (reference.get() != null) {
                expiredSessionIds.addAll((Collection)reference.get());
            }
        }
        return expiredSessionIds;
    }

    public boolean exists(String id) throws Exception {
        SessionData sd = this.load(id);
        if (sd == null) {
            return false;
        }
        if (sd.getExpiry() <= 0L) {
            return true;
        }
        return sd.getExpiry() > System.currentTimeMillis();
    }

    public String getCacheKey(String id) {
        return this._context.getCanonicalContextPath() + "_" + this._context.getVhost() + "_" + id;
    }
}

