/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.hazelcast.session;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.serialization.Serializer;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jetty.hazelcast.session.HazelcastSessionDataStore;
import org.eclipse.jetty.hazelcast.session.SessionDataSerializer;
import org.eclipse.jetty.session.AbstractSessionDataStoreFactory;
import org.eclipse.jetty.session.SessionData;
import org.eclipse.jetty.session.SessionDataStore;
import org.eclipse.jetty.session.SessionDataStoreFactory;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastSessionDataStoreFactory
extends AbstractSessionDataStoreFactory
implements SessionDataStoreFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastSessionDataStoreFactory.class);
    private String hazelcastInstanceName = "JETTY_DISTRIBUTED_SESSION_INSTANCE";
    private boolean onlyClient;
    private String configurationLocation;
    private String mapName = "jetty-distributed-session-map";
    private HazelcastInstance hazelcastInstance;
    private MapConfig mapConfig;
    private boolean useQueries = false;
    private String addresses;

    public boolean isUseQueries() {
        return this.useQueries;
    }

    public void setUseQueries(boolean useQueries) {
        this.useQueries = useQueries;
    }

    public SessionDataStore getSessionDataStore(SessionManager sessionManager) throws Exception {
        HazelcastSessionDataStore hazelcastSessionDataStore = new HazelcastSessionDataStore();
        if (this.hazelcastInstance == null) {
            try {
                if (this.onlyClient) {
                    ClientConfig config;
                    if (StringUtil.isEmpty((String)this.configurationLocation)) {
                        config = new ClientConfig();
                        if (this.addresses != null && !this.addresses.isEmpty()) {
                            config.getNetworkConfig().setAddresses(Arrays.asList(this.addresses.split(",")));
                        }
                        SerializerConfig sc = new SerializerConfig().setImplementation((Serializer)new SessionDataSerializer()).setTypeClass(SessionData.class);
                        config.getSerializationConfig().addSerializerConfig(sc);
                    } else {
                        config = new XmlClientConfigBuilder(this.configurationLocation).build();
                        if (config.getSerializationConfig().getSerializerConfigs().stream().noneMatch(s -> SessionData.class.getName().equals(s.getTypeClassName()) && s.getImplementation() instanceof SessionDataSerializer)) {
                            LOG.warn("Hazelcast xml config is missing org.eclipse.jetty.hazelcast.session.SessionDataSerializer - sessions may not serialize correctly");
                        }
                    }
                    this.hazelcastInstance = HazelcastClient.newHazelcastClient((ClientConfig)config);
                } else {
                    Config config;
                    if (StringUtil.isEmpty((String)this.configurationLocation)) {
                        SerializerConfig sc = new SerializerConfig().setImplementation((Serializer)new SessionDataSerializer()).setTypeClass(SessionData.class);
                        config = new Config();
                        config.getSerializationConfig().addSerializerConfig(sc);
                        if (this.mapConfig == null) {
                            this.mapConfig = new MapConfig();
                            this.mapConfig.setName(this.mapName);
                        } else {
                            this.mapName = this.mapConfig.getName();
                        }
                        config.addMapConfig(this.mapConfig);
                    } else {
                        config = new XmlConfigBuilder(this.configurationLocation).build();
                        if (config.getSerializationConfig().getSerializerConfigs().stream().noneMatch(s -> SessionData.class.getName().equals(s.getTypeClassName()) && s.getImplementation() instanceof SessionDataSerializer)) {
                            LOG.warn("Hazelcast xml config is missing org.eclipse.jetty.hazelcast.session.SessionDataSerializer - sessions may not serialize correctly");
                        }
                    }
                    config.setInstanceName(this.hazelcastInstanceName);
                    this.hazelcastInstance = Hazelcast.getOrCreateHazelcastInstance((Config)config);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        hazelcastSessionDataStore.setSessionDataMap((IMap<String, SessionData>)this.hazelcastInstance.getMap(this.mapName));
        hazelcastSessionDataStore.setGracePeriodSec(this.getGracePeriodSec());
        hazelcastSessionDataStore.setSavePeriodSec(this.getSavePeriodSec());
        hazelcastSessionDataStore.setUseQueries(this.isUseQueries());
        return hazelcastSessionDataStore;
    }

    public boolean isOnlyClient() {
        return this.onlyClient;
    }

    public void setOnlyClient(boolean onlyClient) {
        this.onlyClient = onlyClient;
    }

    public String getConfigurationLocation() {
        return this.configurationLocation;
    }

    public void setConfigurationLocation(String configurationLocation) {
        this.configurationLocation = configurationLocation;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    public void setMapConfig(MapConfig mapConfig) {
        this.mapConfig = mapConfig;
    }

    public String getHazelcastInstanceName() {
        return this.hazelcastInstanceName;
    }

    public void setHazelcastInstanceName(String hazelcastInstanceName) {
        this.hazelcastInstanceName = hazelcastInstanceName;
    }

    public String getAddresses() {
        return this.addresses;
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
    }
}

