/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal;

import java.util.EnumSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.internal.HTTP3ErrorCode;
import org.eclipse.jetty.http3.internal.HTTP3Session;
import org.eclipse.jetty.http3.internal.HTTP3StreamConnection;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTP3Stream
implements Stream,
CyclicTimeouts.Expirable,
Attachable {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3Stream.class);
    private final HTTP3Session session;
    private final QuicStreamEndPoint endPoint;
    private final boolean local;
    private CloseState closeState = CloseState.NOT_CLOSED;
    private FrameState frameState = FrameState.INITIAL;
    private long idleTimeout;
    private long expireNanoTime = Long.MAX_VALUE;
    private Object attachment;

    public HTTP3Stream(HTTP3Session session, QuicStreamEndPoint endPoint, boolean local) {
        this.session = session;
        this.endPoint = endPoint;
        this.local = local;
    }

    public QuicStreamEndPoint getEndPoint() {
        return this.endPoint;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    @Override
    public long getId() {
        return this.endPoint.getStreamId();
    }

    @Override
    public HTTP3Session getSession() {
        return this.session;
    }

    public boolean isLocal() {
        return this.local;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
        this.notIdle();
        this.session.scheduleIdleTimeout(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("set idle timeout {} ms for {}", (Object)idleTimeout, (Object)this);
        }
    }

    public long getExpireNanoTime() {
        return this.expireNanoTime;
    }

    protected void notIdle() {
        long idleTimeout = this.getIdleTimeout();
        if (idleTimeout > 0L) {
            this.expireNanoTime = NanoTime.now() + TimeUnit.MILLISECONDS.toNanos(idleTimeout);
        }
    }

    boolean onIdleTimeout(TimeoutException timeout) {
        boolean close;
        if (LOG.isDebugEnabled()) {
            LOG.debug("idle timeout {} ms expired on {}", (Object)this.getIdleTimeout(), (Object)this);
        }
        if (close = this.notifyIdleTimeout(timeout)) {
            this.endPoint.close(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), (Throwable)timeout);
        }
        return close;
    }

    @Override
    public CompletableFuture<Stream> data(DataFrame frame) {
        return this.write(frame);
    }

    protected CompletableFuture<Stream> write(Frame frame) {
        return this.writeFrame(frame).whenComplete((s, x) -> {
            if (x == null) {
                this.updateClose(Frame.isLast(frame), true);
            } else {
                this.session.removeStream(this, (Throwable)x);
            }
        });
    }

    @Override
    public Stream.Data readData() {
        try {
            HTTP3StreamConnection connection = (HTTP3StreamConnection)this.endPoint.getConnection();
            Stream.Data data = connection.readData();
            if (data != null) {
                this.updateClose(data.isLast(), false);
            }
            return data;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("could not read {}", (Object)this, (Object)x);
            }
            this.reset(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), x);
            throw x;
        }
    }

    @Override
    public void demand() {
        HTTP3StreamConnection connection = (HTTP3StreamConnection)this.endPoint.getConnection();
        connection.demand();
    }

    @Override
    public CompletableFuture<Stream> trailer(HeadersFrame frame) {
        if (!frame.isLast()) {
            throw new IllegalArgumentException("invalid trailer frame: property 'last' must be true");
        }
        return this.write(frame);
    }

    public boolean hasDemand() {
        HTTP3StreamConnection connection = (HTTP3StreamConnection)this.endPoint.getConnection();
        return connection.hasDemand();
    }

    public void onData(DataFrame frame) {
        if (this.validateAndUpdate(EnumSet.of(FrameState.HEADER, FrameState.DATA), FrameState.DATA)) {
            this.notIdle();
        }
    }

    public void onDataAvailable() {
        this.notifyDataAvailable();
    }

    protected abstract void notifyDataAvailable();

    public void onTrailer(HeadersFrame frame) {
        if (this.validateAndUpdate(EnumSet.of(FrameState.HEADER, FrameState.DATA), FrameState.TRAILER)) {
            this.notIdle();
            this.notifyTrailer(frame);
            this.updateClose(frame.isLast(), false);
        }
    }

    protected abstract void notifyTrailer(HeadersFrame var1);

    protected abstract boolean notifyIdleTimeout(TimeoutException var1);

    public void onFailure(long error, Throwable failure) {
        this.notifyFailure(error, failure);
        this.session.removeStream(this, failure);
    }

    protected abstract void notifyFailure(long var1, Throwable var3);

    protected boolean validateAndUpdate(EnumSet<FrameState> allowed, FrameState target) {
        if (allowed.contains((Object)this.frameState)) {
            this.frameState = target;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("invalid frame sequence, current={}, allowed={}, next={}", new Object[]{this.frameState, allowed, target});
        }
        if (this.frameState == FrameState.FAILED) {
            return false;
        }
        this.frameState = FrameState.FAILED;
        this.session.onSessionFailure(HTTP3ErrorCode.FRAME_UNEXPECTED_ERROR.code(), "invalid_frame_sequence", new IllegalStateException("invalid frame sequence"));
        return false;
    }

    public Promise.Completable<Stream> writeFrame(Frame frame) {
        this.notIdle();
        Promise.Completable completable = new Promise.Completable();
        this.session.writeMessageFrame(this.endPoint.getStreamId(), frame, Callback.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, () -> completable.succeeded((Object)this), arg_0 -> ((Promise.Completable)completable).failed(arg_0)));
        return completable;
    }

    public boolean isClosed() {
        return this.closeState == CloseState.CLOSED;
    }

    public void updateClose(boolean update, boolean local) {
        if (update) {
            switch (this.closeState) {
                case NOT_CLOSED: {
                    this.closeState = local ? CloseState.LOCALLY_CLOSED : CloseState.REMOTELY_CLOSED;
                    break;
                }
                case LOCALLY_CLOSED: {
                    if (local) break;
                    this.closeState = CloseState.CLOSED;
                    this.session.removeStream(this, null);
                    break;
                }
                case REMOTELY_CLOSED: {
                    if (!local) break;
                    this.closeState = CloseState.CLOSED;
                    this.session.removeStream(this, null);
                    break;
                }
                case CLOSED: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Override
    public void reset(long error, Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("resetting {} with error 0x{} {}", new Object[]{this, Long.toHexString(error), failure.toString()});
        }
        this.closeState = CloseState.CLOSED;
        this.session.removeStream(this, failure);
        this.endPoint.close(error, failure);
    }

    public String toString() {
        return String.format("%s@%x#%d[demand=%b,idle=%d,session=%s]", this.getClass().getSimpleName(), this.hashCode(), this.getId(), this.hasDemand(), NanoTime.millisSince((long)this.expireNanoTime), this.getSession());
    }

    private static enum CloseState {
        NOT_CLOSED,
        LOCALLY_CLOSED,
        REMOTELY_CLOSED,
        CLOSED;

    }

    protected static enum FrameState {
        INITIAL,
        INFORMATIONAL,
        HEADER,
        DATA,
        TRAILER,
        FAILED;

    }
}

