/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.jna.windows;

import com.sun.jna.Structure;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.quiche.jna.SizedStructure;
import org.eclipse.jetty.quic.quiche.jna.size_t;
import org.eclipse.jetty.quic.quiche.jna.sockaddr;
import org.eclipse.jetty.quic.quiche.jna.uint16_t;
import org.eclipse.jetty.quic.quiche.jna.uint32_t;

public interface netinet_windows {
    public static final uint16_t AF_INET = new uint16_t(2);
    public static final uint16_t AF_INET6 = new uint16_t(23);

    public static SizedStructure<sockaddr> to_sock_addr(SocketAddress socketAddress) {
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Expected InetSocketAddress instance, got: " + String.valueOf(socketAddress));
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        InetAddress address = inetSocketAddress.getAddress();
        if (address instanceof Inet4Address) {
            sockaddr_in sin = new sockaddr_in();
            sin.sin_family = AF_INET;
            sin.sin_addr = new uint32_t(ByteBuffer.wrap(address.getAddress()).getInt());
            sin.sin_port = new uint16_t(inetSocketAddress.getPort());
            return new SizedStructure<sockaddr>(sin.to_sockaddr(), new size_t(sin.size()));
        }
        if (address instanceof Inet6Address) {
            sockaddr_in6 sin6 = new sockaddr_in6();
            sin6.sin6_family = AF_INET6;
            System.arraycopy(address.getAddress(), 0, sin6.sin6_addr, 0, sin6.sin6_addr.length);
            sin6.sin6_port = new uint16_t(inetSocketAddress.getPort());
            sin6.sin6_flowinfo = new uint32_t(0);
            sin6.sin6_scope_id = new uint32_t(0);
            return new SizedStructure<sockaddr>(sin6.to_sockaddr(), new size_t(sin6.size()));
        }
        throw new UnsupportedOperationException("Unsupported InetAddress: " + String.valueOf(address));
    }

    @Structure.FieldOrder(value={"sin_family", "sin_port", "sin_addr", "sin_zero"})
    public static class sockaddr_in
    extends Structure {
        public uint16_t sin_family;
        public uint16_t sin_port;
        public uint32_t sin_addr;
        public byte[] sin_zero = new byte[8];

        public sockaddr to_sockaddr() {
            this.write();
            return new sockaddr(this.getPointer());
        }
    }

    @Structure.FieldOrder(value={"sin6_family", "sin6_port", "sin6_flowinfo", "sin6_addr", "sin6_scope_id"})
    public static class sockaddr_in6
    extends Structure {
        public uint16_t sin6_family;
        public uint16_t sin6_port;
        public uint32_t sin6_flowinfo;
        public byte[] sin6_addr = new byte[16];
        public uint32_t sin6_scope_id;

        public sockaddr to_sockaddr() {
            this.write();
            return new sockaddr(this.getPointer());
        }
    }
}

