/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.setuid;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.setuid.Group;
import org.eclipse.jetty.setuid.Passwd;
import org.eclipse.jetty.setuid.RLimit;
import org.eclipse.jetty.setuid.SetUID;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SetUIDListener
implements LifeCycle.Listener {
    private static final Logger LOG = Log.getLogger(SetUIDListener.class);
    private int _uid = 0;
    private int _gid = 0;
    private int _umask = -1;
    private boolean _startServerAsPrivileged;
    private boolean _clearSupplementalGroups;
    private RLimit _rlimitNoFiles = null;

    public void setUsername(String username) {
        Passwd passwd = SetUID.getpwnam(username);
        this._uid = passwd.getPwUid();
    }

    public String getUsername() {
        Passwd passwd = SetUID.getpwuid(this._uid);
        return passwd.getPwName();
    }

    public void setGroupname(String groupname) {
        Group group = SetUID.getgrnam(groupname);
        this._gid = group.getGrGid();
    }

    public String getGroupname() {
        Group group = SetUID.getgrgid(this._gid);
        return group.getGrName();
    }

    public int getUmask() {
        return this._umask;
    }

    public String getUmaskOctal() {
        return Integer.toOctalString(this._umask);
    }

    public void setUmask(int umask) {
        this._umask = umask;
    }

    public void setUmaskOctal(String umask) {
        this._umask = Integer.parseInt(umask, 8);
    }

    public int getUid() {
        return this._uid;
    }

    public void setUid(int uid) {
        this._uid = uid;
    }

    public void setGid(int gid) {
        this._gid = gid;
    }

    public int getGid() {
        return this._gid;
    }

    public void setRLimitNoFiles(RLimit rlimit) {
        this._rlimitNoFiles = rlimit;
    }

    public RLimit getRLimitNoFiles() {
        return this._rlimitNoFiles;
    }

    public boolean isClearSupplementalGroups() {
        return this._clearSupplementalGroups;
    }

    public void setClearSupplementalGroups(boolean clearSupplementalGroups) {
        this._clearSupplementalGroups = clearSupplementalGroups;
    }

    protected void setGidUid() {
        if (this._gid != 0) {
            if (this.isClearSupplementalGroups()) {
                LOG.info("Clearing supplemental groups", new Object[0]);
                SetUID.setgroups(new int[0]);
            }
            LOG.info("Setting GID=" + this._gid, new Object[0]);
            SetUID.setgid(this._gid);
        }
        if (this._uid != 0) {
            LOG.info("Setting UID=" + this._uid, new Object[0]);
            SetUID.setuid(this._uid);
            Passwd pw = SetUID.getpwuid(this._uid);
            System.setProperty("user.name", pw.getPwName());
            System.setProperty("user.home", pw.getPwDir());
        }
    }

    public void lifeCycleFailure(LifeCycle server, Throwable cause) {
    }

    public void lifeCycleStarted(LifeCycle server) {
        if (this._startServerAsPrivileged) {
            this.setGidUid();
        }
    }

    public void lifeCycleStarting(LifeCycle lifecycle) {
        String jettyUserEnvVariable = System.getenv("JETTY_USER");
        if (jettyUserEnvVariable != null) {
            LOG.warn("JETTY_USER set to: {}. If JETTY_USER is set, starting jetty as root and using jetty-setuid to switch user won't work!!!", new Object[]{jettyUserEnvVariable});
        }
        if (this._umask > -1) {
            LOG.info("Setting umask=0" + Integer.toString(this._umask, 8), new Object[0]);
            SetUID.setumask(this._umask);
        }
        if (this._rlimitNoFiles != null) {
            LOG.info("Current " + SetUID.getrlimitnofiles(), new Object[0]);
            int success = SetUID.setrlimitnofiles(this._rlimitNoFiles);
            if (success < 0) {
                LOG.warn("Failed to set rlimit_nofiles, returned status " + success, new Object[0]);
            }
            LOG.info("Set " + SetUID.getrlimitnofiles(), new Object[0]);
        }
        if (this._startServerAsPrivileged) {
            return;
        }
        try {
            Connector[] connectors;
            LifeCycle tplc;
            Server server = (Server)lifecycle;
            if (server.getThreadPool() instanceof LifeCycle && !(tplc = (LifeCycle)server.getThreadPool()).isRunning()) {
                server.manage((Object)tplc);
                tplc.start();
            }
            if ((connectors = server.getConnectors()) != null) {
                for (Connector connector : connectors) {
                    if (connector instanceof NetworkConnector) {
                        ((NetworkConnector)connector).open();
                        LOG.info("Opened " + connector, new Object[0]);
                        continue;
                    }
                    if (connector.isRunning()) continue;
                    server.manage((Object)connector);
                    connector.start();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setGidUid();
    }

    public void lifeCycleStopped(LifeCycle arg0) {
    }

    public void lifeCycleStopping(LifeCycle arg0) {
    }

    public boolean isStartServerAsPrivileged() {
        return this._startServerAsPrivileged;
    }

    public void setStartServerAsPrivileged(boolean startContextsAsPrivileged) {
        this._startServerAsPrivileged = startContextsAsPrivileged;
    }
}

