/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.quic.common.CloseInfo;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.quic.common.internal.QuicErrorCode;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.strategy.AdaptiveExecutionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProtocolSession
extends ContainerLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolSession.class);
    private final StreamsProducer producer = new StreamsProducer();
    private final AdaptiveExecutionStrategy strategy;
    private final QuicSession session;

    public ProtocolSession(QuicSession session) {
        this.session = session;
        this.strategy = new AdaptiveExecutionStrategy((ExecutionStrategy.Producer)this.producer, session.getExecutor());
        this.addBean(this.strategy);
    }

    public QuicSession getQuicSession() {
        return this.session;
    }

    public long getIdleTimeout() {
        return this.session.getIdleTimeout();
    }

    public int getMaxLocalStreams() {
        return this.session.getMaxLocalStreams();
    }

    public abstract Runnable getProducerTask();

    protected void produce() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processing {}", (Object)this);
        }
        this.strategy.produce();
    }

    public void offer(Runnable task, boolean dispatch) {
        this.producer.offer(task);
        if (dispatch) {
            this.strategy.dispatch();
        } else {
            this.strategy.produce();
        }
    }

    public QuicStreamEndPoint getStreamEndPoint(long streamId) {
        return this.session.getStreamEndPoint(streamId);
    }

    public QuicStreamEndPoint getOrCreateStreamEndPoint(long streamId, Consumer<QuicStreamEndPoint> consumer) {
        return this.session.getOrCreateStreamEndPoint(streamId, consumer);
    }

    protected void processWritableStreams() {
        List<Long> writableStreamIds = this.session.getWritableStreamIds();
        if (LOG.isDebugEnabled()) {
            LOG.debug("writable stream ids: {}", writableStreamIds);
        }
        for (long writableStreamId : writableStreamIds) {
            this.onWritable(writableStreamId);
        }
    }

    protected void onWritable(long writableStreamId) {
        QuicStreamEndPoint streamEndPoint = this.session.getStreamEndPoint(writableStreamId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("stream {} selected endpoint for write: {}", (Object)writableStreamId, (Object)streamEndPoint);
        }
        if (streamEndPoint != null) {
            streamEndPoint.onWritable();
        }
    }

    protected boolean processReadableStreams() {
        List<Long> readableStreamIds = this.session.getReadableStreamIds();
        if (LOG.isDebugEnabled()) {
            LOG.debug("readable stream ids: {}", readableStreamIds);
        }
        boolean result = false;
        for (long readableStreamId : readableStreamIds) {
            result |= this.onReadable(readableStreamId);
        }
        return result;
    }

    protected abstract boolean onReadable(long var1);

    public void openProtocolEndPoint(QuicStreamEndPoint endPoint) {
        Connection connection = this.getQuicSession().newConnection(endPoint);
        endPoint.setConnection(connection);
        endPoint.opened();
    }

    protected boolean onIdleTimeout() {
        return true;
    }

    protected void onFailure(long error, String reason, Throwable failure) {
    }

    public void inwardClose(long error, String reason) {
        this.outwardClose(error, reason);
    }

    public void outwardClose(long error, String reason) {
        this.getQuicSession().outwardClose(error, reason);
    }

    public CompletableFuture<Void> shutdown() {
        this.outwardClose(QuicErrorCode.NO_ERROR.code(), "shutdown");
        return CompletableFuture.completedFuture(null);
    }

    protected abstract void onClose(long var1, String var3);

    public String toString() {
        return String.format("%s@%x[%s]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.getQuicSession()});
    }

    private class StreamsProducer
    implements ExecutionStrategy.Producer {
        private final AutoLock lock = new AutoLock();
        private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();

        private StreamsProducer() {
        }

        public void offer(Runnable task) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("enqueuing stream task {} on {}", (Object)task, (Object)ProtocolSession.this);
            }
            try (AutoLock l = this.lock.lock();){
                this.tasks.offer(task);
            }
        }

        private Runnable poll() {
            try (AutoLock l = this.lock.lock();){
                Runnable runnable = this.tasks.poll();
                return runnable;
            }
        }

        public Runnable produce() {
            boolean loop;
            Runnable task = this.poll();
            if (LOG.isDebugEnabled()) {
                LOG.debug("dequeued existing stream task {} on {}", (Object)task, (Object)ProtocolSession.this);
            }
            if (task != null) {
                return task;
            }
            do {
                ProtocolSession.this.processWritableStreams();
                loop = ProtocolSession.this.processReadableStreams();
                task = this.poll();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("dequeued produced stream task {} on {}", (Object)task, (Object)ProtocolSession.this);
                }
                if (task == null) continue;
                return task;
            } while (loop);
            CloseInfo closeInfo = ProtocolSession.this.session.getRemoteCloseInfo();
            if (closeInfo != null) {
                ProtocolSession.this.onClose(closeInfo.error(), closeInfo.reason());
            }
            return null;
        }
    }

    public static interface Factory {
        public ProtocolSession newProtocolSession(QuicSession var1, Map<String, Object> var2);
    }
}

