/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.regex.Matcher;
import org.eclipse.jetty.rewrite.handler.RegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.Name;

public class HeaderRegexRule
extends RegexRule {
    private String _headerName;
    private String _headerValue;
    private boolean _add;

    public HeaderRegexRule() {
    }

    public HeaderRegexRule(@Name(value="regex") String regex, @Name(value="name") String name, @Name(value="value") String value) {
        super(regex);
        this._headerName = name;
        this._headerValue = value;
    }

    public String getHeaderName() {
        return this._headerName;
    }

    public void setHeaderName(String name) {
        this._headerName = name;
    }

    public String getHeaderValue() {
        return this._headerValue;
    }

    public void setHeaderValue(String value) {
        this._headerValue = value;
    }

    public boolean isAdd() {
        return this._add;
    }

    public void setAdd(boolean add) {
        this._add = add;
    }

    @Override
    protected Rule.Handler apply(Rule.Handler input, final Matcher matcher) throws IOException {
        return new Rule.Handler((Request)input){

            @Override
            public boolean handle(Response response, Callback callback) throws Exception {
                if (HeaderRegexRule.this.isAdd()) {
                    response.getHeaders().add(HeaderRegexRule.this.getHeaderName(), matcher.replaceAll(HeaderRegexRule.this.getHeaderValue()));
                } else {
                    response.getHeaders().put(HeaderRegexRule.this.getHeaderName(), matcher.replaceAll(HeaderRegexRule.this.getHeaderValue()));
                }
                return super.handle(response, callback);
            }
        };
    }

    @Override
    public String toString() {
        return "%s[header:%s=%s]".formatted(super.toString(), this.getHeaderName(), this.getHeaderValue());
    }
}

