/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.rewrite.handler.PatternRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewritePatternRule
extends PatternRule {
    private static final Logger LOG = LoggerFactory.getLogger(RewritePatternRule.class);
    private String _path;
    private String _query;

    public RewritePatternRule() {
    }

    public RewritePatternRule(@Name(value="pattern") String pattern, @Name(value="replacement") String replacement) {
        super(pattern);
        this.setReplacement(replacement);
    }

    public void setReplacement(String replacement) {
        if (replacement == null) {
            this._path = null;
            this._query = null;
        } else {
            String[] split = replacement.split("\\?", 2);
            this._path = split[0];
            this._query = split.length == 2 ? split[1] : null;
        }
    }

    @Override
    public Rule.Handler apply(Rule.Handler input) throws IOException {
        HttpURI httpURI = input.getHttpURI();
        String newQuery = URIUtil.addQueries((String)httpURI.getQuery(), (String)this._query);
        String newPath = URIUtil.addPaths((String)this._path, (String)ServletPathSpec.pathInfo((String)this.getPattern(), (String)httpURI.getPath()));
        HttpURI.Mutable newURI = HttpURI.build((HttpURI)httpURI, (String)newPath, (String)httpURI.getParam(), (String)newQuery);
        if (LOG.isDebugEnabled()) {
            LOG.debug("rewriting {} to {}", (Object)httpURI, (Object)newURI);
        }
        return new Rule.HttpURIHandler((Request)input, (HttpURI)newURI);
    }

    @Override
    public String toString() {
        return "%s[rewrite:%s%s]".formatted(super.toString(), this._path, this._query == null ? "" : "?" + this._query);
    }
}

