/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public abstract class Rule {
    private boolean _terminating;

    public abstract Handler matchAndApply(Handler var1) throws IOException;

    public boolean isTerminating() {
        return this._terminating;
    }

    public void setTerminating(boolean value) {
        this._terminating = value;
    }

    public String toString() {
        return "%s@%x[terminating=%b]".formatted(this.getClass().getSimpleName(), this.hashCode(), this.isTerminating());
    }

    public static class HttpURIHandler
    extends Handler {
        private final HttpURI _uri;

        public HttpURIHandler(Request request, HttpURI uri) {
            super(request);
            this._uri = uri;
        }

        public HttpURI getHttpURI() {
            return this._uri;
        }
    }

    public static class Handler
    extends Request.Wrapper
    implements Request.Handler {
        private volatile Request.Handler _handler;

        public Handler(Request request) {
            super(request);
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            return this.handle(response, callback);
        }

        protected boolean handle(Response response, Callback callback) throws Exception {
            Request.Handler handler = this._handler;
            return handler != null && handler.handle((Request)this, response, callback);
        }

        public void setHandler(Request.Handler handler) {
            this._handler = handler;
        }
    }
}

