/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.cdi;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import java.util.EventListener;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jetty.ee9.cdi.CdiDecoratingListener;
import org.eclipse.jetty.ee9.cdi.CdiSpiDecorator;
import org.eclipse.jetty.ee9.servlet.ServletContextHandler;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiServletContainerInitializer
implements ServletContainerInitializer {
    public static final String CDI_INTEGRATION_ATTRIBUTE = "org.eclipse.jetty.ee9.cdi";
    private static final Logger LOG = LoggerFactory.getLogger(CdiServletContainerInitializer.class);

    public void onStartup(Set<Class<?>> c, ServletContext ctx) {
        block13: {
            try {
                ServletContextHandler context = ServletContextHandler.getServletContextHandler((ServletContext)ctx);
                Objects.requireNonNull(context);
                ClassLoader loader = context.getClassLoader();
                if (loader == null) {
                    Loader.loadClass((String)"jakarta.enterprise.inject.spi.CDI");
                } else {
                    loader.loadClass("jakarta.enterprise.inject.spi.CDI");
                }
                String mode = ctx.getInitParameter(CDI_INTEGRATION_ATTRIBUTE);
                if (mode == null && (mode = (String)context.getServer().getAttribute(CDI_INTEGRATION_ATTRIBUTE)) == null) {
                    mode = "CdiSpiDecorator";
                }
                switch (mode) {
                    case "CdiSpiDecorator": {
                        context.getObjectFactory().addDecorator((Decorator)new CdiSpiDecorator(context));
                        break;
                    }
                    case "CdiDecoratingListener": {
                        context.addEventListener((EventListener)((Object)new CdiDecoratingListener(context)));
                        break;
                    }
                    default: {
                        throw new IllegalStateException(mode);
                    }
                }
                LOG.info("{} enabled in {}", (Object)mode, (Object)ctx);
            }
            catch (ClassNotFoundException | UnsupportedOperationException e) {
                if (!LOG.isDebugEnabled()) break block13;
                LOG.debug("CDI not found in {}", (Object)ctx, (Object)e);
            }
        }
    }
}

