/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.security.jaspi;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.RegistrationListener;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.ee10.security.jaspi.JaspiMessageInfo;
import org.eclipse.jetty.ee10.security.jaspi.ServletCallbackHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.EmptyLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.UserPrincipal;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class JaspiAuthenticator
extends LoginAuthenticator {
    private final Subject _serviceSubject;
    private final String _appContext;
    private final boolean _allowLazyAuthentication;
    private final AuthConfigFactory _authConfigFactory = AuthConfigFactory.getFactory();
    private Map _authProperties;
    private IdentityService _identityService;
    private ServletCallbackHandler _callbackHandler;
    private ServerAuthConfig _authConfig;

    public JaspiAuthenticator(Subject serviceSubject, String appContext, boolean allowLazyAuthentication) {
        this._serviceSubject = serviceSubject;
        this._appContext = appContext;
        this._allowLazyAuthentication = allowLazyAuthentication;
    }

    @Deprecated
    public JaspiAuthenticator(ServerAuthConfig authConfig, Map authProperties, ServletCallbackHandler callbackHandler, Subject serviceSubject, boolean allowLazyAuthentication, IdentityService identityService) {
        if (callbackHandler == null) {
            throw new NullPointerException("No CallbackHandler");
        }
        if (authConfig == null) {
            throw new NullPointerException("No AuthConfig");
        }
        this._authProperties = authProperties;
        this._callbackHandler = callbackHandler;
        this._serviceSubject = serviceSubject;
        this._allowLazyAuthentication = allowLazyAuthentication;
        this._identityService = identityService;
        this._appContext = null;
        this._authConfig = authConfig;
    }

    public void setConfiguration(Authenticator.Configuration configuration) {
        LoginService loginService = configuration.getLoginService();
        if (loginService == null) {
            configuration = new JaspiAuthenticatorConfiguration((Authenticator.Configuration)configuration);
            loginService = configuration.getLoginService();
        }
        super.setConfiguration(configuration);
        if (this._authConfig == null) {
            this._identityService = configuration.getIdentityService();
            this._callbackHandler = new ServletCallbackHandler(loginService);
            this._authProperties = new HashMap();
            for (String key : configuration.getParameterNames()) {
                this._authProperties.put(key, configuration.getParameter(key));
            }
        }
    }

    private ServerAuthConfig getAuthConfig() throws AuthException {
        if (this._authConfig != null) {
            return this._authConfig;
        }
        RegistrationListener listener = (layer, appContext) -> {
            this._authConfig = null;
        };
        AuthConfigProvider authConfigProvider = this._authConfigFactory.getConfigProvider("HttpServlet", this._appContext, listener);
        if (authConfigProvider == null) {
            this._authConfigFactory.detachListener(listener, "HttpServlet", this._appContext);
            return null;
        }
        this._authConfig = authConfigProvider.getServerAuthConfig("HttpServlet", this._appContext, (CallbackHandler)this._callbackHandler);
        return this._authConfig;
    }

    public String getAuthenticationType() {
        return "JASPI";
    }

    public UserIdentity login(String username, Object password, Request request, Response response) {
        UserIdentity user = this._loginService.login(username, password, request, arg_0 -> ((Request)request).getSession(arg_0));
        if (user != null) {
            this.renewSession(request, response);
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            if (session != null) {
                SessionAuthentication sessionAuth = new SessionAuthentication(this.getAuthenticationType(), user, password);
                session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)sessionAuth);
            }
        }
        return user;
    }

    public AuthenticationState validateRequest(Request request, Response response, Callback callback) throws ServerAuthException {
        JaspiMessageInfo info = new JaspiMessageInfo(request, response, callback);
        request.setAttribute("org.eclipse.jetty.ee10.security.jaspi.info", (Object)info);
        return this.validateRequest(info);
    }

    public AuthenticationState validateRequest(JaspiMessageInfo messageInfo) throws ServerAuthException {
        try {
            Subject clientSubject;
            ServerAuthConfig authConfig = this.getAuthConfig();
            if (authConfig == null) {
                throw new ServerAuthException("No ServerAuthConfig");
            }
            String authContextId = authConfig.getAuthContextID((MessageInfo)messageInfo);
            ServerAuthContext authContext = authConfig.getAuthContext(authContextId, this._serviceSubject, this._authProperties);
            AuthStatus authStatus = authContext.validateRequest((MessageInfo)messageInfo, clientSubject = new Subject(), this._serviceSubject);
            if (authStatus == AuthStatus.SEND_CONTINUE) {
                return AuthenticationState.CHALLENGE;
            }
            if (authStatus == AuthStatus.SEND_FAILURE) {
                return AuthenticationState.SEND_FAILURE;
            }
            if (authStatus == AuthStatus.SUCCESS) {
                SessionAuthentication cached;
                UserIdentity userIdentity;
                Set<UserIdentity> ids = clientSubject.getPrivateCredentials(UserIdentity.class);
                if (ids.size() > 0) {
                    userIdentity = ids.iterator().next();
                } else {
                    GroupPrincipalCallback groupPrincipalCallback;
                    CallerPrincipalCallback principalCallback = this._callbackHandler.getThreadCallerPrincipalCallback();
                    if (principalCallback == null) {
                        return null;
                    }
                    Principal principal = principalCallback.getPrincipal();
                    if (principal == null) {
                        String principalName = principalCallback.getName();
                        Set<Principal> principals = principalCallback.getSubject().getPrincipals();
                        for (Principal p : principals) {
                            if (!p.getName().equals(principalName)) continue;
                            principal = p;
                            break;
                        }
                        if (principal == null) {
                            principal = new UserPrincipal(principalName, null);
                        }
                    }
                    String[] groups = (groupPrincipalCallback = this._callbackHandler.getThreadGroupPrincipalCallback()) == null ? null : groupPrincipalCallback.getGroups();
                    userIdentity = this._identityService.newUserIdentity(clientSubject, principal, groups);
                }
                HttpSession session = ((HttpServletRequest)messageInfo.getRequestMessage()).getSession(false);
                SessionAuthentication sessionAuthentication = cached = session == null ? null : (SessionAuthentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
                if (cached != null) {
                    return cached;
                }
                return new LoginAuthenticator.UserAuthenticationSucceeded(this.getAuthenticationType(), userIdentity);
            }
            if (authStatus == AuthStatus.SEND_SUCCESS) {
                return AuthenticationState.SEND_SUCCESS;
            }
            if (authStatus == AuthStatus.FAILURE) {
                Response.writeError((Request)messageInfo.getBaseRequest(), (Response)messageInfo.getBaseResponse(), (Callback)messageInfo.getCallback(), (int)403);
                return AuthenticationState.SEND_FAILURE;
            }
            throw new IllegalStateException("No AuthStatus returned");
        }
        catch (AuthException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    public boolean secureResponse(Request request, Response response, Callback callback, boolean mandatory, AuthenticationState.Succeeded validatedSucceeded) throws ServerAuthException {
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
        JaspiMessageInfo info = (JaspiMessageInfo)servletContextRequest.getServletApiRequest().getAttribute("org.eclipse.jetty.ee10.security.jaspi.info");
        if (info == null) {
            throw new NullPointerException("MessageInfo from request missing: " + String.valueOf(request));
        }
        return this.secureResponse(info, (AuthenticationState)validatedSucceeded);
    }

    public boolean secureResponse(JaspiMessageInfo messageInfo, AuthenticationState validatedUser) throws ServerAuthException {
        try {
            ServerAuthConfig authConfig = this.getAuthConfig();
            if (authConfig == null) {
                throw new NullPointerException("no ServerAuthConfig found for context");
            }
            String authContextId = authConfig.getAuthContextID((MessageInfo)messageInfo);
            ServerAuthContext authContext = authConfig.getAuthContext(authContextId, this._serviceSubject, this._authProperties);
            if (validatedUser instanceof AuthenticationState.Succeeded) {
                AuthenticationState.Succeeded userAuthenticated = (AuthenticationState.Succeeded)validatedUser;
                authContext.cleanSubject((MessageInfo)messageInfo, userAuthenticated.getUserIdentity().getSubject());
            }
            AuthStatus status = authContext.secureResponse((MessageInfo)messageInfo, this._serviceSubject);
            return AuthStatus.SEND_SUCCESS.equals(status);
        }
        catch (AuthException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    private static class JaspiAuthenticatorConfiguration
    extends Authenticator.Configuration.Wrapper {
        private final LoginService loginService = new EmptyLoginService();

        public JaspiAuthenticatorConfiguration(Authenticator.Configuration configuration) {
            super(configuration);
        }

        public LoginService getLoginService() {
            return this.loginService;
        }
    }
}

