/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.api;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public interface Callback {
    public static final Callback NOOP = new Callback(){};

    public static Callback from(final Runnable success, final Consumer<Throwable> failure) {
        return new Callback(){

            @Override
            public void succeed() {
                success.run();
            }

            @Override
            public void fail(Throwable x) {
                failure.accept(x);
            }
        };
    }

    default public void succeed() {
    }

    default public void fail(Throwable x) {
    }

    public static class Completable
    extends CompletableFuture<Void>
    implements Callback {
        public static Completable with(Consumer<Completable> consumer) {
            Completable completable = new Completable();
            consumer.accept(completable);
            return completable;
        }

        @Override
        public void succeed() {
            this.complete(null);
        }

        @Override
        public void fail(Throwable x) {
            this.completeExceptionally(x);
        }

        public Completable compose(Consumer<Completable> consumer) {
            Completable completable = new Completable();
            this.thenAccept((T ignored) -> consumer.accept(completable));
            return completable;
        }
    }
}

