/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.metadata;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.util.StringUtil;

public class Http3Fields
implements HttpFields {
    public static final HttpField[] STATUSES = new HttpField[599];
    private static final EnumSet<HttpHeader> IGNORED_HEADERS = EnumSet.of(HttpHeader.CONNECTION, HttpHeader.KEEP_ALIVE, HttpHeader.PROXY_CONNECTION, HttpHeader.TRANSFER_ENCODING, HttpHeader.UPGRADE);
    public static final PreEncodedHttpField TE_TRAILERS = new PreEncodedHttpField(HttpHeader.TE, "trailers");
    public static final PreEncodedHttpField C_SCHEME_HTTP = new PreEncodedHttpField(HttpHeader.C_SCHEME, "http");
    public static final PreEncodedHttpField C_SCHEME_HTTPS = new PreEncodedHttpField(HttpHeader.C_SCHEME, "https");
    public static final EnumMap<HttpMethod, PreEncodedHttpField> C_METHODS = new EnumMap(HttpMethod.class);
    private final List<HttpField> pseudoHeaders = new ArrayList<HttpField>(8);
    private final HttpFields httpFields;
    private Set<String> hopHeaders;
    private HttpField contentLengthHeader;

    public Http3Fields(MetaData metadata) {
        this.httpFields = metadata.getHttpFields();
        if (metadata.isRequest()) {
            MetaData.Request request = (MetaData.Request)metadata;
            String method = request.getMethod();
            HttpMethod httpMethod = method == null ? null : HttpMethod.fromString((String)method);
            HttpField methodField = (HttpField)C_METHODS.get(httpMethod);
            this.pseudoHeaders.add(methodField == null ? new HttpField(HttpHeader.C_METHOD, method) : methodField);
            this.pseudoHeaders.add(new HttpField(HttpHeader.C_AUTHORITY, request.getHttpURI().getAuthority()));
            boolean isConnect = HttpMethod.CONNECT.is(request.getMethod());
            String protocol = request.getProtocol();
            if (!isConnect || protocol != null) {
                this.pseudoHeaders.add((HttpField)(HttpScheme.HTTPS.is(request.getHttpURI().getScheme()) ? C_SCHEME_HTTPS : C_SCHEME_HTTP));
                this.pseudoHeaders.add(new HttpField(HttpHeader.C_PATH, request.getHttpURI().getPathQuery()));
                if (protocol != null) {
                    this.pseudoHeaders.add(new HttpField(HttpHeader.C_PROTOCOL, protocol));
                }
            }
        } else if (metadata.isResponse()) {
            HttpField status;
            MetaData.Response response = (MetaData.Response)metadata;
            int code = response.getStatus();
            HttpField httpField = status = code < STATUSES.length ? STATUSES[code] : null;
            if (status == null) {
                status = new HttpField.IntValueHttpField(HttpHeader.C_STATUS, code);
            }
            this.pseudoHeaders.add(status);
        }
        if (this.httpFields != null) {
            long contentLength;
            for (String value : this.httpFields.getCSV(HttpHeader.CONNECTION, false)) {
                if (this.hopHeaders == null) {
                    this.hopHeaders = new HashSet<String>();
                }
                this.hopHeaders.add(StringUtil.asciiToLowerCase((String)value));
            }
            if (this.httpFields.getField(HttpHeader.CONTENT_LENGTH) == null && (contentLength = metadata.getContentLength()) >= 0L) {
                this.contentLengthHeader = new HttpField(HttpHeader.CONTENT_LENGTH, String.valueOf(contentLength));
            }
        }
    }

    public HttpFields asImmutable() {
        return HttpFields.from((HttpField[])((HttpField[])this.stream().toArray(HttpField[]::new)));
    }

    public HttpFields takeAsImmutable() {
        return this.asImmutable();
    }

    public HttpField getField(int index) {
        return this.stream().skip(index).findFirst().orElse(null);
    }

    public int size() {
        return Math.toIntExact(this.stream().count());
    }

    public Stream<HttpField> stream() {
        Stream<HttpField> pseudoHeadersStream = this.pseudoHeaders.stream();
        if (this.httpFields == null) {
            return pseudoHeadersStream;
        }
        Stream<HttpField> httpFieldStream = this.httpFields.stream().filter(field -> {
            HttpHeader header = field.getHeader();
            if (header != null && IGNORED_HEADERS.contains(header)) {
                return false;
            }
            if (header == HttpHeader.TE && !field.contains("trailers")) {
                return false;
            }
            String name = field.getLowerCaseName();
            return this.hopHeaders == null || !this.hopHeaders.contains(name);
        });
        if (this.contentLengthHeader != null) {
            return Stream.concat(pseudoHeadersStream, Stream.concat(httpFieldStream, Stream.of(this.contentLengthHeader)));
        }
        return Stream.concat(pseudoHeadersStream, httpFieldStream);
    }

    public Iterator<HttpField> iterator() {
        return this.stream().iterator();
    }

    static {
        for (HttpStatus.Code code : HttpStatus.Code.values()) {
            Http3Fields.STATUSES[code.getCode()] = new PreEncodedHttpField(HttpHeader.C_STATUS, Integer.toString(code.getCode()));
        }
        for (HttpStatus.Code code : HttpMethod.values()) {
            C_METHODS.put((HttpMethod)code, new PreEncodedHttpField(HttpHeader.C_METHOD, code.asString()));
        }
    }
}

