/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletChannel;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.servlet.writer.EncodingHttpWriter;
import org.eclipse.jetty.ee10.servlet.writer.Iso88591HttpWriter;
import org.eclipse.jetty.ee10.servlet.writer.ResponseWriter;
import org.eclipse.jetty.ee10.servlet.writer.Utf8HttpWriter;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;

public class ServletApiResponse
implements HttpServletResponse {
    private static final int MIN_BUFFER_SIZE = 1;
    private static final EnumSet<ServletContextResponse.EncodingFrom> LOCALE_OVERRIDE = EnumSet.of(ServletContextResponse.EncodingFrom.NOT_SET, ServletContextResponse.EncodingFrom.DEFAULT, ServletContextResponse.EncodingFrom.INFERRED, ServletContextResponse.EncodingFrom.SET_LOCALE);
    private final ServletChannel _servletChannel;
    private final ServletContextHandler.ServletRequestInfo _servletRequestInfo;
    private final ServletContextHandler.ServletResponseInfo _servletResponseInfo;

    protected ServletApiResponse(ServletContextResponse servletContextResponse) {
        this._servletChannel = servletContextResponse.getServletContextRequest().getServletChannel();
        this._servletRequestInfo = servletContextResponse.getServletContextRequest();
        this._servletResponseInfo = servletContextResponse;
    }

    public ServletChannel getServletChannel() {
        return this._servletChannel;
    }

    public ServletContextHandler.ServletRequestInfo getServletRequestInfo() {
        return this._servletRequestInfo;
    }

    public ServletContextHandler.ServletResponseInfo getServletResponseInfo() {
        return this._servletResponseInfo;
    }

    public Response getResponse() {
        return this.getServletChannel().getResponse();
    }

    public void addCookie(Cookie cookie) {
        if (StringUtil.isBlank((String)cookie.getName())) {
            throw new IllegalArgumentException("Cookie.name cannot be blank/null");
        }
        this.addCookie(new HttpCookieFacade(cookie));
    }

    public void addCookie(HttpCookie cookie) {
        Response.addCookie((Response)this.getResponse(), (HttpCookie)cookie);
    }

    public boolean containsHeader(String name) {
        return this.getResponse().getHeaders().contains(name);
    }

    public String encodeURL(String url) {
        SessionHandler sessionManager = this.getServletChannel().getServletContextHandler().getSessionHandler();
        if (sessionManager == null) {
            return url;
        }
        return sessionManager.encodeURI(this.getServletChannel().getRequest(), url, this.getServletChannel().getServletContextRequest().getServletApiRequest().isRequestedSessionIdFromCookie());
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        switch (sc) {
            case -1: {
                this.getServletChannel().abort(new IOException(msg));
                break;
            }
            case 102: 
            case 103: {
                if (this.isCommitted()) break;
                try (Blocker.Callback blocker = Blocker.callback();){
                    CompletableFuture completable = this.getServletChannel().getServletContextResponse().writeInterim(sc, this.getResponse().getHeaders().asImmutable());
                    blocker.completeWith(completable);
                    blocker.block();
                    break;
                }
            }
            default: {
                if (this.isCommitted()) {
                    throw new IllegalStateException("Committed");
                }
                this.getServletRequestInfo().getServletRequestState().sendError(sc, msg);
            }
        }
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    public void sendRedirect(String location) throws IOException {
        this.sendRedirect(302, location);
    }

    public void sendRedirect(int code, String location) throws IOException {
        this.resetBuffer();
        try (Blocker.Callback callback = Blocker.callback();){
            Response.sendRedirect((Request)this.getServletRequestInfo().getRequest(), (Response)this.getResponse(), (Callback)callback, (int)code, (String)location, (boolean)false);
            callback.block();
        }
    }

    public void setDateHeader(String name, long date) {
        this.getResponse().getHeaders().putDate(name, date);
    }

    public void addDateHeader(String name, long date) {
        this.getResponse().getHeaders().addDateField(name, date);
    }

    public void setHeader(String name, String value) {
        this.getResponse().getHeaders().put(name, value);
    }

    public void addHeader(String name, String value) {
        this.getResponse().getHeaders().add(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (!this.isCommitted()) {
            this.getResponse().getHeaders().put(name, (long)value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (!this.isCommitted()) {
            this.getResponse().getHeaders().add(name, Integer.toString(value));
        }
    }

    public void setStatus(int sc) {
        this.getResponse().setStatus(sc);
    }

    public int getStatus() {
        int status = this.getResponse().getStatus();
        return status == 0 ? 200 : status;
    }

    public String getHeader(String name) {
        return this.getResponse().getHeaders().get(name);
    }

    public Collection<String> getHeaders(String name) {
        return this.getResponse().getHeaders().getValuesList(name);
    }

    public Collection<String> getHeaderNames() {
        return this.getResponse().getHeaders().getFieldNamesCollection();
    }

    public String getCharacterEncoding() {
        return this.getServletResponseInfo().getCharacterEncoding(false);
    }

    public String getContentType() {
        return this.getServletResponseInfo().getContentType();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.getServletResponseInfo().getOutputType() == ServletContextResponse.OutputType.WRITER) {
            throw new IllegalStateException("WRITER");
        }
        this.getServletResponseInfo().setOutputType(ServletContextResponse.OutputType.STREAM);
        return this.getServletChannel().getHttpOutput();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.getServletResponseInfo().getOutputType() == ServletContextResponse.OutputType.STREAM) {
            throw new IllegalStateException("STREAM");
        }
        ResponseWriter writer = this.getServletResponseInfo().getWriter();
        if (this.getServletResponseInfo().getOutputType() == ServletContextResponse.OutputType.NONE) {
            String encoding = this.getServletResponseInfo().getCharacterEncoding(true);
            Locale locale = this.getLocale();
            if (writer != null && writer.isFor(locale, encoding)) {
                writer.reopen();
            } else if (MimeTypes.ISO_8859_1.equalsIgnoreCase(encoding)) {
                writer = new ResponseWriter(new Iso88591HttpWriter(this.getServletChannel().getHttpOutput()), locale, encoding);
                this.getServletResponseInfo().setWriter(writer);
            } else if (MimeTypes.UTF8.equalsIgnoreCase(encoding)) {
                writer = new ResponseWriter(new Utf8HttpWriter(this.getServletChannel().getHttpOutput()), locale, encoding);
                this.getServletResponseInfo().setWriter(writer);
            } else {
                writer = new ResponseWriter(new EncodingHttpWriter(this.getServletChannel().getHttpOutput(), encoding), locale, encoding);
                this.getServletResponseInfo().setWriter(writer);
            }
            this.getServletResponseInfo().setOutputType(ServletContextResponse.OutputType.WRITER);
        }
        return writer;
    }

    public void setCharacterEncoding(String encoding) {
        this.getServletResponseInfo().setCharacterEncoding(encoding, ServletContextResponse.EncodingFrom.SET_CHARACTER_ENCODING);
    }

    public void setContentLength(int len) {
        this.setContentLengthLong(len);
    }

    public void setContentLengthLong(long len) {
        if (this.isCommitted()) {
            return;
        }
        if (len > 0L) {
            this.getResponse().getHeaders().put(HttpHeader.CONTENT_LENGTH, len);
        } else if (len == 0L) {
            this.getResponse().getHeaders().put(HttpFields.CONTENT_LENGTH_0);
        } else {
            this.getResponse().getHeaders().remove(HttpHeader.CONTENT_LENGTH);
        }
    }

    public void setContentType(String contentType) {
        if (this.isCommitted()) {
            return;
        }
        if (contentType == null) {
            if (this.getServletResponseInfo().isWriting() && this.getServletResponseInfo().getCharacterEncoding() != null) {
                throw new IllegalStateException();
            }
            this.getResponse().getHeaders().remove(HttpHeader.CONTENT_TYPE);
        } else {
            this.getResponse().getHeaders().put(HttpHeader.CONTENT_TYPE, contentType);
        }
    }

    public long getContentCount() {
        return this.getServletChannel().getHttpOutput().getWritten();
    }

    public void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException("cannot set buffer size after response is in committed state");
        }
        if (this.getContentCount() > 0L) {
            throw new IllegalStateException("cannot set buffer size after response has " + this.getContentCount() + " bytes already written");
        }
        if (size < 1) {
            size = 1;
        }
        this.getServletChannel().getHttpOutput().setBufferSize(size);
    }

    public int getBufferSize() {
        return this.getServletChannel().getHttpOutput().getBufferSize();
    }

    public void flushBuffer() throws IOException {
        if (!this.getServletChannel().getHttpOutput().isClosed()) {
            this.getServletChannel().getHttpOutput().flush();
        }
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this.getServletChannel().getHttpOutput().resetBuffer();
        this.getServletChannel().getHttpOutput().reopen();
    }

    public boolean isCommitted() {
        if (this.getServletChannel().isSendError()) {
            return true;
        }
        return this.getServletChannel().isCommitted();
    }

    public void reset() {
        HttpCookie cookie;
        SessionManager sessionManager;
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this.getResponse().reset();
        ServletApiRequest servletApiRequest = this.getServletChannel().getServletContextRequest().getServletApiRequest();
        ManagedSession session = servletApiRequest.getServletRequestInfo().getManagedSession();
        if (session != null && session.isNew() && (sessionManager = servletApiRequest.getServletRequestInfo().getSessionManager()) != null && (cookie = sessionManager.getSessionCookie(session, servletApiRequest.getServletConnection().isSecure())) != null) {
            this.addCookie(cookie);
        }
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (locale == null) {
            this.getServletResponseInfo().setLocale(null);
            this.getResponse().getHeaders().remove(HttpHeader.CONTENT_LANGUAGE);
            if (this.getServletResponseInfo().getEncodingFrom() == ServletContextResponse.EncodingFrom.SET_LOCALE) {
                this.getServletResponseInfo().setCharacterEncoding(null, ServletContextResponse.EncodingFrom.NOT_SET);
            }
        } else {
            this.getServletResponseInfo().setLocale(locale);
            this.getResponse().getHeaders().put(HttpHeader.CONTENT_LANGUAGE, StringUtil.replace((String)locale.toString(), (char)'_', (char)'-'));
            if (this.getServletResponseInfo().getOutputType() != ServletContextResponse.OutputType.NONE) {
                return;
            }
            ServletContextHandler.ServletScopedContext context = this.getServletChannel().getContext();
            if (context == null) {
                return;
            }
            String charset = context.getServletContextHandler().getLocaleEncoding(locale);
            if (!StringUtil.isEmpty((String)charset) && LOCALE_OVERRIDE.contains((Object)this.getServletResponseInfo().getEncodingFrom())) {
                this.getServletResponseInfo().setCharacterEncoding(charset, ServletContextResponse.EncodingFrom.SET_LOCALE);
            }
        }
    }

    public Locale getLocale() {
        if (this.getServletResponseInfo().getLocale() == null) {
            return Locale.getDefault();
        }
        return this.getServletResponseInfo().getLocale();
    }

    public Supplier<Map<String, String>> getTrailerFields() {
        return this.getServletResponseInfo().getTrailers();
    }

    public void setTrailerFields(Supplier<Map<String, String>> trailers) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        HttpVersion version = HttpVersion.fromString((String)this.getServletRequestInfo().getRequest().getConnectionMetaData().getProtocol());
        if (version == null || version.compareTo((Enum)HttpVersion.HTTP_1_1) < 0) {
            throw new IllegalStateException("Trailers not supported in " + String.valueOf(version));
        }
        this.getServletResponseInfo().setTrailers(trailers);
        this.getResponse().setTrailersSupplier(() -> {
            Map map = (Map)trailers.get();
            if (map == null) {
                return null;
            }
            HttpFields.Mutable fields = HttpFields.build((int)map.size());
            for (Map.Entry e : map.entrySet()) {
                fields.add((String)e.getKey(), (String)e.getValue());
            }
            return fields;
        });
    }

    public String toString() {
        return "%s@%x{%s,%s}".formatted(this.getClass().getSimpleName(), this.hashCode(), this.getResponse(), this.getServletResponseInfo());
    }

    static class HttpCookieFacade
    implements HttpCookie {
        private final Cookie _cookie;

        public HttpCookieFacade(Cookie cookie) {
            this._cookie = cookie;
        }

        public String getComment() {
            return this._cookie.getComment();
        }

        public String getDomain() {
            return this._cookie.getDomain();
        }

        public long getMaxAge() {
            return this._cookie.getMaxAge();
        }

        public String getPath() {
            return this._cookie.getPath();
        }

        public boolean isSecure() {
            return this._cookie.getSecure();
        }

        public String getName() {
            return this._cookie.getName();
        }

        public String getValue() {
            return this._cookie.getValue();
        }

        public int getVersion() {
            return this._cookie.getVersion();
        }

        public HttpCookie.SameSite getSameSite() {
            return HttpCookie.SameSite.from((String)this.getAttributes().get("SameSite"));
        }

        public boolean isHttpOnly() {
            return this._cookie.isHttpOnly();
        }

        public Map<String, String> getAttributes() {
            return this._cookie.getAttributes();
        }

        public int hashCode() {
            return HttpCookie.hashCode((HttpCookie)this);
        }

        public boolean equals(Object obj) {
            return HttpCookie.equals((HttpCookie)this, (Object)obj);
        }

        public String toString() {
            return HttpCookie.toString((HttpCookie)this);
        }
    }
}

