/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.nosql.NoSqlSessionDataStore;
import org.eclipse.jetty.nosql.mongodb.MongoUtils;
import org.eclipse.jetty.session.SessionContext;
import org.eclipse.jetty.session.SessionData;
import org.eclipse.jetty.session.UnreadableSessionDataException;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public class MongoSessionDataStore
extends NoSqlSessionDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(MongoSessionDataStore.class);
    public static final String __METADATA = "__metadata__";
    public static final String __CONTEXT = "context";
    public static final String __VERSION = "__metadata__.version";
    public static final String __LASTSAVED = "__metadata__.lastSaved";
    public static final String __LASTNODE = "__metadata__.lastNode";
    public static final String __ACCESSED = "accessed";
    public static final String __LAST_ACCESSED = "lastAccessed";
    public static final String __ATTRIBUTES = "attributes";
    public static final String __EXPIRY = "expiry";
    public static final String __MAX_IDLE = "maxIdle";
    public static final String __CREATED = "created";
    public static final String __VALID = "valid";
    public static final String __ID = "id";
    private DBObject _version1;
    private DBCollection _dbSessions;

    public void setDBCollection(DBCollection collection) {
        this._dbSessions = collection;
    }

    @ManagedAttribute(value="DBCollection", readonly=true)
    public DBCollection getDBCollection() {
        return this._dbSessions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SessionData doLoad(String id) throws Exception {
        DBObject sessionDocument = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)id));
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("id={} loaded={}", (Object)id, (Object)sessionDocument);
            }
            if (sessionDocument == null) {
                return null;
            }
            Boolean valid = (Boolean)sessionDocument.get(__VALID);
            if (LOG.isDebugEnabled()) {
                LOG.debug("id={} valid={}", (Object)id, (Object)valid);
            }
            if (valid == null || !valid.booleanValue()) {
                return null;
            }
            Object version = MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(__VERSION));
            Long lastSaved = (Long)MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(__LASTSAVED));
            String lastNode = (String)MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(__LASTNODE));
            byte[] attributes = (byte[])MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(__ATTRIBUTES));
            Long created = (Long)sessionDocument.get(__CREATED);
            Long accessed = (Long)sessionDocument.get(__ACCESSED);
            Long lastAccessed = (Long)sessionDocument.get(__LAST_ACCESSED);
            Long maxInactive = (Long)sessionDocument.get(__MAX_IDLE);
            Long expiry = (Long)sessionDocument.get(__EXPIRY);
            NoSqlSessionDataStore.NoSqlSessionData data = null;
            DBObject sessionSubDocumentForContext = (DBObject)MongoUtils.getNestedValue(sessionDocument, this.getContextField());
            if (LOG.isDebugEnabled()) {
                LOG.debug("attrs {}", (Object)sessionSubDocumentForContext);
            }
            if (sessionSubDocumentForContext != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session {} present for context {}", (Object)id, (Object)this._context);
                }
                data = (NoSqlSessionDataStore.NoSqlSessionData)this.newSessionData(id, created, accessed, lastAccessed == null ? accessed : lastAccessed, maxInactive);
                data.setVersion(version);
                data.setExpiry(expiry);
                data.setContextPath(this._context.getCanonicalContextPath());
                data.setVhost(this._context.getVhost());
                data.setLastSaved(lastSaved);
                data.setLastNode(lastNode);
                if (attributes == null) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String name : sessionSubDocumentForContext.keySet()) {
                        if (__METADATA.equals(name)) continue;
                        String attr = MongoUtils.decodeName(name);
                        Object value = MongoUtils.decodeValue(sessionSubDocumentForContext.get(name));
                        map.put(attr, value);
                    }
                    data.putAllAttributes(map);
                    return data;
                }
                try (ByteArrayInputStream bais = new ByteArrayInputStream(attributes);
                     ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream((InputStream)bais);){
                    SessionData.deserializeAttributes((SessionData)data, (ObjectInputStream)ois);
                    return data;
                }
            }
            if (!LOG.isDebugEnabled()) return data;
            LOG.debug("Session  {} not present for context {}", (Object)id, (Object)this._context);
            return data;
        }
        catch (Exception e) {
            throw new UnreadableSessionDataException(id, this._context, (Throwable)e);
        }
    }

    public boolean delete(String id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Remove:session {} for context {}", (Object)id, (Object)this._context);
        }
        BasicDBObject mongoKey = new BasicDBObject(__ID, (Object)id);
        DBObject sessionDocument = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)id));
        if (sessionDocument != null) {
            DBObject c = (DBObject)MongoUtils.getNestedValue(sessionDocument, __CONTEXT);
            if (c == null) {
                this._dbSessions.remove((DBObject)mongoKey, WriteConcern.SAFE);
                return false;
            }
            Set contexts = c.keySet();
            if (contexts.isEmpty()) {
                this._dbSessions.remove((DBObject)mongoKey, WriteConcern.SAFE);
                return false;
            }
            if (contexts.size() == 1 && ((String)contexts.iterator().next()).equals(this.getCanonicalContextId())) {
                this._dbSessions.remove((DBObject)new BasicDBObject(__ID, (Object)id), WriteConcern.SAFE);
                return true;
            }
            BasicDBObject remove = new BasicDBObject();
            BasicDBObject unsets = new BasicDBObject();
            unsets.put((Object)this.getContextField(), (Object)1);
            remove.put((Object)"$unset", (Object)unsets);
            this._dbSessions.update((DBObject)mongoKey, (DBObject)remove, false, false, WriteConcern.SAFE);
            return true;
        }
        return false;
    }

    public boolean doExists(String id) throws Exception {
        BasicDBObject fields = new BasicDBObject();
        fields.put(__EXPIRY, (Object)1);
        fields.put(__VALID, (Object)1);
        fields.put(this.getContextSubfield(__VERSION), (Object)1);
        DBObject sessionDocument = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)id), (DBObject)fields);
        if (sessionDocument == null) {
            return false;
        }
        Boolean valid = (Boolean)sessionDocument.get(__VALID);
        if (!valid.booleanValue()) {
            return false;
        }
        Long expiry = (Long)sessionDocument.get(__EXPIRY);
        if (expiry > 0L && expiry < System.currentTimeMillis()) {
            return false;
        }
        Object version = MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(__VERSION));
        return version != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> doCheckExpired(Set<String> candidates, long time) {
        HashSet<String> expiredSessions = new HashSet<String>();
        BasicDBObject query = new BasicDBObject();
        query.append(__ID, (Object)new BasicDBObject("$in", candidates));
        query.append(__EXPIRY, (Object)new BasicDBObject("$gt", (Object)0).append("$lte", (Object)time));
        try (DBCursor verifiedExpiredSessions = null;){
            verifiedExpiredSessions = this._dbSessions.find((DBObject)query, (DBObject)new BasicDBObject(__ID, (Object)1));
            for (DBObject session : verifiedExpiredSessions) {
                String id = (String)session.get(__ID);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} Mongo confirmed expired session {}", (Object)this._context, (Object)id);
                }
                expiredSessions.add(id);
            }
        }
        for (String c : candidates) {
            if (expiredSessions.contains(c)) continue;
            try {
                if (this.exists(c)) continue;
                expiredSessions.add(c);
            }
            catch (Exception e) {
                LOG.warn("Problem checking potentially expired session {}", (Object)c, (Object)e);
            }
        }
        return expiredSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> doGetExpired(long timeLimit) {
        HashSet<String> expiredSessions = new HashSet<String>();
        BasicDBObject query = new BasicDBObject();
        BasicDBObject gt = new BasicDBObject(__EXPIRY, (Object)new BasicDBObject("$gt", (Object)0));
        BasicDBObject lt = new BasicDBObject(__EXPIRY, (Object)new BasicDBObject("$lte", (Object)timeLimit));
        BasicDBList list = new BasicDBList();
        list.add((Object)gt);
        list.add((Object)lt);
        query.append("$and", (Object)list);
        try (DBCursor oldExpiredSessions = null;){
            BasicDBObject bo = new BasicDBObject(__ID, (Object)1);
            bo.append(__EXPIRY, (Object)1);
            oldExpiredSessions = this._dbSessions.find((DBObject)query, (DBObject)bo);
            for (DBObject session : oldExpiredSessions) {
                String id = (String)session.get(__ID);
                expiredSessions.add(id);
            }
        }
        return expiredSessions;
    }

    public void doCleanOrphans(long timeLimit) {
        BasicDBObject query = new BasicDBObject();
        query.append(__EXPIRY, (Object)new BasicDBObject("$gt", (Object)0).append("$lte", (Object)timeLimit));
        this._dbSessions.remove((DBObject)query, WriteConcern.SAFE);
    }

    public void initialize(SessionContext context) throws Exception {
        if (this.isStarted()) {
            throw new IllegalStateException("Context set after SessionDataStore started");
        }
        this._context = context;
        this.ensureIndexes();
    }

    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        BasicDBObject key = new BasicDBObject(__ID, (Object)id);
        BasicDBObject update = new BasicDBObject();
        boolean upsert = false;
        BasicDBObject sets = new BasicDBObject();
        Object version = ((NoSqlSessionDataStore.NoSqlSessionData)data).getVersion();
        if (lastSaveTime <= 0L) {
            upsert = true;
            version = 1L;
            sets.put((Object)__CREATED, (Object)data.getCreated());
            sets.put((Object)__VALID, (Object)true);
            sets.put((Object)this.getContextSubfield(__VERSION), version);
            sets.put((Object)this.getContextSubfield(__LASTSAVED), (Object)data.getLastSaved());
            sets.put((Object)this.getContextSubfield(__LASTNODE), (Object)data.getLastNode());
            sets.put((Object)__MAX_IDLE, (Object)data.getMaxInactiveMs());
            sets.put((Object)__EXPIRY, (Object)data.getExpiry());
            ((NoSqlSessionDataStore.NoSqlSessionData)data).setVersion(version);
        } else {
            sets.put((Object)this.getContextSubfield(__LASTSAVED), (Object)data.getLastSaved());
            sets.put((Object)this.getContextSubfield(__LASTNODE), (Object)data.getLastNode());
            version = ((Number)version).longValue() + 1L;
            ((NoSqlSessionDataStore.NoSqlSessionData)data).setVersion(version);
            update.put((Object)"$inc", (Object)this._version1);
            BasicDBObject fields = new BasicDBObject();
            fields.append(__MAX_IDLE, (Object)true);
            fields.append(__EXPIRY, (Object)true);
            DBObject o = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)id), (DBObject)fields);
            if (o != null) {
                long currentExpiry;
                Long tmpLong = (Long)o.get(__MAX_IDLE);
                long currentMaxIdle = tmpLong == null ? 0L : tmpLong;
                tmpLong = (Long)o.get(__EXPIRY);
                long l = currentExpiry = tmpLong == null ? 0L : tmpLong;
                if (currentMaxIdle != data.getMaxInactiveMs()) {
                    sets.put((Object)__MAX_IDLE, (Object)data.getMaxInactiveMs());
                }
                if (currentExpiry != data.getExpiry()) {
                    sets.put((Object)__EXPIRY, (Object)data.getExpiry());
                }
            } else {
                LOG.warn("Session {} not found, can't update", (Object)id);
            }
        }
        sets.put((Object)__ACCESSED, (Object)data.getAccessed());
        sets.put((Object)__LAST_ACCESSED, (Object)data.getLastAccessed());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            SessionData.serializeAttributes((SessionData)data, (ObjectOutputStream)oos);
            sets.put((Object)this.getContextSubfield(__ATTRIBUTES), (Object)baos.toByteArray());
        }
        if (!sets.isEmpty()) {
            update.put((Object)"$set", (Object)sets);
        }
        WriteResult res = this._dbSessions.update((DBObject)key, (DBObject)update, upsert, false, WriteConcern.SAFE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Save:db.sessions.update( {}, {},{} )", new Object[]{key, update, res});
        }
    }

    protected void ensureIndexes() throws MongoException {
        this._version1 = new BasicDBObject(this.getContextSubfield(__VERSION), (Object)1);
        DBObject idKey = BasicDBObjectBuilder.start().add(__ID, (Object)1).get();
        this._dbSessions.createIndex(idKey, BasicDBObjectBuilder.start().add("name", (Object)"id_1").add("ns", (Object)this._dbSessions.getFullName()).add("sparse", (Object)false).add("unique", (Object)true).get());
        DBObject versionKey = BasicDBObjectBuilder.start().add(__ID, (Object)1).add("version", (Object)1).get();
        this._dbSessions.createIndex(versionKey, BasicDBObjectBuilder.start().add("name", (Object)"id_1_version_1").add("ns", (Object)this._dbSessions.getFullName()).add("sparse", (Object)false).add("unique", (Object)true).get());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done ensure Mongodb indexes existing");
        }
    }

    private String getContextField() {
        return "context." + this.getCanonicalContextId();
    }

    private String getCanonicalContextId() {
        return this.canonicalizeVHost(this._context.getVhost()) + ":" + this._context.getCanonicalContextPath();
    }

    private String canonicalizeVHost(String vhost) {
        if (vhost == null) {
            return "";
        }
        return StringUtil.replace((String)vhost, (char)'.', (char)'_');
    }

    private String getContextSubfield(String attr) {
        return this.getContextField() + "." + attr;
    }

    @ManagedAttribute(value="does store serialize sessions", readonly=true)
    public boolean isPassivating() {
        return true;
    }

    public String toString() {
        return String.format("%s[collection=%s]", super.toString(), this.getDBCollection());
    }
}

