/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.nested.resource;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.eclipse.jetty.ee9.nested.resource.ByteBufferRangeWriter;
import org.eclipse.jetty.ee9.nested.resource.RangeWriter;
import org.eclipse.jetty.ee9.nested.resource.SeekableByteChannelRangeWriter;
import org.eclipse.jetty.http.content.HttpContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpContentRangeWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HttpContentRangeWriter.class);

    public static RangeWriter newRangeWriter(HttpContent content) throws IOException {
        Objects.requireNonNull(content, "HttpContent");
        ByteBuffer buffer = content.getByteBuffer();
        if (buffer != null) {
            return new ByteBufferRangeWriter(buffer);
        }
        return new SeekableByteChannelRangeWriter(() -> Files.newByteChannel(content.getResource().getPath(), new OpenOption[0]));
    }
}

