/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.annotations;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebInitParam;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.EnumSet;
import org.eclipse.jetty.ee9.servlet.FilterHolder;
import org.eclipse.jetty.ee9.servlet.FilterMapping;
import org.eclipse.jetty.ee9.servlet.Source;
import org.eclipse.jetty.ee9.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.ee9.webapp.MetaData;
import org.eclipse.jetty.ee9.webapp.Origin;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFilterAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = LoggerFactory.getLogger(WebFilterAnnotation.class);

    public WebFilterAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public WebFilterAnnotation(WebAppContext context, String className, Resource resource) {
        super(context, className, resource);
    }

    public void apply() {
        FilterHolder holder;
        Class clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn("{} cannot be loaded", (Object)this._className);
            return;
        }
        if (!Filter.class.isAssignableFrom(clazz)) {
            LOG.warn("{} is not assignable from jakarta.servlet.Filter", (Object)clazz.getName());
            return;
        }
        MetaData metaData = this._context.getMetaData();
        WebFilter filterAnnotation = clazz.getAnnotation(WebFilter.class);
        if (filterAnnotation.value().length > 0 && filterAnnotation.urlPatterns().length > 0) {
            LOG.warn("{} defines both @WebFilter.value and @WebFilter.urlPatterns", (Object)clazz.getName());
            return;
        }
        String name = filterAnnotation.filterName().equals("") ? clazz.getName() : filterAnnotation.filterName();
        String[] urlPatterns = filterAnnotation.value();
        if (urlPatterns.length == 0) {
            urlPatterns = filterAnnotation.urlPatterns();
        }
        if ((holder = this._context.getServletHandler().getFilter(name)) == null) {
            String s;
            int n;
            holder = this._context.getServletHandler().newFilterHolder(new Source(Source.Origin.ANNOTATION, clazz));
            holder.setName(name);
            holder.setHeldClass(clazz);
            metaData.setOrigin(name + ".filter.filter-class", (Annotation)filterAnnotation, clazz);
            holder.setDisplayName(filterAnnotation.displayName());
            metaData.setOrigin(name + ".filter.display-name", (Annotation)filterAnnotation, clazz);
            for (WebInitParam ip : filterAnnotation.initParams()) {
                holder.setInitParameter(ip.name(), ip.value());
                metaData.setOrigin(name + ".filter.init-param." + ip.name(), (Annotation)ip, clazz);
            }
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            metaData.setOrigin(name + ".filter.mapping." + Long.toHexString(mapping.hashCode()), (Annotation)filterAnnotation, clazz);
            if (urlPatterns.length > 0) {
                ArrayList<String> paths = new ArrayList<String>();
                String[] stringArray = urlPatterns;
                int ip = stringArray.length;
                for (n = 0; n < ip; ++n) {
                    s = stringArray[n];
                    paths.add(ServletPathSpec.normalize((String)s));
                }
                mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
            }
            if (filterAnnotation.servletNames().length > 0) {
                ArrayList<String> names = new ArrayList<String>();
                String[] stringArray = filterAnnotation.servletNames();
                int ip = stringArray.length;
                for (n = 0; n < ip; ++n) {
                    s = stringArray[n];
                    names.add(s);
                }
                mapping.setServletNames(names.toArray(new String[names.size()]));
            }
            EnumSet<DispatcherType> dispatcherSet = EnumSet.noneOf(DispatcherType.class);
            for (DispatcherType d : filterAnnotation.dispatcherTypes()) {
                dispatcherSet.add(d);
            }
            mapping.setDispatcherTypes(dispatcherSet);
            metaData.setOrigin(name + ".filter.mappings", (Annotation)filterAnnotation, clazz);
            holder.setAsyncSupported(filterAnnotation.asyncSupported());
            metaData.setOrigin(name + ".filter.async-supported", (Annotation)filterAnnotation, clazz);
            this._context.getServletHandler().addFilter(holder);
            this._context.getServletHandler().addFilterMapping(mapping);
        } else {
            for (WebInitParam ip : filterAnnotation.initParams()) {
                if (metaData.getOrigin(name + ".filter.init-param." + ip.name()) != Origin.NotSet) continue;
                holder.setInitParameter(ip.name(), ip.value());
                metaData.setOrigin(name + ".filter.init-param." + ip.name(), (Annotation)ip, clazz);
            }
            FilterMapping[] mappings = this._context.getServletHandler().getFilterMappings();
            boolean mappingExists = false;
            if (mappings != null) {
                for (FilterMapping m : mappings) {
                    if (!m.getFilterName().equals(name)) continue;
                    mappingExists = true;
                    break;
                }
            }
            if (!mappingExists) {
                String s;
                int n;
                FilterMapping mapping = new FilterMapping();
                mapping.setFilterName(holder.getName());
                metaData.setOrigin(holder.getName() + ".filter.mapping." + Long.toHexString(mapping.hashCode()), (Annotation)filterAnnotation, clazz);
                if (urlPatterns.length > 0) {
                    ArrayList<String> paths = new ArrayList<String>();
                    String[] stringArray = urlPatterns;
                    int n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        s = stringArray[n];
                        paths.add(ServletPathSpec.normalize((String)s));
                    }
                    mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
                }
                if (filterAnnotation.servletNames().length > 0) {
                    ArrayList<String> names = new ArrayList<String>();
                    String[] stringArray = filterAnnotation.servletNames();
                    int n3 = stringArray.length;
                    for (n = 0; n < n3; ++n) {
                        s = stringArray[n];
                        names.add(s);
                    }
                    mapping.setServletNames(names.toArray(new String[names.size()]));
                }
                EnumSet<DispatcherType> dispatcherSet = EnumSet.noneOf(DispatcherType.class);
                for (DispatcherType d : filterAnnotation.dispatcherTypes()) {
                    dispatcherSet.add(d);
                }
                mapping.setDispatcherTypes(dispatcherSet);
                this._context.getServletHandler().addFilterMapping(mapping);
                metaData.setOrigin(name + ".filter.mappings", (Annotation)filterAnnotation, clazz);
            }
        }
    }
}

