/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.annotations;

import jakarta.servlet.annotation.WebInitParam;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.ee9.servlet.ServletHolder;
import org.eclipse.jetty.ee9.servlet.ServletMapping;
import org.eclipse.jetty.ee9.servlet.Source;
import org.eclipse.jetty.ee9.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.ee9.webapp.MetaData;
import org.eclipse.jetty.ee9.webapp.Origin;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServletAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = LoggerFactory.getLogger(WebServletAnnotation.class);

    public WebServletAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public WebServletAnnotation(WebAppContext context, String className, Resource resource) {
        super(context, className, resource);
    }

    public void apply() {
        Class clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn("{} cannot be loaded", (Object)this._className);
            return;
        }
        if (!HttpServlet.class.isAssignableFrom(clazz)) {
            LOG.warn("{} is not assignable from jakarta.servlet.http.HttpServlet", (Object)clazz.getName());
            return;
        }
        WebServlet annotation = clazz.getAnnotation(WebServlet.class);
        if (annotation.urlPatterns().length > 0 && annotation.value().length > 0) {
            LOG.warn("{} defines both @WebServlet.value and @WebServlet.urlPatterns", (Object)clazz.getName());
            return;
        }
        String[] urlPatterns = annotation.value();
        if (urlPatterns.length == 0) {
            urlPatterns = annotation.urlPatterns();
        }
        if (urlPatterns.length == 0) {
            LOG.warn("{} defines neither @WebServlet.value nor @WebServlet.urlPatterns", (Object)clazz.getName());
            return;
        }
        ArrayList<String> urlPatternList = new ArrayList<String>();
        for (String p : urlPatterns) {
            urlPatternList.add(ServletPathSpec.normalize((String)p));
        }
        String servletName = annotation.name().equals("") ? clazz.getName() : annotation.name();
        MetaData metaData = this._context.getMetaData();
        ServletMapping mapping = null;
        ServletHolder[] holders = this._context.getServletHandler().getServlets();
        ServletHolder holder = null;
        if (holders != null) {
            for (ServletHolder h : holders) {
                if (h.getName() == null || !servletName.equals(h.getName())) continue;
                holder = h;
                break;
            }
        }
        if (holder == null) {
            WebInitParam[] source = new Source(Source.Origin.ANNOTATION, clazz);
            holder = this._context.getServletHandler().newServletHolder((Source)source);
            holder.setHeldClass(clazz);
            metaData.setOrigin(servletName + ".servlet.servlet-class", (Annotation)annotation, clazz);
            holder.setName(servletName);
            holder.setDisplayName(annotation.displayName());
            metaData.setOrigin(servletName + ".servlet.display-name", (Annotation)annotation, clazz);
            holder.setInitOrder(annotation.loadOnStartup());
            metaData.setOrigin(servletName + ".servlet.load-on-startup", (Annotation)annotation, clazz);
            holder.setAsyncSupported(annotation.asyncSupported());
            metaData.setOrigin(servletName + ".servlet.async-supported", (Annotation)annotation, clazz);
            for (WebInitParam ip : annotation.initParams()) {
                holder.setInitParameter(ip.name(), ip.value());
                metaData.setOrigin(servletName + ".servlet.init-param." + ip.name(), (Annotation)ip, clazz);
            }
            this._context.getServletHandler().addServlet(holder);
            mapping = new ServletMapping((Source)source);
            mapping.setServletName(holder.getName());
            mapping.setPathSpecs(LazyList.toStringArray(urlPatternList));
            this._context.getMetaData().setOrigin(servletName + ".servlet.mapping." + Long.toHexString(mapping.hashCode()), (Annotation)annotation, clazz);
        } else {
            if (holder.getClassName() == null) {
                holder.setClassName(clazz.getName());
            }
            if (holder.getHeldClass() == null) {
                holder.setHeldClass(clazz);
            }
            for (WebInitParam ip : annotation.initParams()) {
                if (metaData.getOrigin(servletName + ".servlet.init-param." + ip.name()) != Origin.NotSet) continue;
                holder.setInitParameter(ip.name(), ip.value());
                metaData.setOrigin(servletName + ".servlet.init-param." + ip.name(), (Annotation)ip, clazz);
            }
            List<ServletMapping> existingMappings = this.getServletMappingsForServlet(servletName);
            if (existingMappings.isEmpty() || !this.containsNonDefaultMappings(existingMappings)) {
                mapping = new ServletMapping(new Source(Source.Origin.ANNOTATION, clazz));
                mapping.setServletName(servletName);
                mapping.setPathSpecs(LazyList.toStringArray(urlPatternList));
                this._context.getMetaData().setOrigin(servletName + ".servlet.mapping." + Long.toHexString(mapping.hashCode()), (Annotation)annotation, clazz);
            }
        }
        if (mapping != null) {
            List allMappings = ArrayUtil.asMutableList((Object[])this._context.getServletHandler().getServletMappings());
            for (String p : urlPatternList) {
                ServletMapping existingMapping = this._context.getServletHandler().getServletMapping(p);
                if (existingMapping != null && existingMapping.isFromDefaultDescriptor()) {
                    String[] updatedPaths = (String[])ArrayUtil.removeFromArray((Object[])existingMapping.getPathSpecs(), (Object)p);
                    if (updatedPaths == null || updatedPaths.length == 0) {
                        boolean success = allMappings.remove(existingMapping);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Removed empty mapping {} from defaults descriptor success:{}", (Object)existingMapping, (Object)success);
                        }
                    } else {
                        existingMapping.setPathSpecs(updatedPaths);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Removed path {} from mapping {} from defaults descriptor ", (Object)p, (Object)existingMapping);
                        }
                    }
                }
                this._context.getMetaData().setOrigin(servletName + ".servlet.mapping.url" + p, (Annotation)annotation, clazz);
            }
            allMappings.add(mapping);
            this._context.getServletHandler().setServletMappings(allMappings.toArray(new ServletMapping[allMappings.size()]));
        }
    }

    private List<ServletMapping> getServletMappingsForServlet(String name) {
        ServletMapping[] allMappings = this._context.getServletHandler().getServletMappings();
        if (allMappings == null) {
            return Collections.emptyList();
        }
        ArrayList<ServletMapping> mappings = new ArrayList<ServletMapping>();
        for (ServletMapping m : allMappings) {
            if (m.getServletName() == null || !name.equals(m.getServletName())) continue;
            mappings.add(m);
        }
        return mappings;
    }

    private boolean containsNonDefaultMappings(List<ServletMapping> mappings) {
        if (mappings == null) {
            return false;
        }
        for (ServletMapping m : mappings) {
            if (m.isFromDefaultDescriptor()) continue;
            return true;
        }
        return false;
    }
}

