/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server;

import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;

public class WebSocketUpgradeHandler
extends Handler.Wrapper {
    private final WebSocketMappings mappings;
    private final Configuration.ConfigurationCustomizer customizer = new Configuration.ConfigurationCustomizer();

    public WebSocketUpgradeHandler() {
        this(new WebSocketComponents());
    }

    public WebSocketUpgradeHandler(WebSocketComponents components) {
        this.mappings = new WebSocketMappings(components);
        this.setHandler((Handler)new Handler.Abstract.NonBlocking(){

            public boolean handle(Request request, Response response, Callback callback) {
                Response.writeError((Request)request, (Response)response, (Callback)callback, (int)404);
                return true;
            }
        });
    }

    public void addMapping(String pathSpec, WebSocketNegotiator negotiator) {
        this.mappings.addMapping((PathSpec)new ServletPathSpec(pathSpec), negotiator);
    }

    public void addMapping(PathSpec pathSpec, WebSocketNegotiator negotiator) {
        this.mappings.addMapping(pathSpec, negotiator);
    }

    public Configuration getConfiguration() {
        return this.customizer;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String target = Request.getPathInContext((Request)request);
        WebSocketNegotiator negotiator = this.mappings.getMatchedNegotiator(target, pathSpec -> request.setAttribute(PathSpec.class.getName(), pathSpec));
        if (negotiator == null) {
            return super.handle(request, response, callback);
        }
        try {
            if (this.mappings.upgrade(negotiator, request, response, callback, (Configuration.Customizer)this.customizer)) {
                return true;
            }
            return super.handle(request, response, callback);
        }
        catch (Throwable t) {
            callback.failed(t);
            return true;
        }
    }
}

