/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.transport.internal;

import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpReceiver;
import org.eclipse.jetty.client.transport.HttpSender;
import org.eclipse.jetty.fcgi.client.transport.internal.HttpConnectionOverFCGI;
import org.eclipse.jetty.fcgi.client.transport.internal.HttpReceiverOverFCGI;
import org.eclipse.jetty.fcgi.client.transport.internal.HttpSenderOverFCGI;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.IdleTimeout;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelOverFCGI
extends HttpChannel {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannelOverFCGI.class);
    private final HttpConnectionOverFCGI connection;
    private final Flusher flusher;
    private final HttpSenderOverFCGI sender;
    private final HttpReceiverOverFCGI receiver;
    private final FCGIIdleTimeout idle;
    private int request;
    private HttpVersion version;

    public HttpChannelOverFCGI(HttpConnectionOverFCGI connection, Flusher flusher, long idleTimeout) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.flusher = flusher;
        this.sender = new HttpSenderOverFCGI(this);
        this.receiver = new HttpReceiverOverFCGI(this);
        this.idle = new FCGIIdleTimeout(connection, idleTimeout);
    }

    public HttpConnectionOverFCGI getHttpConnection() {
        return this.connection;
    }

    protected int getRequest() {
        return this.request;
    }

    void setRequest(int request) {
        this.request = request;
    }

    protected HttpSender getHttpSender() {
        return this.sender;
    }

    protected HttpReceiver getHttpReceiver() {
        return this.receiver;
    }

    public boolean isFailed() {
        return this.sender.isFailed() || this.receiver.isFailed();
    }

    public void send(HttpExchange exchange) {
        this.version = exchange.getRequest().getVersion();
        this.idle.onOpen();
        this.sender.send(exchange);
    }

    public void release() {
        this.connection.release(this);
    }

    protected void responseBegin(int code, String reason) {
        this.idle.notIdle();
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        exchange.getResponse().version(this.version).status(code).reason(reason);
        this.receiver.responseBegin(exchange);
    }

    protected void responseHeader(HttpField field) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.receiver.responseHeader(exchange, field);
        }
    }

    protected void responseHeaders() {
        this.idle.notIdle();
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.receiver.responseHeaders(exchange);
        }
    }

    protected void content(Content.Chunk chunk) {
        this.idle.notIdle();
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.receiver.content(chunk);
        }
    }

    protected void end() {
        this.idle.notIdle();
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.receiver.end(exchange);
        }
    }

    protected void responseFailure(Throwable failure, Promise<Boolean> promise) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.receiver.responseFailure(failure, promise);
        } else {
            promise.succeeded((Object)false);
        }
    }

    public void exchangeTerminated(HttpExchange exchange, Result result) {
        super.exchangeTerminated(exchange, result);
        this.idle.onClose();
        HttpFields responseHeaders = result.getResponse().getHeaders();
        if (result.isFailed()) {
            this.connection.close(result.getFailure());
        } else if (!this.connection.closeByHTTP(responseHeaders)) {
            this.release();
        }
    }

    protected void flush(ByteBufferPool.Accumulator accumulator, Callback callback) {
        this.flusher.flush(accumulator, callback);
    }

    void receive() {
        this.receiver.receive();
    }

    private class FCGIIdleTimeout
    extends IdleTimeout {
        private final HttpConnectionOverFCGI connection;
        private boolean open;

        public FCGIIdleTimeout(HttpConnectionOverFCGI connection, long idleTimeout) {
            super(connection.getHttpDestination().getHttpClient().getScheduler());
            this.connection = connection;
            this.setIdleTimeout(idleTimeout >= 0L ? idleTimeout : connection.getEndPoint().getIdleTimeout());
        }

        public void onOpen() {
            this.open = true;
            this.notIdle();
            super.onOpen();
        }

        public void onClose() {
            super.onClose();
            this.open = false;
        }

        protected void onIdleExpired(TimeoutException timeout) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Idle timeout for request {}", (Object)HttpChannelOverFCGI.this.request);
            }
            this.connection.abort(timeout);
        }

        public boolean isOpen() {
            return this.open;
        }
    }
}

