/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.transport.internal;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpConnection;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.IConnection;
import org.eclipse.jetty.client.transport.SendFailure;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.client.transport.internal.HttpChannelOverFCGI;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.fcgi.parser.ClientParser;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionOverFCGI
extends AbstractConnection
implements IConnection,
Attachable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConnectionOverFCGI.class);
    private final ByteBufferPool networkByteBufferPool;
    private final AutoLock lock = new AutoLock();
    private final LinkedList<Integer> requests = new LinkedList();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final HttpDestination destination;
    private final Promise<Connection> promise;
    private final Flusher flusher;
    private final Delegate delegate;
    private final ClientParser parser;
    private HttpChannelOverFCGI channel;
    private RetainableByteBuffer networkBuffer;
    private Object attachment;
    private Runnable action;

    public HttpConnectionOverFCGI(EndPoint endPoint, Destination destination, Promise<Connection> promise) {
        super(endPoint, destination.getHttpClient().getExecutor());
        this.destination = (HttpDestination)destination;
        this.promise = promise;
        this.flusher = new Flusher(endPoint);
        this.delegate = new Delegate(destination);
        this.parser = new ClientParser(new ResponseListener());
        this.requests.addLast(0);
        HttpClient client = destination.getHttpClient();
        this.networkByteBufferPool = client.getByteBufferPool();
    }

    public HttpDestination getHttpDestination() {
        return this.destination;
    }

    protected Flusher getFlusher() {
        return this.flusher;
    }

    public void send(Request request, Response.CompleteListener listener) {
        this.delegate.send(request, listener);
    }

    public SendFailure send(HttpExchange exchange) {
        return this.delegate.send(exchange);
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
        this.promise.succeeded((Object)this);
    }

    public void onFillable() {
        this.channel.receive();
    }

    private void reacquireNetworkBuffer() {
        if (this.networkBuffer == null) {
            throw new IllegalStateException();
        }
        if (this.networkBuffer.hasRemaining()) {
            throw new IllegalStateException();
        }
        this.networkBuffer.release();
        this.networkBuffer = this.newNetworkBuffer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reacquired {}", (Object)this.networkBuffer);
        }
    }

    private RetainableByteBuffer newNetworkBuffer() {
        HttpClient client = this.destination.getHttpClient();
        return this.networkByteBufferPool.acquire(client.getResponseBufferSize(), client.isUseInputDirectByteBuffers());
    }

    private void releaseNetworkBuffer() {
        if (this.networkBuffer == null) {
            throw new IllegalStateException();
        }
        if (this.networkBuffer.hasRemaining()) {
            throw new IllegalStateException();
        }
        this.networkBuffer.release();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", (Object)this.networkBuffer);
        }
        this.networkBuffer = null;
    }

    boolean parseAndFill() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("parseAndFill {}", (Object)this.networkBuffer);
        }
        if (this.networkBuffer == null) {
            this.networkBuffer = this.newNetworkBuffer();
        }
        EndPoint endPoint = this.getEndPoint();
        try {
            int read;
            do {
                if (this.parse(this.networkBuffer.getByteBuffer())) {
                    return false;
                }
                if (this.networkBuffer.isRetained()) {
                    this.reacquireNetworkBuffer();
                }
                read = endPoint.fill(this.networkBuffer.getByteBuffer());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {} bytes from {}", (Object)read, (Object)endPoint);
                }
                if (read != 0) continue;
                this.releaseNetworkBuffer();
                return true;
            } while (read >= 0);
            this.releaseNetworkBuffer();
            this.shutdown();
            return false;
        }
        catch (Exception x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to fill from endpoint {}", (Object)endPoint, (Object)x);
            }
            this.networkBuffer.clear();
            this.releaseNetworkBuffer();
            this.close(x);
            return false;
        }
    }

    private boolean parse(ByteBuffer buffer) {
        boolean parse = this.parser.parse(buffer);
        Runnable action = this.getAndSetAction(null);
        if (action != null) {
            action.run();
        }
        return parse;
    }

    private void shutdown() {
        HttpChannelOverFCGI channel = this.channel;
        if (channel == null || channel.getRequest() == 0) {
            this.close();
        } else {
            this.failAndClose(new EOFException(String.valueOf(this.getEndPoint())));
        }
    }

    public boolean onIdleExpired(TimeoutException timeoutException) {
        long idleTimeout = this.getEndPoint().getIdleTimeout();
        boolean close = this.delegate.onIdleTimeout(idleTimeout, timeoutException);
        if (close) {
            this.close(timeoutException);
        }
        return false;
    }

    protected void release(HttpChannelOverFCGI channel) {
        HttpChannelOverFCGI existing = this.channel;
        if (existing == channel) {
            channel.setRequest(0);
            if (channel.isFailed()) {
                channel.destroy();
                this.channel = null;
            }
            this.destination.release((Connection)this);
        } else if (existing == null) {
            channel.destroy();
        } else {
            throw new UnsupportedOperationException("FastCGI Multiplex");
        }
    }

    public void close() {
        this.close(new AsynchronousCloseException());
    }

    protected void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().remove((Connection)this);
            this.abort(failure);
            this.getEndPoint().shutdownOutput();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown {}", (Object)this);
            }
            this.getEndPoint().close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closed {}", (Object)this);
            }
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void setAttachment(Object obj) {
        this.attachment = obj;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    protected boolean closeByHTTP(HttpFields fields) {
        if (!fields.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) {
            return false;
        }
        this.close();
        return true;
    }

    protected void abort(Throwable failure) {
        HttpChannelOverFCGI channel = this.channel;
        if (channel != null) {
            HttpExchange exchange = channel.getHttpExchange();
            if (exchange != null) {
                exchange.getRequest().abort(failure);
            }
            channel.destroy();
            this.channel = null;
        }
    }

    private void failAndClose(Throwable failure) {
        HttpChannelOverFCGI channel = this.channel;
        if (channel != null) {
            channel.responseFailure(failure, (Promise<Boolean>)Promise.from(failed -> {
                channel.destroy();
                if (failed.booleanValue()) {
                    this.close(failure);
                }
            }, x -> {
                channel.destroy();
                this.close(failure);
            }));
        }
    }

    private int acquireRequest() {
        try (AutoLock ignored = this.lock.lock();){
            int last = this.requests.getLast();
            int request = last + 1;
            this.requests.addLast(request);
            int n = request;
            return n;
        }
    }

    private void releaseRequest(int request) {
        try (AutoLock ignored = this.lock.lock();){
            this.requests.removeFirstOccurrence(request);
        }
    }

    private Runnable getAndSetAction(Runnable action) {
        Runnable r = this.action;
        this.action = action;
        return r;
    }

    protected HttpChannelOverFCGI acquireHttpChannel(int id, Request request) {
        if (this.channel == null) {
            this.channel = this.newHttpChannel(request);
        }
        this.channel.setRequest(id);
        return this.channel;
    }

    protected HttpChannelOverFCGI newHttpChannel(Request request) {
        return new HttpChannelOverFCGI(this, this.getFlusher(), request.getIdleTimeout());
    }

    public String toConnectionString() {
        return String.format("%s@%x[l:%s<->r:%s]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.getEndPoint().getLocalSocketAddress(), this.getEndPoint().getRemoteSocketAddress());
    }

    private class Delegate
    extends HttpConnection {
        private Delegate(Destination destination) {
            super((HttpDestination)destination);
        }

        protected Iterator<HttpChannel> getHttpChannels() {
            HttpChannelOverFCGI channel = HttpConnectionOverFCGI.this.channel;
            return channel == null ? Collections.emptyIterator() : Collections.singleton(channel).iterator();
        }

        public SendFailure send(HttpExchange exchange) {
            HttpRequest request = exchange.getRequest();
            this.normalizeRequest(request);
            int id = HttpConnectionOverFCGI.this.acquireRequest();
            HttpChannelOverFCGI channel = HttpConnectionOverFCGI.this.acquireHttpChannel(id, (Request)request);
            return this.send(channel, exchange);
        }

        public void close() {
            HttpConnectionOverFCGI.this.close();
            this.destroy();
        }

        public boolean isClosed() {
            return HttpConnectionOverFCGI.this.isClosed();
        }

        public String toString() {
            return HttpConnectionOverFCGI.this.toString();
        }
    }

    private class ResponseListener
    implements ClientParser.Listener {
        private ResponseListener() {
        }

        @Override
        public void onBegin(int request, int code, String reason) {
            HttpChannelOverFCGI channel;
            if (LOG.isDebugEnabled()) {
                LOG.debug("onBegin r={},c={},reason={}", new Object[]{request, code, reason});
            }
            if ((channel = HttpConnectionOverFCGI.this.channel) != null) {
                channel.responseBegin(code, reason);
            } else {
                this.noChannel(request);
            }
        }

        @Override
        public void onHeader(int request, HttpField field) {
            HttpChannelOverFCGI channel;
            if (LOG.isDebugEnabled()) {
                LOG.debug("onHeader r={},f={}", (Object)request, (Object)field);
            }
            if ((channel = HttpConnectionOverFCGI.this.channel) != null) {
                channel.responseHeader(field);
            } else {
                this.noChannel(request);
            }
        }

        @Override
        public boolean onHeaders(int request) {
            HttpChannelOverFCGI channel;
            if (LOG.isDebugEnabled()) {
                LOG.debug("onHeaders r={} {}", (Object)request, (Object)HttpConnectionOverFCGI.this.networkBuffer);
            }
            if ((channel = HttpConnectionOverFCGI.this.channel) != null) {
                if (HttpConnectionOverFCGI.this.getAndSetAction(channel::responseHeaders) != null) {
                    throw new IllegalStateException();
                }
                return true;
            }
            this.noChannel(request);
            return false;
        }

        @Override
        public boolean onContent(int request, FCGI.StreamType stream, ByteBuffer buffer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onContent r={},t={},b={} {}", new Object[]{request, stream, BufferUtil.toDetailString((ByteBuffer)buffer), HttpConnectionOverFCGI.this.networkBuffer});
            }
            switch (stream) {
                case STD_OUT: {
                    HttpChannelOverFCGI channel = HttpConnectionOverFCGI.this.channel;
                    if (channel != null) {
                        Content.Chunk chunk = Content.Chunk.asChunk((ByteBuffer)buffer, (boolean)false, (Retainable)HttpConnectionOverFCGI.this.networkBuffer);
                        if (HttpConnectionOverFCGI.this.getAndSetAction(() -> channel.content(chunk)) == null) {
                            return true;
                        }
                        throw new IllegalStateException();
                    }
                    this.noChannel(request);
                    break;
                }
                case STD_ERR: {
                    LOG.info(BufferUtil.toUTF8String((ByteBuffer)buffer));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return false;
        }

        @Override
        public void onEnd(int request) {
            HttpChannelOverFCGI channel;
            if (LOG.isDebugEnabled()) {
                LOG.debug("onEnd r={}", (Object)request);
            }
            if ((channel = HttpConnectionOverFCGI.this.channel) != null) {
                HttpConnectionOverFCGI.this.releaseRequest(request);
                channel.end();
            } else {
                this.noChannel(request);
            }
        }

        @Override
        public void onFailure(int request, Throwable failure) {
            HttpChannelOverFCGI channel;
            if (LOG.isDebugEnabled()) {
                LOG.debug("onFailure request={}", (Object)request, (Object)failure);
            }
            if ((channel = HttpConnectionOverFCGI.this.channel) != null) {
                channel.responseFailure(failure, (Promise<Boolean>)Promise.from(failed -> {
                    if (failed.booleanValue()) {
                        HttpConnectionOverFCGI.this.releaseRequest(request);
                    }
                }, x -> HttpConnectionOverFCGI.this.releaseRequest(request)));
            } else {
                this.noChannel(request);
            }
        }

        private void noChannel(int request) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Channel not found for request {}", (Object)request);
            }
        }
    }
}

