/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.parser.ContentParser;
import org.eclipse.jetty.fcgi.parser.HeaderParser;
import org.eclipse.jetty.http.HttpField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Parser {
    private static final Logger LOG = LoggerFactory.getLogger(Parser.class);
    protected final HeaderParser headerParser = new HeaderParser();
    private final Listener listener;
    private State state = State.HEADER;
    private int padding;

    protected Parser(Listener listener) {
        this.listener = listener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parse(ByteBuffer buffer) {
        try {
            block7: while (true) {
                switch (this.state) {
                    case HEADER: {
                        if (!this.headerParser.parse(buffer)) {
                            return false;
                        }
                        this.state = State.CONTENT;
                        continue block7;
                    }
                    case CONTENT: {
                        ContentParser contentParser = this.findContentParser(this.headerParser.getFrameType());
                        if (this.headerParser.getContentLength() == 0) {
                            this.padding = this.headerParser.getPaddingLength();
                            this.state = State.PADDING;
                            if (!contentParser.noContent()) continue block7;
                            return true;
                        }
                        ContentParser.Result result = contentParser.parse(buffer);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Parsed request {} content {} result={}", new Object[]{this.headerParser.getRequest(), this.headerParser.getFrameType(), result});
                        }
                        if (result == ContentParser.Result.PENDING) {
                            return false;
                        }
                        if (result == ContentParser.Result.ASYNC) {
                            return true;
                        }
                        this.padding = this.headerParser.getPaddingLength();
                        this.state = State.PADDING;
                        continue block7;
                    }
                    case PADDING: {
                        if (buffer.remaining() < this.padding) {
                            this.padding -= buffer.remaining();
                            buffer.position(buffer.limit());
                            return false;
                        }
                        buffer.position(buffer.position() + this.padding);
                        this.reset();
                        continue block7;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (Throwable x) {
            buffer.position(buffer.limit());
            this.listener.onFailure(this.headerParser.getRequest(), x);
            return true;
        }
    }

    protected abstract ContentParser findContentParser(FCGI.FrameType var1);

    private void reset() {
        this.headerParser.reset();
        this.state = State.HEADER;
        this.padding = 0;
    }

    private static enum State {
        HEADER,
        CONTENT,
        PADDING;

    }

    public static interface Listener {
        default public void onHeader(int request, HttpField field) {
        }

        default public boolean onHeaders(int request) {
            return false;
        }

        default public boolean onContent(int request, FCGI.StreamType stream, ByteBuffer buffer) {
            return false;
        }

        default public void onEnd(int request) {
        }

        default public void onFailure(int request, Throwable failure) {
        }
    }
}

