/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.quickstart;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.ee9.annotations.AnnotationConfiguration;
import org.eclipse.jetty.ee9.annotations.AnnotationDecorator;
import org.eclipse.jetty.ee9.quickstart.QuickStartDescriptorProcessor;
import org.eclipse.jetty.ee9.quickstart.QuickStartGeneratorConfiguration;
import org.eclipse.jetty.ee9.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee9.webapp.Configuration;
import org.eclipse.jetty.ee9.webapp.DescriptorProcessor;
import org.eclipse.jetty.ee9.webapp.FragmentConfiguration;
import org.eclipse.jetty.ee9.webapp.MetaInfConfiguration;
import org.eclipse.jetty.ee9.webapp.StandardDescriptorProcessor;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.ee9.webapp.WebDescriptor;
import org.eclipse.jetty.ee9.webapp.WebInfConfiguration;
import org.eclipse.jetty.ee9.webapp.WebXmlConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickStartConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(QuickStartConfiguration.class);
    public static final Set<Class<? extends Configuration>> __replacedConfigurations = new HashSet<Class<? extends Configuration>>();
    public static final String ORIGIN_ATTRIBUTE = "org.eclipse.jetty.quickstart.origin";
    public static final String QUICKSTART_WEB_XML = "org.eclipse.jetty.quickstart.xml";
    public static final String MODE = "org.eclipse.jetty.quickstart.mode";
    private ResourceFactory.Closeable _resourceFactory;
    private Mode _mode = Mode.AUTO;
    private boolean _quickStart;
    private QuickStartDescriptorProcessor _quickStartDescriptorProcessor;

    public static void configureMode(Server server, String mode) {
        if (mode != null && Mode.valueOf(mode) == Mode.GENERATE) {
            server.setDryRun(true);
        }
    }

    public QuickStartConfiguration() {
        super(true);
        this.addDependencies(new Class[]{WebInfConfiguration.class});
        this.addDependents(new Class[]{WebXmlConfiguration.class});
    }

    public void preConfigure(WebAppContext context) throws Exception {
        Mode mode;
        Object o;
        this._resourceFactory = ResourceFactory.closeable();
        String war = context.getWar();
        if (war == null || war.length() <= 0 || !context.getBaseResource().isDirectory()) {
            throw new IllegalStateException("Bad Quickstart location");
        }
        Path quickStartWebXml = QuickStartConfiguration.getQuickStartWebXml(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("quickStartWebXml={} exists={}", (Object)quickStartWebXml, (Object)Files.exists(quickStartWebXml, new LinkOption[0]));
        }
        if ((o = context.getAttribute(MODE)) instanceof Mode) {
            Mode m;
            mode = m = (Mode)((Object)o);
        } else if (o instanceof String) {
            String s = (String)o;
            mode = Mode.valueOf(s);
        } else {
            mode = this._mode;
        }
        this._mode = mode;
        this._quickStart = false;
        switch (this._mode) {
            case GENERATE: {
                if (Files.exists(quickStartWebXml, new LinkOption[0])) {
                    LOG.info("Regenerating {}", (Object)quickStartWebXml);
                } else {
                    LOG.info("Generating {}", (Object)quickStartWebXml);
                }
                super.preConfigure(context);
                QuickStartGeneratorConfiguration generator = new QuickStartGeneratorConfiguration(true);
                this.configure(generator, context);
                context.addConfiguration(new Configuration[]{generator});
                break;
            }
            case AUTO: {
                if (Files.exists(quickStartWebXml, new LinkOption[0])) {
                    this.quickStart(context);
                    break;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No quickstart xml file, starting webapp {} normally", (Object)context);
                }
                super.preConfigure(context);
                break;
            }
            case QUICKSTART: {
                if (Files.exists(quickStartWebXml, new LinkOption[0])) {
                    this.quickStart(context);
                    break;
                }
                throw new IllegalStateException("No " + String.valueOf(quickStartWebXml));
            }
            default: {
                throw new IllegalStateException(this._mode.toString());
            }
        }
    }

    protected void configure(QuickStartGeneratorConfiguration generator, WebAppContext context) throws IOException {
        Object attr = context.getAttribute(ORIGIN_ATTRIBUTE);
        if (attr != null) {
            generator.setOriginAttribute(attr.toString());
        }
        Path quickStartWebXml = QuickStartConfiguration.getQuickStartWebXml(context);
        generator.setQuickStartWebXml(quickStartWebXml);
    }

    public void configure(WebAppContext context) throws Exception {
        if (!this._quickStart) {
            super.configure(context);
        } else {
            context.getMetaData().addDescriptorProcessor((DescriptorProcessor)new StandardDescriptorProcessor());
            this._quickStartDescriptorProcessor = new QuickStartDescriptorProcessor();
            context.getMetaData().addDescriptorProcessor((DescriptorProcessor)this._quickStartDescriptorProcessor);
            context.getObjectFactory().addDecorator((Decorator)new AnnotationDecorator(context));
            if (LOG.isDebugEnabled()) {
                LOG.debug("configured {}", (Object)this);
            }
        }
    }

    public void postConfigure(WebAppContext context) throws Exception {
        super.postConfigure(context);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        super.deconfigure(context);
        if (this._quickStartDescriptorProcessor != null) {
            this._quickStartDescriptorProcessor.close();
            this._quickStartDescriptorProcessor = null;
        }
        IO.close((Closeable)this._resourceFactory);
        this._resourceFactory = null;
    }

    protected void quickStart(WebAppContext context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.info("Quickstarting {}", (Object)context);
        }
        this._quickStart = true;
        context.setConfigurations((Configuration[])context.getConfigurations().stream().filter(c -> !__replacedConfigurations.contains(c.replaces())).filter(c -> !__replacedConfigurations.contains(c.getClass())).toArray(Configuration[]::new));
        Path quickStartWebXml = QuickStartConfiguration.getQuickStartWebXml(context);
        if (!Files.exists(quickStartWebXml, new LinkOption[0])) {
            throw new IllegalStateException("Quickstart doesn't exist: " + String.valueOf(quickStartWebXml));
        }
        Resource quickStartWebResource = context.getResourceFactory().newResource(quickStartWebXml);
        context.getMetaData().setWebDescriptor(new WebDescriptor(quickStartWebResource));
        context.getServletContext().setEffectiveMajorVersion(context.getMetaData().getWebDescriptor().getMajorVersion());
        context.getServletContext().setEffectiveMinorVersion(context.getMetaData().getWebDescriptor().getMinorVersion());
    }

    public static Path getQuickStartWebXml(WebAppContext context) throws IOException {
        Object attr = context.getAttribute(QUICKSTART_WEB_XML);
        if (attr instanceof Path) {
            return (Path)attr;
        }
        Path webInfDir = QuickStartConfiguration.getWebInfPath(context);
        Path qstartPath = webInfDir.resolve("quickstart-web.xml");
        if (attr != null && StringUtil.isNotBlank((String)attr.toString())) {
            Path attrPath;
            Resource resource;
            String attrValue = attr.toString();
            try {
                resource = context.getResourceFactory().newResource(webInfDir.resolve(attrValue));
            }
            catch (Throwable th) {
                resource = context.getResourceFactory().newResource(attrValue);
            }
            if (resource != null && (attrPath = resource.getPath()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using quickstart attribute {} value of {}", attr, (Object)attrValue);
                }
                qstartPath = attrPath;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using quickstart location: {}", (Object)qstartPath);
        }
        context.setAttribute(QUICKSTART_WEB_XML, (Object)qstartPath);
        return qstartPath;
    }

    private static Path getWebInfPath(WebAppContext context) throws IOException {
        Path baseResourcePath;
        Path webInfDir = null;
        Resource webInf = context.getWebInf();
        if (webInf != null) {
            webInfDir = webInf.getPath();
        }
        if (webInfDir == null && !Files.exists(webInfDir = (baseResourcePath = QuickStartConfiguration.findFirstWritablePath(context)).resolve("WEB-INF"), new LinkOption[0])) {
            Files.createDirectories(webInfDir, new FileAttribute[0]);
        }
        return webInfDir;
    }

    private static Path findFirstWritablePath(WebAppContext context) throws IOException {
        for (Resource resource : context.getBaseResource()) {
            Path path = resource.getPath();
            if (path == null || !Files.isDirectory(path, new LinkOption[0]) || !Files.isWritable(path)) continue;
            return path;
        }
        throw new IOException("Unable to find writable path in Base Resources");
    }

    static {
        __replacedConfigurations.add(WebXmlConfiguration.class);
        __replacedConfigurations.add(MetaInfConfiguration.class);
        __replacedConfigurations.add(FragmentConfiguration.class);
        __replacedConfigurations.add(AnnotationConfiguration.class);
    }

    public static enum Mode {
        GENERATE,
        AUTO,
        QUICKSTART;

    }
}

