/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server.internal;

import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.fcgi.generator.ServerGenerator;
import org.eclipse.jetty.fcgi.server.internal.ServerFCGIConnection;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStreamOverFCGI
implements HttpStream {
    private static final Logger LOG = LoggerFactory.getLogger(HttpStreamOverFCGI.class);
    private final Callback _demandCallback = new DemandCallback();
    private final HttpFields.Mutable _allHeaders = HttpFields.build();
    private final HttpFields.Mutable _headers = HttpFields.build();
    private final ServerFCGIConnection _connection;
    private final ServerGenerator _generator;
    private final HttpChannel _httpChannel;
    private final int _id;
    private String _method;
    private HostPortHttpField hostPort;
    private String _path;
    private String _query;
    private String _version;
    private String _secure;
    private Content.Chunk _chunk;
    private boolean _committed;
    private boolean _shutdown;
    private boolean _aborted;

    public HttpStreamOverFCGI(ServerFCGIConnection connection, ServerGenerator generator, HttpChannel httpChannel, int id) {
        this._connection = connection;
        this._generator = generator;
        this._httpChannel = httpChannel;
        this._id = id;
    }

    public HttpChannel getHttpChannel() {
        return this._httpChannel;
    }

    public String getId() {
        return String.valueOf(this._id);
    }

    public void onHeader(HttpField field) {
        String name = field.getName();
        String value = field.getValue();
        this._allHeaders.put(field);
        if ("REQUEST_METHOD".equalsIgnoreCase(name)) {
            this._method = value;
        } else if ("DOCUMENT_URI".equalsIgnoreCase(name)) {
            this._path = value;
        } else if ("QUERY_STRING".equalsIgnoreCase(name)) {
            this._query = value;
        } else if ("SERVER_PROTOCOL".equalsIgnoreCase(name)) {
            this._version = value;
        } else if ("HTTPS".equalsIgnoreCase(name)) {
            this._secure = value;
        } else {
            this.processField(field);
        }
    }

    public void onHeaders() {
        String pathQuery = URIUtil.addPathQuery((String)this._path, (String)this._query);
        HttpScheme scheme = StringUtil.isEmpty((String)this._secure) ? HttpScheme.HTTP : HttpScheme.HTTPS;
        MetaData.Request request = new MetaData.Request(NanoTime.now(), this._method, scheme.asString(), this.hostPort, pathQuery, HttpVersion.fromString((String)this._version), (HttpFields)this._headers, -1L);
        Runnable task = this._httpChannel.onRequest(request);
        this._allHeaders.forEach(field -> this._httpChannel.getRequest().setAttribute(field.getName(), (Object)field.getValue()));
        this.execute(task);
    }

    private void processField(HttpField field) {
        HttpField httpField = this.convertHeader(field);
        if (httpField != null) {
            this._headers.add(httpField);
            if (HttpHeader.HOST.is(httpField.getName())) {
                this.hostPort = (HostPortHttpField)httpField;
            }
        }
    }

    private HttpField convertHeader(HttpField field) {
        String name = field.getName();
        if (name.startsWith("HTTP_")) {
            String[] parts = name.split("_");
            StringBuilder httpName = new StringBuilder();
            for (int i = 1; i < parts.length; ++i) {
                if (i > 1) {
                    httpName.append("-");
                }
                String part = parts[i];
                httpName.append(Character.toUpperCase(part.charAt(0)));
                httpName.append(part.substring(1).toLowerCase(Locale.ENGLISH));
            }
            String headerName = httpName.toString();
            String value = field.getValue();
            if (HttpHeader.HOST.is(headerName)) {
                return new HostPortHttpField(value);
            }
            return new HttpField(headerName, value);
        }
        return null;
    }

    public Content.Chunk read() {
        if (this._chunk == null) {
            this._connection.parseAndFill();
        }
        Content.Chunk chunk = this._chunk;
        this._chunk = Content.Chunk.next((Content.Chunk)chunk);
        return chunk;
    }

    public void demand() {
        if (this._chunk != null) {
            return;
        }
        this._connection.parseAndFill();
        if (this._chunk != null) {
            this.notifyContentAvailable();
            return;
        }
        this._connection.tryFillInterested(this._demandCallback);
    }

    private void notifyContentAvailable() {
        Runnable onContentAvailable = this._httpChannel.onContentAvailable();
        if (onContentAvailable != null) {
            onContentAvailable.run();
        }
    }

    public void onContent(Content.Chunk chunk) {
        chunk.retain();
        this._chunk = chunk;
    }

    public void onComplete() {
        if (this._chunk == null) {
            this._chunk = Content.Chunk.EOF;
        } else if (!this._chunk.isLast() && !Content.Chunk.isFailure((Content.Chunk)this._chunk)) {
            throw new IllegalStateException();
        }
    }

    public void prepareResponse(HttpFields.Mutable headers) {
    }

    public void send(MetaData.Request request, MetaData.Response response, boolean last, ByteBuffer byteBuffer, Callback callback) {
        ByteBuffer content;
        ByteBuffer byteBuffer2 = content = byteBuffer != null ? byteBuffer : BufferUtil.EMPTY_BUFFER;
        if (LOG.isDebugEnabled()) {
            LOG.debug("send {} l={} {} {}", new Object[]{request, last, BufferUtil.toDetailString((ByteBuffer)byteBuffer), this});
        }
        boolean head = HttpMethod.HEAD.is(request.getMethod());
        if (response != null) {
            this.commit(response, head, last, content, callback);
        } else {
            Flusher flusher = this._connection.getFlusher();
            if (head) {
                if (last) {
                    ByteBufferPool.Accumulator accumulator = new ByteBufferPool.Accumulator();
                    this.generateResponseContent(accumulator, true, BufferUtil.EMPTY_BUFFER);
                    flusher.flush(accumulator, callback);
                } else {
                    callback.succeeded();
                }
            } else {
                ByteBufferPool.Accumulator accumulator = new ByteBufferPool.Accumulator();
                this.generateResponseContent(accumulator, last, content);
                flusher.flush(accumulator, callback);
            }
            if (last && this._shutdown) {
                flusher.shutdown();
            }
        }
    }

    private void commit(MetaData.Response info, boolean head, boolean last, ByteBuffer content, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("commit {} {} l={}", new Object[]{this, info, last});
        }
        this._committed = true;
        boolean shutdown = this._shutdown = info.getHttpFields().contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
        ByteBufferPool.Accumulator accumulator = new ByteBufferPool.Accumulator();
        Flusher flusher = this._connection.getFlusher();
        if (head) {
            if (last) {
                this.generateResponseHeaders(accumulator, info);
                this.generateResponseContent(accumulator, true, BufferUtil.EMPTY_BUFFER);
                flusher.flush(accumulator, callback);
            } else {
                this.generateResponseHeaders(accumulator, info);
                flusher.flush(accumulator, callback);
            }
        } else {
            this.generateResponseHeaders(accumulator, info);
            this.generateResponseContent(accumulator, last, content);
            flusher.flush(accumulator, callback);
        }
        if (last && shutdown) {
            flusher.shutdown();
        }
    }

    private void generateResponseHeaders(ByteBufferPool.Accumulator accumulator, MetaData.Response info) {
        this._generator.generateResponseHeaders(accumulator, this._id, info.getStatus(), info.getReason(), info.getHttpFields());
    }

    private void generateResponseContent(ByteBufferPool.Accumulator accumulator, boolean last, ByteBuffer buffer) {
        this._generator.generateResponseContent(accumulator, this._id, buffer, last, this._aborted);
    }

    public long getIdleTimeout() {
        return this._connection.getEndPoint().getIdleTimeout();
    }

    public void setIdleTimeout(long idleTimeoutMs) {
        this._connection.getEndPoint().setIdleTimeout(idleTimeoutMs);
    }

    public boolean isCommitted() {
        return this._committed;
    }

    public Throwable consumeAvailable() {
        return HttpStream.consumeAvailable((HttpStream)this, (HttpConfiguration)this._httpChannel.getConnectionMetaData().getHttpConfiguration());
    }

    public void succeeded() {
        this._httpChannel.recycle();
        this._connection.onCompleted(null);
    }

    public void failed(Throwable x) {
        this._aborted = true;
        this._connection.onCompleted(x);
    }

    public boolean onIdleTimeout(TimeoutException timeout) {
        Runnable task = this._httpChannel.onIdleTimeout(timeout);
        if (task != null) {
            this.execute(task);
        }
        return false;
    }

    private void execute(Runnable task) {
        this._connection.getConnector().getExecutor().execute(task);
    }

    public String toString() {
        return "%s@%x".formatted(this.getClass().getSimpleName(), this.hashCode());
    }

    private class DemandCallback
    implements Callback {
        private DemandCallback() {
        }

        public void succeeded() {
            HttpStreamOverFCGI.this.notifyContentAvailable();
        }

        public void failed(Throwable x) {
            Runnable task = HttpStreamOverFCGI.this._httpChannel.onFailure(x);
            if (task != null) {
                HttpStreamOverFCGI.this._connection.getConnector().getExecutor().execute(task);
            }
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.getInvocationType((Object)HttpStreamOverFCGI.this._httpChannel);
        }
    }
}

