/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http3.internal.VarLenInt;

public class HeaderParser {
    private final VarLenInt varLenInt = new VarLenInt();
    private State state = State.TYPE;
    private long type;
    private long length;

    public void reset() {
        this.varLenInt.reset();
        this.state = State.TYPE;
        this.type = 0L;
        this.length = 0L;
    }

    public boolean parse(ByteBuffer buffer) {
        block4: while (buffer.hasRemaining()) {
            switch (this.state) {
                case TYPE: {
                    if (this.varLenInt.decode(buffer, v -> {
                        this.type = v;
                    })) {
                        this.state = State.LENGTH;
                        continue block4;
                    }
                    return false;
                }
                case LENGTH: {
                    if (this.varLenInt.decode(buffer, v -> {
                        this.length = v;
                    })) {
                        this.state = State.TYPE;
                        return true;
                    }
                    return false;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    public long getFrameType() {
        return this.type;
    }

    public long getFrameLength() {
        return this.length;
    }

    private static enum State {
        TYPE,
        LENGTH;

    }
}

