/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.parser;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.BooleanSupplier;
import java.util.function.UnaryOperator;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.frames.FrameType;
import org.eclipse.jetty.http3.parser.BodyParser;
import org.eclipse.jetty.http3.parser.DataBodyParser;
import org.eclipse.jetty.http3.parser.HeaderParser;
import org.eclipse.jetty.http3.parser.HeadersBodyParser;
import org.eclipse.jetty.http3.parser.ParserListener;
import org.eclipse.jetty.http3.parser.PushPromiseBodyParser;
import org.eclipse.jetty.http3.parser.UnknownBodyParser;
import org.eclipse.jetty.http3.qpack.QpackDecoder;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.NanoTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageParser {
    private static final Logger LOG = LoggerFactory.getLogger(MessageParser.class);
    private final HeaderParser headerParser = new HeaderParser();
    private final BodyParser[] bodyParsers = new BodyParser[FrameType.maxType() + 1];
    private final ParserListener listener;
    private final QpackDecoder decoder;
    private final long streamId;
    private final BooleanSupplier isLast;
    private BodyParser unknownBodyParser;
    private State state = State.HEADER;
    protected boolean dataMode;
    private long beginNanoTime;

    public MessageParser(ParserListener listener, QpackDecoder decoder, long streamId, BooleanSupplier isLast) {
        this.listener = listener;
        this.decoder = decoder;
        this.streamId = streamId;
        this.isLast = isLast;
    }

    public long getBeginNanoTime() {
        return this.beginNanoTime;
    }

    public void init(UnaryOperator<ParserListener> wrapper) {
        ParserListener listener = (ParserListener)wrapper.apply(this.listener);
        this.bodyParsers[FrameType.DATA.type()] = new DataBodyParser(this.headerParser, listener, this.streamId, this.isLast);
        this.bodyParsers[FrameType.HEADERS.type()] = new HeadersBodyParser(this.headerParser, listener, this.decoder, this.streamId, this.isLast);
        this.bodyParsers[FrameType.PUSH_PROMISE.type()] = new PushPromiseBodyParser(this.headerParser, listener);
        this.unknownBodyParser = new UnknownBodyParser(this.headerParser, listener);
    }

    private void reset() {
        this.headerParser.reset();
        this.state = State.HEADER;
    }

    public ParserListener getListener() {
        return this.listener;
    }

    public boolean isDataMode() {
        return this.dataMode;
    }

    public void setDataMode(boolean enable) {
        this.dataMode = enable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result parse(ByteBuffer buffer) {
        try {
            block6: while (true) {
                switch (this.state) {
                    case HEADER: {
                        if (!this.headerParser.parse(buffer)) {
                            return Result.NO_FRAME;
                        }
                        this.state = State.BODY;
                        if (!this.isDataMode() || this.headerParser.getFrameType() == (long)FrameType.DATA.type()) continue block6;
                        return Result.SWITCH_MODE;
                    }
                    case BODY: {
                        BodyParser.Result result;
                        BodyParser bodyParser = null;
                        long frameType = this.headerParser.getFrameType();
                        this.beginNanoTime = NanoTime.now();
                        if (frameType >= 0L && frameType < (long)this.bodyParsers.length) {
                            bodyParser = this.bodyParsers[(int)frameType];
                        }
                        if (bodyParser == null) {
                            if (FrameType.isControl(frameType)) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("invalid control frame type {} on message stream", (Object)Long.toHexString(frameType));
                                }
                                this.sessionFailure(buffer, HTTP3ErrorCode.FRAME_UNEXPECTED_ERROR.code(), "invalid_frame_type", new IOException("invalid control frame in message stream"));
                                return Result.NO_FRAME;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("ignoring unknown frame type {}", (Object)Long.toHexString(frameType));
                            }
                            if ((result = this.unknownBodyParser.parse(buffer)) == BodyParser.Result.NO_FRAME) {
                                return Result.NO_FRAME;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("parsed unknown frame body for type {}", (Object)Long.toHexString(frameType));
                            }
                            if (result != BodyParser.Result.WHOLE_FRAME) continue block6;
                            this.reset();
                            continue block6;
                        }
                        if (this.headerParser.getFrameLength() == 0L) {
                            bodyParser.emptyBody(buffer);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("parsed {} empty frame body from {}", (Object)FrameType.from(frameType), (Object)BufferUtil.toDetailString((ByteBuffer)buffer));
                            }
                            this.reset();
                            return Result.FRAME;
                        }
                        result = bodyParser.parse(buffer);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("parsed {} {} body from {}", new Object[]{result, FrameType.from(frameType), BufferUtil.toDetailString((ByteBuffer)buffer)});
                        }
                        if (result == BodyParser.Result.NO_FRAME) {
                            return Result.NO_FRAME;
                        }
                        if (result == BodyParser.Result.FRAGMENT_FRAME) {
                            return Result.FRAME;
                        }
                        this.reset();
                        if (result == BodyParser.Result.BLOCKED_FRAME) {
                            return Result.BLOCKED_FRAME;
                        }
                        if (result == BodyParser.Result.WHOLE_FRAME) {
                            return Result.FRAME;
                        }
                        throw new IllegalStateException();
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("parse failed", x);
            }
            this.sessionFailure(buffer, HTTP3ErrorCode.INTERNAL_ERROR.code(), "parser_error", x);
            return Result.NO_FRAME;
        }
    }

    private void sessionFailure(ByteBuffer buffer, long error, String reason, Throwable failure) {
        this.unknownBodyParser.sessionFailure(buffer, error, reason, failure);
    }

    private static enum State {
        HEADER,
        BODY;

    }

    public static enum Result {
        NO_FRAME,
        FRAME,
        BLOCKED_FRAME,
        SWITCH_MODE;

    }
}

