/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpConversation;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpResponse;
import org.eclipse.jetty.client.transport.ResponseListeners;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.io.content.ContentSourceTransformer;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(HttpReceiver.class);
    private final SerializedInvoker invoker = new SerializedInvoker();
    private final HttpChannel channel;
    private ResponseState responseState = ResponseState.IDLE;
    private NotifiableContentSource contentSource;
    private Throwable failure;

    protected HttpReceiver(HttpChannel channel) {
        this.channel = channel;
    }

    protected abstract Content.Chunk read(boolean var1);

    protected abstract void onInterim();

    protected abstract void failAndClose(Throwable var1);

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    protected HttpDestination getHttpDestination() {
        return this.channel.getHttpDestination();
    }

    public boolean isFailed() {
        return this.responseState == ResponseState.FAILURE;
    }

    protected boolean hasContent() {
        return this.contentSource != null;
    }

    protected void responseBegin(HttpExchange exchange) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseBegin for {} on {}", (Object)exchange, (Object)this);
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseBegin for {} on {}", (Object)exchange, (Object)this);
            }
            if (exchange.isResponseComplete()) {
                return;
            }
            this.responseState = ResponseState.BEGIN;
            HttpResponse response = exchange.getResponse();
            HttpConversation conversation = exchange.getConversation();
            HttpClient client = this.getHttpDestination().getHttpClient();
            ProtocolHandler protocolHandler = client.findProtocolHandler(exchange.getRequest(), response);
            Response.Listener handlerListener = null;
            if (protocolHandler != null) {
                handlerListener = protocolHandler.getResponseListener();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response {} found protocol handler {}", (Object)response, (Object)protocolHandler);
                }
            }
            conversation.updateResponseListeners(handlerListener);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response begin {}", (Object)response);
            }
            conversation.getResponseListeners().notifyBegin(response);
        });
    }

    protected void responseHeader(HttpExchange exchange, HttpField field) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseHeader for {} on {}", (Object)field, (Object)this);
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseHeader on {}", (Object)this);
            }
            if (exchange.isResponseComplete()) {
                return;
            }
            this.responseState = ResponseState.HEADER;
            HttpResponse response = exchange.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Notifying header {}", (Object)field);
            }
            boolean process = exchange.getConversation().getResponseListeners().notifyHeader(response, field);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Header {} notified, {}processing needed", (Object)field, (Object)(process ? "" : "no "));
            }
            if (process) {
                response.addHeader(field);
                HttpHeader fieldHeader = field.getHeader();
                if (fieldHeader != null) {
                    switch (fieldHeader) {
                        case SET_COOKIE: 
                        case SET_COOKIE2: {
                            URI uri = exchange.getRequest().getURI();
                            if (uri == null) break;
                            this.storeCookie(uri, field);
                        }
                    }
                }
            }
        });
    }

    protected void storeCookie(URI uri, HttpField field) {
        this.getHttpDestination().getHttpClient().putCookie(uri, field);
    }

    protected void responseHeaders(HttpExchange exchange) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseHeaders on {}", (Object)this);
        }
        this.invoker.run(() -> {
            List contentEncodings;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseHeaders on {}", (Object)this);
            }
            if (exchange.isResponseComplete()) {
                return;
            }
            this.responseState = ResponseState.HEADERS;
            HttpResponse response = exchange.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response headers {}{}{}", new Object[]{response, System.lineSeparator(), response.getHeaders().toString().trim()});
            }
            ResponseListeners responseListeners = exchange.getConversation().getResponseListeners();
            responseListeners.notifyHeaders(response);
            if (exchange.isResponseComplete()) {
                return;
            }
            if (HttpStatus.isInterim((int)response.getStatus())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Interim response status {}, succeeding", (Object)response.getStatus());
                }
                this.responseSuccess(exchange, this::onInterim);
                return;
            }
            this.responseState = ResponseState.CONTENT;
            if (this.contentSource != null) {
                throw new IllegalStateException();
            }
            this.contentSource = new ContentSource();
            if (responseListeners.hasContentSourceListeners() && (contentEncodings = response.getHeaders().getCSV(HttpHeader.CONTENT_ENCODING.asString(), false)) != null && !contentEncodings.isEmpty()) {
                block0: for (ContentDecoder.Factory factory : this.getHttpDestination().getHttpClient().getContentDecoderFactories()) {
                    for (String encoding : contentEncodings) {
                        if (!factory.getEncoding().equalsIgnoreCase(encoding)) continue;
                        this.contentSource = new DecodingContentSource(this.contentSource, factory.newContentDecoder(), this.invoker);
                        break block0;
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response content {} {}", (Object)response, (Object)this.contentSource);
            }
            responseListeners.notifyContentSource(response, this.contentSource);
        });
    }

    protected void responseContentAvailable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response content available on {}", (Object)this);
        }
        this.contentSource.onDataAvailable();
    }

    protected void responseSuccess(HttpExchange exchange, Runnable afterSuccessTask) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseSuccess on {}", (Object)this);
        }
        if (!exchange.responseComplete(null)) {
            return;
        }
        this.invoker.run(new Runnable[]{() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseSuccess on {}", (Object)this);
            }
            this.responseState = ResponseState.IDLE;
            this.reset();
            HttpResponse response = exchange.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response success {}", (Object)response);
            }
            exchange.getConversation().getResponseListeners().notifySuccess(response);
            if (HttpStatus.isInterim((int)exchange.getResponse().getStatus())) {
                return;
            }
            this.terminateResponse(exchange);
        }, afterSuccessTask});
    }

    protected void responseFailure(Throwable failure, Promise<Boolean> promise) {
        HttpExchange exchange;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failing with {} on {}", (Object)failure, (Object)this);
        }
        if ((exchange = this.getHttpExchange()) != null && exchange.responseComplete(failure)) {
            this.abort(exchange, failure, promise);
        } else {
            promise.succeeded((Object)false);
        }
    }

    private void terminateResponse(HttpExchange exchange) {
        Result result = exchange.terminateResponse();
        this.terminateResponse(exchange, result);
    }

    private void terminateResponse(HttpExchange exchange, Result result) {
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response complete {}, result: {}", (Object)response, (Object)result);
        }
        if (result != null) {
            result = this.channel.exchangeTerminating(exchange, result);
            boolean ordered = this.getHttpDestination().getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(exchange, result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {}: {}", (Object)(this.failure == null ? "succeeded" : "failed"), (Object)result);
            }
            exchange.getConversation().getResponseListeners().notifyComplete(result);
            if (ordered) {
                this.channel.exchangeTerminated(exchange, result);
            }
        }
    }

    protected void reset() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resetting {}", (Object)this);
        }
        this.cleanup();
    }

    protected void dispose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disposing {}", (Object)this);
        }
        this.cleanup();
    }

    private void cleanup() {
        this.contentSource = null;
    }

    public void abort(HttpExchange exchange, Throwable failure, Promise<Boolean> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking abort with {} on {}", (Object)failure, (Object)this);
        }
        if (!exchange.isResponseComplete()) {
            throw new IllegalStateException();
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing abort with {} on {}", (Object)failure, (Object)this);
            }
            if (this.responseState == ResponseState.FAILURE) {
                promise.succeeded((Object)false);
                return;
            }
            this.responseState = ResponseState.FAILURE;
            this.failure = failure;
            if (this.contentSource != null) {
                this.contentSource.error(failure);
            }
            this.dispose();
            HttpResponse response = exchange.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response abort {} {} on {}: {}", new Object[]{response, exchange, this.getHttpChannel(), failure});
            }
            exchange.getConversation().getResponseListeners().notifyFailure(response, failure);
            this.terminateResponse(exchange);
            promise.succeeded((Object)true);
        });
    }

    public String toString() {
        return String.format("%s@%x(ex=%s,rsp=%s,failure=%s)", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.getHttpExchange(), this.responseState, this.failure});
    }

    private static enum ResponseState {
        IDLE,
        BEGIN,
        HEADER,
        HEADERS,
        CONTENT,
        FAILURE;

    }

    private static interface NotifiableContentSource
    extends Content.Source {
        public boolean error(Throwable var1);

        public void onDataAvailable();
    }

    private class ContentSource
    implements NotifiableContentSource {
        private static final Logger LOG = LoggerFactory.getLogger(ContentSource.class);
        private final AtomicReference<Runnable> demandCallbackRef = new AtomicReference();
        private final AutoLock lock = new AutoLock();
        private final Runnable processDemand = this::processDemand;
        private Content.Chunk currentChunk;

        private ContentSource() {
        }

        public Content.Chunk read() {
            Content.Chunk current;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading from {}", (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                current = this.currentChunk;
                this.currentChunk = Content.Chunk.next((Content.Chunk)current);
                if (current != null) {
                    Content.Chunk chunk = current;
                    return chunk;
                }
            }
            current = HttpReceiver.this.read(false);
            ignored = this.lock.lock();
            try {
                if (this.currentChunk != null) {
                    if (current != null) {
                        current.release();
                    }
                    Content.Chunk chunk = this.currentChunk;
                    return chunk;
                }
                this.currentChunk = Content.Chunk.next((Content.Chunk)current);
                Content.Chunk chunk = current;
                return chunk;
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }

        @Override
        public void onDataAvailable() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onDataAvailable on {}", (Object)this);
            }
            this.invokeDemandCallback(true);
        }

        public void demand(Runnable demandCallback) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering demand on {}", (Object)this);
            }
            if (demandCallback == null) {
                throw new IllegalArgumentException();
            }
            if (!this.demandCallbackRef.compareAndSet(null, demandCallback)) {
                throw new IllegalStateException();
            }
            HttpReceiver.this.invoker.run(this.processDemand);
        }

        private void processDemand() {
            Content.Chunk current;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing demand on {}", (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                current = this.currentChunk;
            }
            if (current == null) {
                current = HttpReceiver.this.read(true);
                if (current == null) {
                    return;
                }
                ignored = this.lock.lock();
                try {
                    if (this.currentChunk != null) {
                        current.release();
                        return;
                    }
                    this.currentChunk = current;
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            this.invokeDemandCallback(false);
        }

        private void invokeDemandCallback(boolean invoke) {
            Runnable demandCallback = this.demandCallbackRef.getAndSet(null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invoking demand callback on {}", (Object)this);
            }
            if (demandCallback != null) {
                try {
                    if (invoke) {
                        HttpReceiver.this.invoker.run(demandCallback);
                    } else {
                        demandCallback.run();
                    }
                }
                catch (Throwable x) {
                    this.fail(x);
                }
            }
        }

        public void fail(Throwable failure) {
            boolean failed;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failing {}", (Object)this);
            }
            if (failed = this.error(failure)) {
                HttpReceiver.this.failAndClose(failure);
            }
            this.invokeDemandCallback(true);
        }

        @Override
        public boolean error(Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Erroring {}", (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                if (Content.Chunk.isFailure((Content.Chunk)this.currentChunk)) {
                    boolean bl = false;
                    return bl;
                }
                if (this.currentChunk != null) {
                    this.currentChunk.release();
                }
                this.currentChunk = Content.Chunk.from((Throwable)failure);
            }
            return true;
        }

        private Content.Chunk chunk() {
            try (AutoLock ignored = this.lock.lock();){
                Content.Chunk chunk = this.currentChunk;
                return chunk;
            }
        }

        public String toString() {
            return String.format("%s@%x{c=%s,d=%s}", this.getClass().getSimpleName(), this.hashCode(), this.chunk(), this.demandCallbackRef);
        }
    }

    private static class DecodingContentSource
    extends ContentSourceTransformer
    implements NotifiableContentSource {
        private static final Logger LOG = LoggerFactory.getLogger(DecodingContentSource.class);
        private final NotifiableContentSource _rawSource;
        private final ContentDecoder _decoder;
        private volatile Content.Chunk _chunk;

        public DecodingContentSource(NotifiableContentSource rawSource, ContentDecoder decoder, SerializedInvoker invoker) {
            super((Content.Source)rawSource, invoker);
            this._rawSource = rawSource;
            this._decoder = decoder;
        }

        @Override
        public void onDataAvailable() {
            this._rawSource.onDataAvailable();
        }

        protected Content.Chunk transform(Content.Chunk inputChunk) {
            while (true) {
                boolean retain;
                boolean bl = retain = this._chunk == null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("input: {}, chunk: {}, retain? {}", new Object[]{inputChunk, this._chunk, retain});
                }
                if (this._chunk == null) {
                    this._chunk = inputChunk;
                }
                if (this._chunk == null) {
                    return null;
                }
                if (Content.Chunk.isFailure((Content.Chunk)this._chunk)) {
                    return this._chunk;
                }
                if (retain) {
                    this._chunk.retain();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("decoding: {}", (Object)this._chunk);
                }
                RetainableByteBuffer decodedBuffer = this._decoder.decode(this._chunk.getByteBuffer());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("decoded: {}", (Object)decodedBuffer);
                }
                if (decodedBuffer != null && decodedBuffer.hasRemaining()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("returning decoded content");
                    }
                    return Content.Chunk.asChunk((ByteBuffer)decodedBuffer.getByteBuffer(), (boolean)false, (Retainable)decodedBuffer);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("decoding produced no content");
                }
                if (!this._chunk.hasRemaining()) {
                    Content.Chunk result;
                    Object object = result = this._chunk.isLast() ? Content.Chunk.EOF : null;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not decode more from this chunk, releasing it, r={}", (Object)result);
                    }
                    this._chunk.release();
                    this._chunk = null;
                    return result;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("retrying transformation");
            }
        }

        @Override
        public boolean error(Throwable failure) {
            if (this._chunk != null) {
                this._chunk.release();
            }
            this._chunk = null;
            return this._rawSource.error(failure);
        }
    }
}

