/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.messages;

import java.lang.invoke.MethodHandle;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.exception.BadPayloadException;
import org.eclipse.jetty.websocket.core.messages.AbstractMessageSink;

public class PartialStringMessageSink
extends AbstractMessageSink {
    private Utf8StringBuilder accumulator;

    public PartialStringMessageSink(CoreSession session, MethodHandle methodHandle, boolean autoDemand) {
        super(session, methodHandle, autoDemand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            if (this.accumulator == null) {
                this.accumulator = new Utf8StringBuilder(this.getCoreSession().getInputBufferSize());
            }
            this.accumulator.append(frame.getPayload());
            if (frame.isFin()) {
                String complete = this.accumulator.takeCompleteString(() -> new BadPayloadException("Invalid UTF-8"));
                this.getMethodHandle().invoke(complete, true);
            } else {
                String partial = this.accumulator.takePartialString(() -> new BadPayloadException("Invalid UTF-8"));
                this.getMethodHandle().invoke(partial, false);
            }
            callback.succeeded();
            this.autoDemand();
        }
        catch (Throwable t) {
            callback.failed(t);
        }
        finally {
            if (frame.isFin()) {
                this.accumulator = null;
            }
        }
    }

    @Override
    public void fail(Throwable failure) {
        if (this.accumulator != null) {
            this.accumulator.reset();
        }
    }
}

