/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.messages;

import java.lang.invoke.MethodHandle;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.exception.BadPayloadException;
import org.eclipse.jetty.websocket.core.exception.MessageTooLargeException;
import org.eclipse.jetty.websocket.core.messages.AbstractMessageSink;

public class StringMessageSink
extends AbstractMessageSink {
    private Utf8StringBuilder out;
    private int size = 0;

    public StringMessageSink(CoreSession session, MethodHandle methodHandle, boolean autoDemand) {
        super(session, methodHandle, autoDemand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            this.size += frame.getPayloadLength();
            long maxSize = this.getCoreSession().getMaxTextMessageSize();
            if (maxSize > 0L && (long)this.size > maxSize) {
                callback.failed((Throwable)new MessageTooLargeException(String.format("Text message too large: %,d > %,d", this.size, maxSize)));
                return;
            }
            if (this.out == null) {
                this.out = new Utf8StringBuilder(this.getCoreSession().getInputBufferSize());
            }
            this.out.append(frame.getPayload());
            if (frame.isFin()) {
                this.getMethodHandle().invoke(this.out.takeCompleteString(() -> new BadPayloadException("Invalid UTF-8")));
                callback.succeeded();
                this.autoDemand();
            } else {
                callback.succeeded();
                this.getCoreSession().demand();
            }
        }
        catch (Throwable t) {
            callback.failed(t);
        }
        finally {
            if (frame.isFin()) {
                this.size = 0;
                this.out = null;
            }
        }
    }

    @Override
    public void fail(Throwable failure) {
        if (this.out != null) {
            this.out.reset();
        }
    }
}

