/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.nested;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.ee9.nested.AsyncAttributes;
import org.eclipse.jetty.ee9.nested.ServletPathMapping;
import org.eclipse.jetty.util.Attributes;

public class ServletAttributes
implements Attributes {
    private final Attributes _attributes;
    private AsyncAttributes _asyncAttributes;

    ServletAttributes(Attributes attributes) {
        this._attributes = new SSLAttributes(attributes);
    }

    public void setAsyncAttributes(String requestURI, String contextPath, String pathInContext, ServletPathMapping servletPathMapping, String queryString) {
        this._asyncAttributes = new AsyncAttributes(this._attributes, requestURI, contextPath, pathInContext, servletPathMapping, queryString);
    }

    private Attributes getAttributes() {
        return this._asyncAttributes == null ? this._attributes : this._asyncAttributes;
    }

    public Object removeAttribute(String name) {
        return this.getAttributes().removeAttribute(name);
    }

    public Object setAttribute(String name, Object attribute) {
        return this.getAttributes().setAttribute(name, attribute);
    }

    public Object getAttribute(String name) {
        return this.getAttributes().getAttribute(name);
    }

    public Set<String> getAttributeNameSet() {
        return this.getAttributes().getAttributeNameSet();
    }

    public void clearAttributes() {
        this.getAttributes().clearAttributes();
        this._asyncAttributes = null;
    }

    private static class SSLAttributes
    extends Attributes.Wrapper {
        public SSLAttributes(Attributes wrapped) {
            super(wrapped);
        }

        public Object getAttribute(String name) {
            return switch (name) {
                case "jakarta.servlet.request.cipher_suite" -> super.getAttribute("org.eclipse.jetty.server.cipher");
                case "jakarta.servlet.request.key_size" -> super.getAttribute("org.eclipse.jetty.server.keySize");
                case "jakarta.servlet.request.ssl_session_id" -> super.getAttribute("org.eclipse.jetty.server.sslSessionId");
                case "jakarta.servlet.request.X509Certificate" -> super.getAttribute("org.eclipse.jetty.server.peerCertificates");
                default -> super.getAttribute(name);
            };
        }

        public Set<String> getAttributeNameSet() {
            HashSet<String> names = new HashSet<String>(super.getAttributeNameSet());
            if (names.contains("org.eclipse.jetty.server.cipher")) {
                names.add("jakarta.servlet.request.cipher_suite");
            }
            if (names.contains("org.eclipse.jetty.server.keySize")) {
                names.add("jakarta.servlet.request.key_size");
            }
            if (names.contains("org.eclipse.jetty.server.sslSessionId")) {
                names.add("jakarta.servlet.request.ssl_session_id");
            }
            if (names.contains("org.eclipse.jetty.server.peerCertificates")) {
                names.add("jakarta.servlet.request.X509Certificate");
            }
            return names;
        }
    }
}

