/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.websocket.javax.client.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.HandshakeResponse;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.websocket.core.client.UpgradeListener;

public class JsrUpgradeListener
implements UpgradeListener {
    private final ClientEndpointConfig.Configurator configurator;

    public JsrUpgradeListener(ClientEndpointConfig.Configurator configurator) {
        this.configurator = configurator;
    }

    public void onHandshakeRequest(Request request) {
        if (this.configurator == null) {
            return;
        }
        HttpFields fields = request.getHeaders();
        HashMap originalHeaders = new HashMap();
        fields.forEach(field -> {
            originalHeaders.putIfAbsent(field.getName(), new ArrayList());
            List values = (List)originalHeaders.get(field.getName());
            Collections.addAll(values, field.getValues());
        });
        this.configurator.beforeRequest(originalHeaders);
        request.headers(headers -> {
            headers.clear();
            originalHeaders.forEach((arg_0, arg_1) -> ((HttpFields.Mutable)headers).put(arg_0, arg_1));
        });
    }

    public void onHandshakeResponse(Request request, Response response) {
        if (this.configurator == null) {
            return;
        }
        HandshakeResponse handshakeResponse = () -> {
            HashMap ret = new HashMap();
            response.getHeaders().forEach(field -> {
                ret.putIfAbsent(field.getName(), new ArrayList());
                List values = (List)ret.get(field.getName());
                Collections.addAll(values, field.getValues());
            });
            return ret;
        };
        this.configurator.afterResponse(handshakeResponse);
    }
}

