/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.websocket.javax.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.websocket.Extension;
import org.eclipse.jetty.websocket.core.ExtensionConfig;

public class JavaxWebSocketExtension
implements Extension {
    private final String name;
    private List<Extension.Parameter> parameters = new ArrayList<Extension.Parameter>();

    public JavaxWebSocketExtension(ExtensionConfig cfg) {
        this.name = cfg.getName();
        if (cfg.getParameters() != null) {
            for (Map.Entry entry : cfg.getParameters().entrySet()) {
                this.parameters.add(new JsrParameter((String)entry.getKey(), (String)entry.getValue()));
            }
        }
    }

    public JavaxWebSocketExtension(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<Extension.Parameter> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaxWebSocketExtension that = (JavaxWebSocketExtension)o;
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.name);
        for (Extension.Parameter param : this.parameters) {
            str.append(';');
            str.append(param.getName());
            String value = param.getValue();
            if (value == null) continue;
            str.append('=');
            ExtensionConfig.quoteIfNeeded((StringBuilder)str, (String)value);
        }
        return str.toString();
    }

    private static class JsrParameter
    implements Extension.Parameter {
        private String name;
        private String value;

        private JsrParameter(String key, String value) {
            this.name = key;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

