/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileArg;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.Version;

public class Module
implements Comparable<Module> {
    private static final String VERSION_UNSPECIFIED = "0.0";
    static Pattern MOD_NAME = Pattern.compile("^(.*)\\.mod", 2);
    static Pattern SET_PROPERTY = Pattern.compile("^(#?)\\s*([^=\\s]+)=(.*)$");
    private final Path _path;
    private final String _name;
    private final boolean _dynamic;
    private Version version;
    private final List<String> _description = new ArrayList<String>();
    private final List<String> _xmls = new ArrayList<String>();
    private final List<String> _iniTemplate = new ArrayList<String>();
    private final List<String> _ini = new ArrayList<String>();
    private final List<String> _libs = new ArrayList<String>();
    private final List<String> _jpms = new ArrayList<String>();
    private final List<String> _files = new ArrayList<String>();
    private final Set<String> _enables = new HashSet<String>();
    private final Set<String> _provides = new HashSet<String>();
    private final List<String> _tags = new ArrayList<String>();
    private boolean _notTransitive;
    private boolean _skipFilesValidation = false;
    private final List<String> _jvmArgs = new ArrayList<String>();
    private final List<String> _license = new ArrayList<String>();
    private final List<String> _depends = new ArrayList<String>();
    private final List<String> _deprecated = new ArrayList<String>();
    private final Set<String> _before = new HashSet<String>();
    private final Set<String> _after = new HashSet<String>();
    private String _environment;

    public Module(BaseHome basehome, Path path) throws IOException {
        this._path = path;
        int m = -1;
        int i = path.getNameCount();
        while (i-- > 0) {
            if (!"modules".equals(path.getName(i).toString())) continue;
            m = i;
            break;
        }
        if (m < 0) {
            throw new IllegalArgumentException("Module not contained within modules directory: " + basehome.toShortForm(path));
        }
        Object n = path.getName(m + 1).toString();
        for (int i2 = m + 2; i2 < path.getNameCount(); ++i2) {
            n = (String)n + "/" + path.getName(i2).toString();
        }
        Matcher matcher = MOD_NAME.matcher((CharSequence)n);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Module filename must have .mod extension: " + basehome.toShortForm(path));
        }
        this._name = matcher.group(1);
        this._provides.add(this._name);
        this._dynamic = this._name.contains("/");
        this.process(basehome);
    }

    public static boolean isConditionalDependency(String depends) {
        return depends != null && depends.charAt(0) == '?';
    }

    public static String normalizeModuleName(String name) {
        if (Module.isConditionalDependency(name)) {
            return name.substring(1);
        }
        return name;
    }

    public String getEnvironment() {
        return this._environment;
    }

    public String getName() {
        return this._name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Module other = (Module)obj;
        if (this._path == null) {
            return other._path == null;
        }
        return this._path.equals(other._path);
    }

    public void expandDependencies(Props props) {
        Function<String, String> expander = d -> props.expand((String)d);
        List tmp = this._depends.stream().map(expander).collect(Collectors.toList());
        this._depends.clear();
        this._depends.addAll(tmp);
        tmp = this._after.stream().map(expander).collect(Collectors.toList());
        this._after.clear();
        this._after.addAll(tmp);
        tmp = this._before.stream().map(expander).collect(Collectors.toList());
        this._before.clear();
        this._before.addAll(tmp);
    }

    public List<String> getIniSection() {
        return this._ini;
    }

    public List<String> getIniTemplate() {
        return this._iniTemplate;
    }

    public List<String> getFiles() {
        return this._files;
    }

    public boolean isSkipFilesValidation() {
        return this._skipFilesValidation;
    }

    public List<String> getJvmArgs() {
        return this._jvmArgs;
    }

    public List<String> getLibs() {
        return this._libs;
    }

    public List<String> getLicense() {
        return this._license;
    }

    public List<String> getXmls() {
        return this._xmls;
    }

    public List<String> getJPMS() {
        return this._jpms;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean hasDefaultConfig() {
        return !this._ini.isEmpty();
    }

    public boolean hasIniTemplate() {
        return !this._iniTemplate.isEmpty();
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean hasLicense() {
        return this._license != null && this._license.size() > 0;
    }

    public boolean isDynamic() {
        return this._dynamic;
    }

    public boolean hasFiles(BaseHome baseHome, Props props) {
        for (String ref : this.getFiles()) {
            FileArg farg = new FileArg(this, props.expand(ref));
            Path refPath = baseHome.getBasePath(farg.location);
            if (Files.exists(refPath, new LinkOption[0])) continue;
            return false;
        }
        return true;
    }

    public void process(BaseHome basehome) throws FileNotFoundException, IOException {
        Pattern section = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
        if (!FS.canReadFile(this._path)) {
            StartLog.debug("Skipping read of missing file: %s", basehome.toShortForm(this._path));
            return;
        }
        try (BufferedReader buf = Files.newBufferedReader(this._path, StandardCharsets.UTF_8);){
            String line;
            String sectionType = "";
            block58: while ((line = buf.readLine()) != null) {
                Matcher sectionMatcher = section.matcher(line = line.trim());
                if (sectionMatcher.matches()) {
                    sectionType = sectionMatcher.group(1).trim().toUpperCase(Locale.ENGLISH);
                    continue;
                }
                if (line.length() == 0 || line.startsWith("#")) {
                    if (!"INI-TEMPLATE".equals(sectionType) || line.contains("tag::") || line.contains("end::")) continue;
                    this._iniTemplate.add(line);
                    continue;
                }
                switch (sectionType) {
                    case "": {
                        break;
                    }
                    case "DESCRIPTION": {
                        this._description.add(line);
                        break;
                    }
                    case "DEPEND": 
                    case "DEPENDS": {
                        if (this._depends.contains(line)) continue block58;
                        this._depends.add(line);
                        break;
                    }
                    case "DEPRECATED": {
                        this._deprecated.add(line);
                        break;
                    }
                    case "ENV": 
                    case "ENVIRONMENT": {
                        this._environment = line;
                        break;
                    }
                    case "FILE": 
                    case "FILES": {
                        this._files.add(line);
                        break;
                    }
                    case "TAG": 
                    case "TAGS": {
                        this._tags.add(line);
                        break;
                    }
                    case "DEFAULTS": 
                    case "INI": {
                        int idx = line.indexOf(61);
                        if (idx > 0) {
                            String key = line.substring(0, idx);
                            String value = line.substring(idx + 1);
                            if (key.endsWith("?") || key.endsWith("+")) {
                                this._ini.add(line);
                                break;
                            }
                            this._ini.add(String.format("%s?=%s", key, value));
                            break;
                        }
                        this._ini.add(line);
                        break;
                    }
                    case "INI-TEMPLATE": {
                        this._iniTemplate.add(line);
                        break;
                    }
                    case "LIB": 
                    case "LIBS": {
                        this._libs.add(line);
                        break;
                    }
                    case "JPMS": {
                        this._jpms.add(line);
                        break;
                    }
                    case "LICENSE": 
                    case "LICENSES": 
                    case "LICENCE": 
                    case "LICENCES": {
                        this._license.add(line);
                        break;
                    }
                    case "NAME": {
                        StartLog.warn("Deprecated [name] used in %s", basehome.toShortForm(this._path));
                        this._provides.add(line);
                        break;
                    }
                    case "PROVIDE": 
                    case "PROVIDES": {
                        this._provides.add(line);
                        break;
                    }
                    case "BEFORE": {
                        this._before.add(line);
                        break;
                    }
                    case "OPTIONAL": 
                    case "AFTER": {
                        this._after.add(line);
                        break;
                    }
                    case "EXEC": {
                        this._jvmArgs.add(line);
                        break;
                    }
                    case "VERSION": {
                        if (this.version != null) {
                            throw new IOException("[version] already specified");
                        }
                        this.version = new Version(line);
                        break;
                    }
                    case "XML": {
                        this._xmls.add(line);
                        break;
                    }
                    default: {
                        throw new IOException("Unrecognized module section: [" + sectionType + "]");
                    }
                }
            }
        }
        if (this.version == null) {
            this.version = new Version(VERSION_UNSPECIFIED);
        }
    }

    public boolean clearTransitiveEnable() {
        if (this._notTransitive) {
            throw new IllegalStateException("Not Transitive");
        }
        if (this.isEnabled()) {
            this._enables.clear();
            return true;
        }
        return false;
    }

    public void setSkipFilesValidation(boolean skipFilesValidation) {
        this._skipFilesValidation = skipFilesValidation;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getName());
        int sep = 123;
        if (this.isDynamic()) {
            str.append((char)sep).append("dynamic");
            sep = 44;
        }
        if (this.isEnabled()) {
            str.append((char)sep).append("enabled");
            sep = 44;
        }
        if (this.isTransitive()) {
            str.append((char)sep).append("transitive");
            sep = 44;
        }
        if (sep != 123) {
            str.append('}');
        }
        return str.toString();
    }

    public List<String> getDepends() {
        return new ArrayList<String>(this._depends);
    }

    public List<String> getDeprecated() {
        return List.copyOf(this._deprecated);
    }

    public Set<String> getProvides() {
        return new HashSet<String>(this._provides);
    }

    public Set<String> getBefore() {
        return Set.copyOf(this._before);
    }

    public Set<String> getAfter() {
        return Set.copyOf(this._after);
    }

    @Deprecated
    public Set<String> getOptional() {
        return this.getAfter();
    }

    public List<String> getDescription() {
        return this._description;
    }

    public List<String> getTags() {
        return this._tags;
    }

    public String getPrimaryTag() {
        return this._tags.isEmpty() ? "untagged" : this._tags.get(0);
    }

    public boolean isEnabled() {
        return !this._enables.isEmpty();
    }

    public Set<String> getEnableSources() {
        return new HashSet<String>(this._enables);
    }

    public boolean enable(String source, boolean transitive) {
        boolean updated = this._enables.isEmpty();
        if (transitive) {
            if (!this._notTransitive) {
                this._enables.add(source);
            }
        } else {
            if (!this._notTransitive) {
                updated = true;
                this._enables.clear();
            }
            this._notTransitive = true;
            this._enables.add(source);
        }
        return updated;
    }

    public boolean isTransitive() {
        return this.isEnabled() && !this._notTransitive;
    }

    public void writeIniSection(BufferedWriter writer, Props props) {
        PrintWriter out = new PrintWriter(writer);
        out.println("# --------------------------------------- ");
        out.println("# Module: " + this.getName());
        for (String line : this.getDescription()) {
            out.append("# ").println(line);
        }
        out.println("# --------------------------------------- ");
        out.println("--modules=" + this.getName());
        out.println();
        for (String line : this.getIniTemplate()) {
            Matcher m = SET_PROPERTY.matcher(line);
            if (m.matches() && m.groupCount() == 3) {
                String name = m.group(2);
                String value = m.group(3);
                Props.Prop p = props.getProp(name);
                if (!(p == null || p.source != null && p.source.endsWith("?=") || !"#".equals(m.group(1)) && value.equals(p.value))) {
                    System.err.printf("%s == %s :: %s%n", name, value, p.source);
                    StartLog.info("%-15s property set %s=%s", this._name, name, p.value);
                    out.printf("%s=%s%n", name, p.value);
                    continue;
                }
                out.println(line);
                continue;
            }
            out.println(line);
        }
        out.println();
        out.flush();
    }

    @Override
    public int compareTo(Module m) {
        int byTag = this.getPrimaryTag().compareTo(m.getPrimaryTag());
        if (byTag != 0) {
            return byTag;
        }
        return this.getName().compareTo(m.getName());
    }
}

