/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.websocket.server;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.ee8.nested.ContextHandler;
import org.eclipse.jetty.ee8.nested.HttpChannel;
import org.eclipse.jetty.ee8.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.ee8.websocket.server.JettyWebSocketServletFactory;
import org.eclipse.jetty.ee8.websocket.server.internal.DelegatedServerUpgradeRequest;
import org.eclipse.jetty.ee8.websocket.server.internal.DelegatedServerUpgradeResponse;
import org.eclipse.jetty.ee8.websocket.server.internal.JettyServerFrameHandlerFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.server.FrameHandlerFactory;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;
import org.eclipse.jetty.websocket.core.server.WebSocketCreator;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JettyWebSocketServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(JettyWebSocketServlet.class);
    private final CustomizedWebSocketServletFactory customizer = new CustomizedWebSocketServletFactory();
    private WebSocketMappings mappings;
    private WebSocketComponents components;

    protected abstract void configure(JettyWebSocketServletFactory var1);

    private FrameHandlerFactory getFactory() {
        JettyServerFrameHandlerFactory frameHandlerFactory = JettyServerFrameHandlerFactory.getFactory(this.getServletContext());
        if (frameHandlerFactory == null) {
            throw new IllegalStateException("JettyServerFrameHandlerFactory not found");
        }
        return frameHandlerFactory;
    }

    public void init() throws ServletException {
        try {
            String autoFragment;
            ServletContext servletContext = this.getServletContext();
            ContextHandler contextHandler = Objects.requireNonNull(ContextHandler.getContextHandler((ServletContext)servletContext));
            this.components = WebSocketServerComponents.getWebSocketComponents((org.eclipse.jetty.server.handler.ContextHandler)contextHandler.getCoreContextHandler());
            this.mappings = new WebSocketMappings(this.components);
            String max = this.getInitParameter("idleTimeout");
            if (max == null && (max = this.getInitParameter("maxIdleTime")) != null) {
                LOG.warn("'maxIdleTime' init param is deprecated, use 'idleTimeout' instead");
            }
            if (max != null) {
                this.customizer.setIdleTimeout(Duration.ofMillis(Long.parseLong(max)));
            }
            if ((max = this.getInitParameter("maxTextMessageSize")) != null) {
                this.customizer.setMaxTextMessageSize(Long.parseLong(max));
            }
            if ((max = this.getInitParameter("maxBinaryMessageSize")) != null) {
                this.customizer.setMaxBinaryMessageSize(Long.parseLong(max));
            }
            if ((max = this.getInitParameter("inputBufferSize")) != null) {
                this.customizer.setInputBufferSize(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("outputBufferSize")) != null) {
                this.customizer.setOutputBufferSize(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("maxFrameSize")) == null) {
                max = this.getInitParameter("maxAllowedFrameSize");
            }
            if (max != null) {
                this.customizer.setMaxFrameSize(Long.parseLong(max));
            }
            if ((autoFragment = this.getInitParameter("autoFragment")) != null) {
                this.customizer.setAutoFragment(Boolean.parseBoolean(autoFragment));
            }
            this.configure(this.customizer);
        }
        catch (Throwable x) {
            throw new ServletException(x);
        }
    }

    public void destroy() {
        this.mappings.clear();
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpChannel httpChannel = (HttpChannel)req.getAttribute(HttpChannel.class.getName());
        ContextHandler.CoreContextRequest request = httpChannel.getCoreRequest();
        Response response = httpChannel.getCoreResponse();
        if (this.mappings.getHandshaker().isWebSocketUpgradeRequest((Request)request)) {
            FutureCallback callback = new FutureCallback();
            try {
                request.setAttribute("org.eclipse.jetty.websocket.wrappedRequest", (Object)req);
                request.setAttribute("org.eclipse.jetty.websocket.wrappedResponse", (Object)resp);
                if (this.mappings.upgrade((Request)request, response, (Callback)callback, null)) {
                    callback.block();
                    return;
                }
            }
            finally {
                request.removeAttribute("org.eclipse.jetty.websocket.wrappedRequest");
                request.removeAttribute("org.eclipse.jetty.websocket.wrappedResponse");
            }
        }
        if (resp.isCommitted()) {
            return;
        }
        super.service(req, resp);
    }

    private class CustomizedWebSocketServletFactory
    extends Configuration.ConfigurationCustomizer
    implements JettyWebSocketServletFactory {
        private CustomizedWebSocketServletFactory() {
        }

        @Override
        public Set<String> getAvailableExtensionNames() {
            return JettyWebSocketServlet.this.components.getExtensionRegistry().getAvailableExtensionNames();
        }

        @Override
        public void addMapping(String pathSpec, JettyWebSocketCreator creator) {
            JettyWebSocketServlet.this.mappings.addMapping(WebSocketMappings.parsePathSpec((String)pathSpec), (WebSocketCreator)new WrappedJettyCreator(creator), JettyWebSocketServlet.this.getFactory(), (Configuration.Customizer)this);
        }

        @Override
        public void register(Class<?> endpointClass) {
            Constructor<?> constructor;
            try {
                constructor = endpointClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            JettyWebSocketCreator creator = (req, resp) -> {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    LOG.warn("Failed to construct new Endpoint", t);
                    return null;
                }
            };
            this.addMapping("/", creator);
        }

        @Override
        public void setCreator(JettyWebSocketCreator creator) {
            this.addMapping("/", creator);
        }

        @Override
        public JettyWebSocketCreator getMapping(String pathSpec) {
            WebSocketCreator creator = JettyWebSocketServlet.this.mappings.getWebSocketCreator(WebSocketMappings.parsePathSpec((String)pathSpec));
            if (creator instanceof WrappedJettyCreator) {
                return ((WrappedJettyCreator)creator).getJettyWebSocketCreator();
            }
            return null;
        }

        @Override
        public boolean removeMapping(String pathSpec) {
            return JettyWebSocketServlet.this.mappings.removeMapping(WebSocketMappings.parsePathSpec((String)pathSpec));
        }
    }

    private record WrappedJettyCreator(JettyWebSocketCreator creator) implements WebSocketCreator
    {
        private JettyWebSocketCreator getJettyWebSocketCreator() {
            return this.creator;
        }

        public Object createWebSocket(ServerUpgradeRequest request, ServerUpgradeResponse response, Callback callback) {
            try {
                Object webSocket = this.creator.createWebSocket(new DelegatedServerUpgradeRequest(request), new DelegatedServerUpgradeResponse(response));
                callback.succeeded();
                return webSocket;
            }
            catch (Throwable t) {
                callback.failed(t);
                return null;
            }
        }
    }
}

