/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.security.openid.OpenIdAuthenticatorConfiguration;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.security.openid.OpenIdCredentials;
import org.eclipse.jetty.security.openid.OpenIdLoginService;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(OpenIdAuthenticator.class);
    public static final String CLAIMS = "org.eclipse.jetty.security.openid.claims";
    public static final String RESPONSE = "org.eclipse.jetty.security.openid.response";
    public static final String ISSUER = "org.eclipse.jetty.security.openid.issuer";
    public static final String REDIRECT_PATH = "org.eclipse.jetty.security.openid.redirect_path";
    public static final String LOGOUT_REDIRECT_PATH = "org.eclipse.jetty.security.openid.logout_redirect_path";
    public static final String ERROR_PAGE = "org.eclipse.jetty.security.openid.error_page";
    public static final String J_URI = "org.eclipse.jetty.security.openid.URI";
    public static final String J_POST = "org.eclipse.jetty.security.openid.POST";
    public static final String J_METHOD = "org.eclipse.jetty.security.openid.METHOD";
    public static final String J_SECURITY_CHECK = "/j_security_check";
    public static final String ERROR_PARAMETER = "error_description_jetty";
    private static final String CSRF_MAP = "org.eclipse.jetty.security.openid.csrf_map";
    @Deprecated
    public static final String CSRF_TOKEN = "org.eclipse.jetty.security.openid.csrf_token";
    private final SecureRandom _secureRandom = new SecureRandom();
    private OpenIdConfiguration _openIdConfiguration;
    private String _redirectPath;
    private String _logoutRedirectPath;
    private String _errorPage;
    private String _errorPath;
    private String _errorQuery;
    private boolean _alwaysSaveUri;

    public OpenIdAuthenticator() {
        this(null, J_SECURITY_CHECK, null);
    }

    public OpenIdAuthenticator(OpenIdConfiguration configuration) {
        this(configuration, J_SECURITY_CHECK, null);
    }

    public OpenIdAuthenticator(OpenIdConfiguration configuration, String errorPage) {
        this(configuration, J_SECURITY_CHECK, errorPage);
    }

    public OpenIdAuthenticator(OpenIdConfiguration configuration, String redirectPath, String errorPage) {
        this(configuration, redirectPath, errorPage, null);
    }

    public OpenIdAuthenticator(OpenIdConfiguration configuration, String redirectPath, String errorPage, String logoutRedirectPath) {
        this._openIdConfiguration = configuration;
        this.setRedirectPath(redirectPath);
        if (errorPage != null) {
            this.setErrorPage(errorPage);
        }
        if (logoutRedirectPath != null) {
            this.setLogoutRedirectPath(logoutRedirectPath);
        }
    }

    public void setConfiguration(Authenticator.Configuration authConfig) {
        String logout;
        String error;
        String redirectPath;
        if (this._openIdConfiguration == null) {
            LoginService loginService = authConfig.getLoginService();
            if (!(loginService instanceof OpenIdLoginService)) {
                throw new IllegalArgumentException("invalid LoginService " + String.valueOf(loginService));
            }
            this._openIdConfiguration = ((OpenIdLoginService)loginService).getConfiguration();
        }
        if ((redirectPath = authConfig.getParameter(REDIRECT_PATH)) != null) {
            this.setRedirectPath(redirectPath);
        }
        if ((error = authConfig.getParameter(ERROR_PAGE)) != null) {
            this.setErrorPage(error);
        }
        if ((logout = authConfig.getParameter(LOGOUT_REDIRECT_PATH)) != null) {
            this.setLogoutRedirectPath(logout);
        }
        super.setConfiguration((Authenticator.Configuration)new OpenIdAuthenticatorConfiguration(this._openIdConfiguration, authConfig));
    }

    public String getAuthenticationType() {
        return "OPENID";
    }

    @Deprecated
    public void setAlwaysSaveUri(boolean alwaysSave) {
        this._alwaysSaveUri = alwaysSave;
    }

    @Deprecated
    public boolean isAlwaysSaveUri() {
        return this._alwaysSaveUri;
    }

    public void setRedirectPath(String redirectPath) {
        if (redirectPath == null) {
            LOG.warn("redirect path must not be null, defaulting to /j_security_check");
            redirectPath = J_SECURITY_CHECK;
        } else if (!((String)redirectPath).startsWith("/")) {
            LOG.warn("redirect path must start with /");
            redirectPath = "/" + (String)redirectPath;
        }
        this._redirectPath = redirectPath;
    }

    public void setLogoutRedirectPath(String logoutRedirectPath) {
        if (logoutRedirectPath == null) {
            LOG.warn("redirect path must not be null, defaulting to /");
            logoutRedirectPath = "/";
        } else if (!((String)logoutRedirectPath).startsWith("/")) {
            LOG.warn("redirect path must start with /");
            logoutRedirectPath = "/" + (String)logoutRedirectPath;
        }
        this._logoutRedirectPath = logoutRedirectPath;
    }

    public void setErrorPage(String path) {
        if (path == null || ((String)path).trim().length() == 0) {
            this._errorPath = null;
            this._errorPage = null;
        } else {
            if (!((String)path).startsWith("/")) {
                LOG.warn("error-page must start with /");
                path = "/" + (String)path;
            }
            this._errorPage = path;
            this._errorPath = path;
            this._errorQuery = "";
            int queryIndex = this._errorPath.indexOf(63);
            if (queryIndex > 0) {
                this._errorPath = this._errorPage.substring(0, queryIndex);
                this._errorQuery = this._errorPage.substring(queryIndex + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserIdentity login(String username, Object credentials, Request request, Response response) {
        UserIdentity user;
        if (LOG.isDebugEnabled()) {
            LOG.debug("login {} {} {}", new Object[]{username, credentials, request});
        }
        if ((user = super.login(username, credentials, request, response)) != null) {
            Session session = request.getSession(true);
            SessionAuthentication cached = new SessionAuthentication(this.getAuthenticationType(), user, credentials);
            Session session2 = session;
            synchronized (session2) {
                session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)cached);
                session.setAttribute(CLAIMS, ((OpenIdCredentials)credentials).getClaims());
                session.setAttribute(RESPONSE, ((OpenIdCredentials)credentials).getResponse());
                session.setAttribute(ISSUER, (Object)this._openIdConfiguration.getIssuer());
            }
        }
        return user;
    }

    public void logout(Request request, Response response) {
        this.attemptLogoutRedirect(request, response);
        this.logoutWithoutRedirect(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logoutWithoutRedirect(Request request, Response response) {
        super.logout(request, response);
        Session session = request.getSession(false);
        if (session == null) {
            return;
        }
        Session session2 = session;
        synchronized (session2) {
            session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
            session.removeAttribute(CLAIMS);
            session.removeAttribute(RESPONSE);
            session.removeAttribute(ISSUER);
        }
    }

    private boolean hasExpiredIdToken(Session session) {
        Map claims;
        if (session != null && (claims = (Map)session.getAttribute(CLAIMS)) != null) {
            return OpenIdCredentials.checkExpiry(claims);
        }
        return false;
    }

    private void attemptLogoutRedirect(Request request, Response response) {
        try {
            String endSessionEndpoint = this._openIdConfiguration.getEndSessionEndpoint();
            String redirectUri = null;
            if (this._logoutRedirectPath != null) {
                HttpURI.Mutable httpURI = HttpURI.build().scheme(request.getHttpURI().getScheme()).host(Request.getServerName((Request)request)).port(Request.getServerPort((Request)request)).path(URIUtil.compactPath((String)(Request.getContextPath((Request)request) + this._logoutRedirectPath)));
                redirectUri = httpURI.toString();
            }
            Session session = request.getSession(false);
            if (endSessionEndpoint == null || session == null) {
                if (redirectUri != null) {
                    this.sendRedirect(request, response, redirectUri);
                }
                return;
            }
            Object openIdResponse = session.getAttribute(RESPONSE);
            if (!(openIdResponse instanceof Map)) {
                if (redirectUri != null) {
                    this.sendRedirect(request, response, redirectUri);
                }
                return;
            }
            String idToken = (String)((Map)openIdResponse).get("id_token");
            this.sendRedirect(request, response, endSessionEndpoint + "?id_token_hint=" + UrlEncoded.encodeString((String)idToken, (Charset)StandardCharsets.UTF_8) + (String)(redirectUri == null ? "" : "&post_logout_redirect_uri=" + UrlEncoded.encodeString((String)redirectUri, (Charset)StandardCharsets.UTF_8)));
        }
        catch (Throwable t) {
            LOG.warn("failed to redirect to end_session_endpoint", t);
        }
    }

    private void sendRedirect(Request request, Response response, String location) throws IOException {
        try (Blocker.Callback callback = Blocker.callback();){
            Response.sendRedirect((Request)request, (Response)response, (Callback)callback, (String)location);
            callback.block();
        }
    }

    public Request prepareRequest(Request request, AuthenticationState authenticationState) {
        if (authenticationState instanceof AuthenticationState.Succeeded) {
            Session session = request.getSession(false);
            if (session == null) {
                return request;
            }
            HttpURI juri = (HttpURI)session.getAttribute(J_URI);
            HttpURI uri = request.getHttpURI();
            if (uri.equals((Object)juri)) {
                String method;
                session.removeAttribute(J_URI);
                Fields fields = (Fields)session.removeAttribute(J_POST);
                if (fields != null) {
                    request.setAttribute(FormFields.class.getName(), (Object)fields);
                }
                if ((method = (String)session.removeAttribute(J_METHOD)) != null && request.getMethod().equals(method)) {
                    return new Request.Wrapper(this, request){
                        final /* synthetic */ OpenIdAuthenticator this$0;
                        {
                            this.this$0 = this$0;
                            super(arg0);
                        }

                        public String getMethod() {
                            return method;
                        }
                    };
                }
            }
        }
        return request;
    }

    protected Fields getParameters(Request request) {
        try {
            Fields queryFields = Request.extractQueryParameters((Request)request);
            Fields formFields = (Fields)FormFields.from((Request)request).get();
            return Fields.combine((Fields)queryFields, (Fields)formFields);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Constraint.Authorization getConstraintAuthentication(String pathInContext, Constraint.Authorization existing, Function<Boolean, Session> getSession) {
        Session session = getSession.apply(false);
        if (this._openIdConfiguration.isLogoutWhenIdTokenIsExpired() && this.hasExpiredIdToken(session)) {
            return Constraint.Authorization.ANY_USER;
        }
        if (this.isJSecurityCheck(pathInContext)) {
            return Constraint.Authorization.ANY_USER;
        }
        if (this.isErrorPage(pathInContext)) {
            return Constraint.Authorization.ALLOWED;
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationState validateRequest(Request request, Response response, Callback cb) throws ServerAuthException {
        String uri;
        if (LOG.isDebugEnabled()) {
            LOG.debug("validateRequest({},{})", (Object)request, (Object)response);
        }
        if ((uri = request.getHttpURI().toString()) == null) {
            uri = "/";
        }
        Session session = request.getSession(false);
        if (this._openIdConfiguration.isLogoutWhenIdTokenIsExpired() && this.hasExpiredIdToken(session)) {
            this.logoutWithoutRedirect(request, response);
        }
        try {
            if (session == null) {
                session = request.getSession(true);
            }
            if (session == null) {
                this.sendError(request, response, cb, "session could not be created");
                return AuthenticationState.SEND_FAILURE;
            }
            if (this.isJSecurityCheck(uri)) {
                UriRedirectInfo uriRedirectInfo;
                Fields parameters = this.getParameters(request);
                String authCode = parameters.getValue("code");
                if (authCode == null) {
                    this.sendError(request, response, cb, "auth failed: no code parameter");
                    return AuthenticationState.SEND_FAILURE;
                }
                String state = parameters.getValue("state");
                if (state == null) {
                    this.sendError(request, response, cb, "auth failed: no state parameter");
                    return AuthenticationState.SEND_FAILURE;
                }
                Session session2 = session;
                synchronized (session2) {
                    uriRedirectInfo = this.removeAndClearCsrfMap(session, state);
                }
                if (uriRedirectInfo == null) {
                    this.sendError(request, response, cb, "auth failed: invalid state parameter");
                    return AuthenticationState.SEND_FAILURE;
                }
                OpenIdCredentials credentials = new OpenIdCredentials(authCode, this.getRedirectUri(request));
                UserIdentity user = this.login(null, credentials, request, response);
                if (user == null) {
                    this.sendError(request, response, cb, null);
                    return AuthenticationState.SEND_FAILURE;
                }
                LoginAuthenticator.UserAuthenticationSent openIdAuth = new LoginAuthenticator.UserAuthenticationSent(this.getAuthenticationType(), user);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("authenticated {}->{}", (Object)openIdAuth, (Object)uriRedirectInfo.getUri());
                }
                Session session3 = session;
                synchronized (session3) {
                    session.setAttribute(J_URI, (Object)uriRedirectInfo.getUri().asImmutable());
                    session.setAttribute(J_METHOD, (Object)uriRedirectInfo.getMethod());
                    session.setAttribute(J_POST, uriRedirectInfo.getFormParameters());
                }
                response.getHeaders().put(HttpFields.CONTENT_LENGTH_0);
                int redirectCode = request.getConnectionMetaData().getHttpVersion().getVersion() < HttpVersion.HTTP_1_1.getVersion() ? 302 : 303;
                Response.sendRedirect((Request)request, (Response)response, (Callback)cb, (int)redirectCode, (String)uriRedirectInfo.getUri().toString(), (boolean)true);
                return openIdAuth;
            }
            AuthenticationState authenticationState = (AuthenticationState)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
            if (authenticationState != null) {
                if (authenticationState instanceof AuthenticationState.Succeeded && this._loginService != null && !this._loginService.validate(((AuthenticationState.Succeeded)authenticationState).getUserIdentity())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("auth revoked {}", (Object)authenticationState);
                    }
                    this.logoutWithoutRedirect(request, response);
                } else {
                    Session authCode = session;
                    synchronized (authCode) {
                        HttpURI jUri = (HttpURI)session.getAttribute(J_URI);
                        if (jUri != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("auth retry {}->{}", (Object)authenticationState, (Object)jUri);
                            }
                            if (jUri.equals((Object)request.getHttpURI())) {
                                MultiMap jPost = (MultiMap)session.getAttribute(J_POST);
                                if (jPost != null && LOG.isDebugEnabled()) {
                                    LOG.debug("auth rePOST {}->{}", (Object)authenticationState, (Object)jUri);
                                }
                                session.removeAttribute(J_URI);
                                session.removeAttribute(J_METHOD);
                                session.removeAttribute(J_POST);
                            }
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("auth {}", (Object)authenticationState);
                    }
                    return authenticationState;
                }
            }
            if (AuthenticationState.Deferred.isDeferred((Response)response)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("auth deferred {}", (Object)session.getId());
                }
                return null;
            }
            Session authCode = session;
            synchronized (authCode) {
                if (session.getAttribute(J_URI) == null || this._alwaysSaveUri) {
                    HttpURI juri = request.getHttpURI();
                    session.setAttribute(J_URI, (Object)juri.asImmutable());
                    if (!HttpMethod.GET.is(request.getMethod())) {
                        session.setAttribute(J_METHOD, (Object)request.getMethod());
                    }
                    if (HttpMethod.POST.is(request.getMethod())) {
                        try {
                            session.setAttribute(J_POST, FormFields.from((Request)request).get());
                        }
                        catch (ExecutionException e) {
                            throw new ServerAuthException(e.getCause());
                        }
                        catch (InterruptedException e) {
                            throw new ServerAuthException((Throwable)e);
                        }
                    }
                }
            }
            String challengeUri = this.getChallengeUri(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("challenge {}->{}", (Object)session.getId(), (Object)challengeUri);
            }
            int redirectCode = request.getConnectionMetaData().getHttpVersion().getVersion() < HttpVersion.HTTP_1_1.getVersion() ? 302 : 303;
            Response.sendRedirect((Request)request, (Response)response, (Callback)cb, (int)redirectCode, (String)challengeUri, (boolean)true);
            return AuthenticationState.CHALLENGE;
        }
        catch (IOException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    private void sendError(Request request, Response response, Callback callback, String message) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("OpenId authentication FAILED: {}", (Object)message);
        }
        if (this._errorPage == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("auth failed 403");
            }
            if (response != null) {
                Response.writeError((Request)request, (Response)response, (Callback)callback, (int)403);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("auth failed {}", (Object)this._errorPage);
            }
            String contextPath = Request.getContextPath((Request)request);
            String redirectUri = URIUtil.addPaths((String)contextPath, (String)this._errorPage);
            if (message != null) {
                String query = URIUtil.addQueries((String)("error_description_jetty=" + UrlEncoded.encodeString((String)message)), (String)this._errorQuery);
                redirectUri = URIUtil.addPathQuery((String)URIUtil.addPaths((String)contextPath, (String)this._errorPath), (String)query);
            }
            int redirectCode = request.getConnectionMetaData().getHttpVersion().getVersion() < HttpVersion.HTTP_1_1.getVersion() ? 302 : 303;
            Response.sendRedirect((Request)request, (Response)response, (Callback)callback, (int)redirectCode, (String)redirectUri, (boolean)true);
        }
    }

    public boolean isJSecurityCheck(String uri) {
        int jsc = uri.indexOf(this._redirectPath);
        if (jsc < 0) {
            return false;
        }
        int e = jsc + this._redirectPath.length();
        if (e == uri.length()) {
            return true;
        }
        char c = uri.charAt(e);
        return c == ';' || c == '#' || c == '/' || c == '?';
    }

    public boolean isErrorPage(String pathInContext) {
        return pathInContext != null && pathInContext.equals(this._errorPath);
    }

    private String getRedirectUri(Request request) {
        StringBuilder redirectUri = URIUtil.newURIBuilder((String)request.getHttpURI().getScheme(), (String)Request.getServerName((Request)request), (int)Request.getServerPort((Request)request));
        redirectUri.append(URIUtil.addPaths((String)request.getContext().getContextPath(), (String)this._redirectPath));
        return redirectUri.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getChallengeUri(Request request) {
        String antiForgeryToken;
        Session session;
        Session session2 = session = request.getSession(true);
        synchronized (session2) {
            Map<String, UriRedirectInfo> csrfMap = this.ensureCsrfMap(session);
            antiForgeryToken = new BigInteger(130, this._secureRandom).toString(32);
            csrfMap.put(antiForgeryToken, new UriRedirectInfo(request));
        }
        StringBuilder scopes = new StringBuilder();
        for (String s : this._openIdConfiguration.getScopes()) {
            scopes.append(" ").append(s);
        }
        return this._openIdConfiguration.getAuthEndpoint() + "?client_id=" + UrlEncoded.encodeString((String)this._openIdConfiguration.getClientId(), (Charset)StandardCharsets.UTF_8) + "&redirect_uri=" + UrlEncoded.encodeString((String)this.getRedirectUri(request), (Charset)StandardCharsets.UTF_8) + "&scope=openid" + UrlEncoded.encodeString((String)scopes.toString(), (Charset)StandardCharsets.UTF_8) + "&state=" + antiForgeryToken + "&response_type=code";
    }

    private UriRedirectInfo removeAndClearCsrfMap(Session session, String csrf) {
        Map csrfMap = (Map)session.getAttribute(CSRF_MAP);
        if (csrfMap == null) {
            return null;
        }
        UriRedirectInfo uriRedirectInfo = (UriRedirectInfo)csrfMap.get(csrf);
        csrfMap.clear();
        return uriRedirectInfo;
    }

    private Map<String, UriRedirectInfo> ensureCsrfMap(Session session) {
        Map csrfMap = (Map)session.getAttribute(CSRF_MAP);
        if (csrfMap == null) {
            csrfMap = new MRUMap(64);
            session.setAttribute(CSRF_MAP, (Object)csrfMap);
        }
        return csrfMap;
    }

    private static class UriRedirectInfo
    implements Serializable {
        private static final long serialVersionUID = 139567755844461433L;
        private final HttpURI _uri;
        private final String _method;
        private final MultiMap<String> _formParameters;

        public UriRedirectInfo(Request request) {
            this._uri = request.getHttpURI();
            this._method = request.getMethod();
            this._formParameters = MimeTypes.Type.FORM_ENCODED.is(request.getHeaders().get(HttpHeader.CONTENT_TYPE)) && HttpMethod.POST.is(request.getMethod()) ? new MultiMap() : null;
        }

        public HttpURI getUri() {
            return this._uri;
        }

        public String getMethod() {
            return this._method;
        }

        public MultiMap<String> getFormParameters() {
            return this._formParameters;
        }
    }

    private static class MRUMap
    extends LinkedHashMap<String, UriRedirectInfo> {
        private static final long serialVersionUID = 5375723072014233L;
        private final int _size;

        private MRUMap(int size) {
            this._size = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, UriRedirectInfo> eldest) {
            return this.size() > this._size;
        }
    }
}

