/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.RawArgs;
import org.eclipse.jetty.start.UsageException;
import org.eclipse.jetty.start.Utils;
import org.eclipse.jetty.start.config.ConfigSource;

public class CommandLineConfigSource
implements ConfigSource {
    public static final String ORIGIN_INTERNAL_FALLBACK = "<internal-fallback>";
    public static final String ORIGIN_CMD_LINE = "<command-line>";
    public static final String ORIGIN_SYSTEM_PROPERTY = "<system-property>";
    private final RawArgs args = new RawArgs();
    private final Props props = new Props();
    private final Path homePath;
    private final Path basePath;

    public CommandLineConfigSource(String[] rawargs) {
        for (String arg : rawargs) {
            this.args.addArg(arg, ORIGIN_CMD_LINE);
            this.props.addPossibleProperty(arg, ORIGIN_CMD_LINE);
        }
        this.homePath = this.findJettyHomePath().toAbsolutePath();
        this.basePath = this.findJettyBasePath().toAbsolutePath();
        this.setSystemProperty("jetty.home", this.homePath.toAbsolutePath().toString());
        this.setSystemProperty("jetty.base", this.basePath.toAbsolutePath().toString());
    }

    private final Path findJettyBasePath() {
        Props.Prop prop = this.props.getProp("jetty.base", false);
        if (prop != null && !Utils.isBlank(prop.value)) {
            return FS.toPath(prop.value);
        }
        String val = System.getProperty("jetty.base");
        if (!Utils.isBlank(val)) {
            this.setProperty("jetty.base", val, ORIGIN_SYSTEM_PROPERTY);
            return FS.toPath(val);
        }
        Path base = FS.toPath(this.props.getString("user.dir", "."));
        this.setProperty("jetty.base", base.toString(), ORIGIN_INTERNAL_FALLBACK);
        return base;
    }

    private final Path findJettyHomePath() {
        Matcher m;
        Props.Prop prop = this.props.getProp("jetty.home", false);
        if (prop != null && !Utils.isBlank(prop.value)) {
            return FS.toPath(prop.value);
        }
        String val = System.getProperty("jetty.home");
        if (!Utils.isBlank(val)) {
            this.setProperty("jetty.home", val, ORIGIN_SYSTEM_PROPERTY);
            return FS.toPath(val);
        }
        String classRef = "org/eclipse/jetty/start/Main.class";
        URL jarfile = this.getClass().getClassLoader().getResource(classRef);
        if (jarfile != null && (m = Pattern.compile("jar:(file:.*)!/" + classRef).matcher(jarfile.toString())).matches()) {
            try {
                Path home = Paths.get(new URI(m.group(1))).getParent();
                this.setProperty("jetty.home", home.toString(), ORIGIN_INTERNAL_FALLBACK);
                return home;
            }
            catch (URISyntaxException e) {
                throw new UsageException(-9, (Throwable)e);
            }
        }
        Path home = FS.toPath(System.getProperty("user.dir", "."));
        this.setProperty("jetty.home", home.toString(), "<user.dir>");
        return home;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandLineConfigSource other = (CommandLineConfigSource)obj;
        return !(this.args == null ? other.args != null : !this.args.equals(other.args));
    }

    @Override
    public RawArgs getArgs() {
        return this.args;
    }

    public Path getBasePath() {
        return this.basePath;
    }

    public Path getHomePath() {
        return this.homePath;
    }

    @Override
    public String getId() {
        return ORIGIN_CMD_LINE;
    }

    @Override
    public String getProperty(String key) {
        return this.props.getString(key);
    }

    @Override
    public Props getProps() {
        return this.props;
    }

    @Override
    public int getWeight() {
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.args == null ? 0 : this.args.hashCode());
        return result;
    }

    public void setProperty(String key, String value, String origin) {
        this.props.setProperty(key, value, origin);
    }

    public void setSystemProperty(String key, String value) {
        this.props.setSystemProperty(key, value);
    }

    public String toString() {
        return String.format("%s[%s,args.length=%d]", this.getClass().getSimpleName(), this.getId(), this.getArgs().size());
    }
}

