/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.eclipse.jetty.nosql.NoSqlSessionDataStore;
import org.eclipse.jetty.nosql.mongodb.MongoUtils;
import org.eclipse.jetty.session.SessionContext;
import org.eclipse.jetty.session.SessionData;
import org.eclipse.jetty.session.UnreadableSessionDataException;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public class MongoSessionDataStore
extends NoSqlSessionDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(MongoSessionDataStore.class);
    public static final String __METADATA = "__metadata__";
    public static final String __CONTEXT = "context";
    public static final String __VERSION = "__metadata__.version";
    public static final String __LASTSAVED = "__metadata__.lastSaved";
    public static final String __LASTNODE = "__metadata__.lastNode";
    public static final String __ACCESSED = "accessed";
    public static final String __LAST_ACCESSED = "lastAccessed";
    public static final String __ATTRIBUTES = "attributes";
    public static final String __EXPIRY = "expiry";
    public static final String __MAX_IDLE = "maxIdle";
    public static final String __CREATED = "created";
    public static final String __VALID = "valid";
    public static final String __ID = "id";
    private DBObject _version1;
    private MongoCollection<Document> _dbSessions;

    public void setDBCollection(MongoCollection<Document> collection) {
        this._dbSessions = collection;
    }

    @ManagedAttribute(value="DBCollection", readonly=true)
    public MongoCollection<Document> getDBCollection() {
        return this._dbSessions;
    }

    public SessionData doLoad(String id) throws Exception {
        Document sessionDocument = (Document)this._dbSessions.find(Filters.eq((String)__ID, (Object)id)).first();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("id={} loaded={}", (Object)id, (Object)sessionDocument);
            }
            if (sessionDocument == null) {
                return null;
            }
            Boolean valid = (Boolean)sessionDocument.get((Object)__VALID);
            if (LOG.isDebugEnabled()) {
                LOG.debug("id={} valid={}", (Object)id, (Object)valid);
            }
            if (valid == null || !valid.booleanValue()) {
                return null;
            }
            Object version = MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(__VERSION));
            Long lastSaved = (Long)MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(__LASTSAVED));
            String lastNode = (String)MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(__LASTNODE));
            Binary binary = (Binary)MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(__ATTRIBUTES));
            byte[] attributes = binary == null ? null : binary.getData();
            Long created = (Long)sessionDocument.get((Object)__CREATED);
            Long accessed = (Long)sessionDocument.get((Object)__ACCESSED);
            Long lastAccessed = (Long)sessionDocument.get((Object)__LAST_ACCESSED);
            Long maxInactive = (Long)sessionDocument.get((Object)__MAX_IDLE);
            Long expiry = (Long)sessionDocument.get((Object)__EXPIRY);
            NoSqlSessionDataStore.NoSqlSessionData data = null;
            Document sessionSubDocumentForContext = (Document)MongoUtils.getNestedValue(sessionDocument, this.getContextField());
            if (LOG.isDebugEnabled()) {
                LOG.debug("attrs {}", (Object)sessionSubDocumentForContext);
            }
            if (sessionSubDocumentForContext != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session {} present for context {}", (Object)id, (Object)this._context);
                }
                data = (NoSqlSessionDataStore.NoSqlSessionData)this.newSessionData(id, created, accessed, lastAccessed == null ? accessed : lastAccessed, maxInactive);
                data.setVersion(version);
                data.setExpiry(expiry);
                data.setContextPath(this._context.getCanonicalContextPath());
                data.setVhost(this._context.getVhost());
                data.setLastSaved(lastSaved);
                data.setLastNode(lastNode);
                if (attributes == null) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String name : sessionSubDocumentForContext.keySet()) {
                        if (__METADATA.equals(name)) continue;
                        String attr = MongoUtils.decodeName(name);
                        Object value = MongoUtils.decodeValue(sessionSubDocumentForContext.get((Object)name));
                        map.put(attr, value);
                    }
                    data.putAllAttributes(map);
                } else {
                    try (ByteArrayInputStream bais = new ByteArrayInputStream(attributes);){
                        this.deserializeAttributes(data, bais);
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Session  {} not present for context {}", (Object)id, (Object)this._context);
            }
            return data;
        }
        catch (Exception e) {
            throw new UnreadableSessionDataException(id, this._context, (Throwable)e);
        }
    }

    public boolean delete(String id) throws Exception {
        Bson filterId;
        Document sessionDocument;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Remove:session {} for context {}", (Object)id, (Object)this._context);
        }
        if ((sessionDocument = (Document)this._dbSessions.find(filterId = Filters.eq((String)__ID, (Object)id)).first()) != null) {
            Document c = (Document)MongoUtils.getNestedValue(sessionDocument, __CONTEXT);
            if (c == null) {
                this._dbSessions.deleteOne(filterId);
                return false;
            }
            Set contexts = c.keySet();
            if (contexts.isEmpty()) {
                this._dbSessions.deleteOne(filterId);
                return false;
            }
            if (contexts.size() == 1 && ((String)contexts.iterator().next()).equals(this.getCanonicalContextId())) {
                this._dbSessions.deleteOne(filterId);
                return true;
            }
            BasicDBObject remove = new BasicDBObject();
            BasicDBObject unsets = new BasicDBObject();
            unsets.put((Object)this.getContextField(), (Object)1);
            remove.put((Object)"$unset", (Object)unsets);
            this._dbSessions.updateOne(filterId, (Bson)remove);
            return true;
        }
        return false;
    }

    public boolean doExists(String id) throws Exception {
        Bson projection = Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{__ID, __VALID, __EXPIRY, __VERSION, this.getContextField()}), Projections.excludeId()});
        Bson filterId = Filters.eq((String)__ID, (Object)id);
        Document sessionDocument = (Document)this._dbSessions.find(filterId).projection(projection).first();
        if (sessionDocument == null) {
            return false;
        }
        Boolean valid = (Boolean)sessionDocument.get((Object)__VALID);
        if (!valid.booleanValue()) {
            return false;
        }
        Long expiry = (Long)sessionDocument.get((Object)__EXPIRY);
        if (expiry != null && expiry > 0L && expiry < System.currentTimeMillis()) {
            return false;
        }
        Object version = MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(__VERSION));
        return version != null;
    }

    public Set<String> doCheckExpired(Set<String> candidates, long time) {
        Bson query = Filters.and((Bson[])new Bson[]{Filters.in((String)__ID, candidates), Filters.gt((String)__EXPIRY, (Object)0), Filters.lte((String)__EXPIRY, (Object)time)});
        FindIterable verifiedExpiredSessions = this._dbSessions.find(query);
        Set<String> expiredSessions = StreamSupport.stream(verifiedExpiredSessions.spliterator(), false).map(document -> document.getString((Object)__ID)).collect(Collectors.toSet());
        for (String c : candidates) {
            if (expiredSessions.contains(c)) continue;
            try {
                if (this.exists(c)) continue;
                expiredSessions.add(c);
            }
            catch (Exception e) {
                LOG.warn("Problem checking potentially expired session {}", (Object)c, (Object)e);
            }
        }
        return expiredSessions;
    }

    public Set<String> doGetExpired(long timeLimit) {
        Bson query = Filters.and((Bson[])new Bson[]{Filters.gt((String)__EXPIRY, (Object)0), Filters.lte((String)__EXPIRY, (Object)timeLimit)});
        FindIterable documents = this._dbSessions.find(query);
        Set<String> expiredSessions = StreamSupport.stream(documents.spliterator(), false).map(document -> document.getString((Object)__ID)).collect(Collectors.toSet());
        return expiredSessions;
    }

    public void doCleanOrphans(long timeLimit) {
        Bson query = Filters.and((Bson[])new Bson[]{Filters.gt((String)__EXPIRY, (Object)0), Filters.lte((String)__EXPIRY, (Object)timeLimit)});
        this._dbSessions.deleteMany(query);
    }

    public void initialize(SessionContext context) throws Exception {
        if (this.isStarted()) {
            throw new IllegalStateException("Context set after SessionDataStore started");
        }
        this._context = context;
        this.ensureIndexes();
    }

    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        Bson key = Filters.eq((String)__ID, (Object)id);
        BasicDBObject update = new BasicDBObject();
        boolean upsert = false;
        BasicDBObject sets = new BasicDBObject();
        Object version = ((NoSqlSessionDataStore.NoSqlSessionData)data).getVersion();
        if (lastSaveTime <= 0L) {
            upsert = true;
            version = 1L;
            sets.put((Object)__CREATED, (Object)data.getCreated());
            sets.put((Object)__VALID, (Object)true);
            sets.put((Object)this.getContextSubfield(__VERSION), version);
            sets.put((Object)this.getContextSubfield(__LASTSAVED), (Object)data.getLastSaved());
            sets.put((Object)this.getContextSubfield(__LASTNODE), (Object)data.getLastNode());
            sets.put((Object)__MAX_IDLE, (Object)data.getMaxInactiveMs());
            sets.put((Object)__EXPIRY, (Object)data.getExpiry());
            ((NoSqlSessionDataStore.NoSqlSessionData)data).setVersion(version);
        } else {
            sets.put((Object)this.getContextSubfield(__LASTSAVED), (Object)data.getLastSaved());
            sets.put((Object)this.getContextSubfield(__LASTNODE), (Object)data.getLastNode());
            version = ((Number)version).longValue() + 1L;
            ((NoSqlSessionDataStore.NoSqlSessionData)data).setVersion(version);
            BasicDBObject fields = new BasicDBObject();
            fields.append(__MAX_IDLE, (Object)true);
            fields.append(__EXPIRY, (Object)true);
            Document o = (Document)this._dbSessions.find(key).first();
            if (o != null) {
                long currentExpiry;
                Long tmpLong = (Long)o.get((Object)__MAX_IDLE);
                long currentMaxIdle = tmpLong == null ? 0L : tmpLong;
                tmpLong = (Long)o.get((Object)__EXPIRY);
                long l = currentExpiry = tmpLong == null ? 0L : tmpLong;
                if (currentMaxIdle != data.getMaxInactiveMs()) {
                    sets.put((Object)__MAX_IDLE, (Object)data.getMaxInactiveMs());
                }
                if (currentExpiry != data.getExpiry()) {
                    sets.put((Object)__EXPIRY, (Object)data.getExpiry());
                }
            } else {
                LOG.warn("Session {} not found, can't update", (Object)id);
            }
        }
        sets.put((Object)__ACCESSED, (Object)data.getAccessed());
        sets.put((Object)__LAST_ACCESSED, (Object)data.getLastAccessed());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.serializeAttributes(data, baos);
            Binary binary = new Binary(baos.toByteArray());
            sets.put((Object)this.getContextSubfield(__ATTRIBUTES), (Object)binary);
        }
        if (!sets.isEmpty()) {
            update.put((Object)"$set", (Object)sets);
        }
        UpdateResult res = this._dbSessions.updateOne(key, (Bson)update, new UpdateOptions().upsert(upsert));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Save:db.sessions.update( {}, {},{} )", new Object[]{key, update, res});
        }
    }

    protected void ensureIndexes() throws MongoException {
        String createResult;
        List indexes = StreamSupport.stream(this._dbSessions.listIndexes().spliterator(), false).toList();
        List<String> indexesNames = indexes.stream().map(document -> document.getString((Object)"name")).toList();
        if (!indexesNames.contains("id_1")) {
            createResult = this._dbSessions.createIndex(Indexes.text((String)__ID), new IndexOptions().unique(true).name("id_1").sparse(false));
            LOG.info("create index {}, result: {}", (Object)"id_1", (Object)createResult);
        }
        if (!indexesNames.contains("id_1_version_1")) {
            createResult = this._dbSessions.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.descending((String[])new String[]{__ID}), Indexes.descending((String[])new String[]{"version"})}), new IndexOptions().unique(false).name("id_1_version_1").sparse(false));
            LOG.info("create index {}, result: {}", (Object)"id_1_version_1", (Object)createResult);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done ensure Mongodb indexes existing");
        }
    }

    private String getContextField() {
        return "context." + this.getCanonicalContextId();
    }

    private String getCanonicalContextId() {
        return this.canonicalizeVHost(this._context.getVhost()) + ":" + this._context.getCanonicalContextPath();
    }

    private String canonicalizeVHost(String vhost) {
        if (vhost == null) {
            return "";
        }
        return StringUtil.replace((String)vhost, (char)'.', (char)'_');
    }

    private String getContextSubfield(String attr) {
        return this.getContextField() + "." + attr;
    }

    @ManagedAttribute(value="does store serialize sessions", readonly=true)
    public boolean isPassivating() {
        return true;
    }

    public String toString() {
        return String.format("%s[collection=%s]", super.toString(), this.getDBCollection());
    }
}

